/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.IncrementingSegmentFieldTransformer;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.schema.SchemaFieldSpec;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IncrementingSegmentSpec
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Core attributes required to identify an incrementing segment in a table. This type is mainly useful\nfor tables that constantly increase with new rows being added on a particular cadence (e.g. fact or event tables)\n\nAn incrementing segment represents a logical chunk of data which is INSERTED\ninto a dataset on a regular interval, along with the presence of a constantly-incrementing column\nvalue such as an event time, date partition, or last modified column.\n\nAn incrementing segment is principally identified by 2 key attributes combined:\n\n 1. A field or column that represents the incrementing value. New rows that are inserted will be identified using this column.\n    Note that the value of this column may not by itself represent the \"bucket\" or the \"segment\" in which the row falls.\n\n 2. [Optional] An transformer function that may be applied to the selected column value in order\n    to obtain the final \"segment identifier\" or \"bucket identifier\". Rows that have the same value after applying the transformation\n    will be grouped into the same segment, using which the final value (e.g. row count) will be determined.*/record IncrementingSegmentSpec{/**The field to use to generate segments. It must be constantly incrementing as new rows are inserted.*/field:{namespace com.linkedin.schema/**Lightweight spec used for referencing a particular schema field.\n*/record SchemaFieldSpec{/**The field path*/path:string/**The DataHub standard schema field type.*/type:string/**The native field type*/nativeType:string}}/**Optional transformer function to apply to the field in order to obtain the final segment or bucket identifier.\nIf not provided, then no operator will be applied to the field. (identity function)*/transformer:optional/**The definition of the transformer function  that should be applied to a given field / column value in a dataset\nin order to determine the segment or bucket that it belongs to, which in turn is used to evaluate\nvolume assertions.*/record IncrementingSegmentFieldTransformer{/**A 'standard' transformer type. Note that not all source systems will support all operators.*/type:enum IncrementingSegmentFieldTransformerType{/**Rounds a timestamp (in seconds) down to the start of the month.*/TIMESTAMP_MS_TO_MINUTE/**Rounds a timestamp (in milliseconds) down to the nearest hour.*/TIMESTAMP_MS_TO_HOUR/**Rounds a timestamp (in milliseconds) down to the start of the day.*/TIMESTAMP_MS_TO_DATE/**Rounds a timestamp (in milliseconds) down to the start of the month*/TIMESTAMP_MS_TO_MONTH/**Rounds a timestamp (in milliseconds) down to the start of the year*/TIMESTAMP_MS_TO_YEAR/**Rounds a numeric value down to the nearest integer.*/FLOOR/**Rounds a numeric value up to the nearest integer.*/CEILING/**A backdoor to provide a native operator type specific to a given source system like\nSnowflake, Redshift, BQ, etc.*/NATIVE}/**The 'native' transformer type, useful as a back door if a custom operator is required.\nThis field is required if the type is NATIVE.*/nativeType:optional string}}", SchemaFormatType.PDL);
    private SchemaFieldSpec _fieldField = null;
    private IncrementingSegmentFieldTransformer _transformerField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Field = SCHEMA.getField("field");
    private static final RecordDataSchema.Field FIELD_Transformer = SCHEMA.getField("transformer");

    public IncrementingSegmentSpec() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public IncrementingSegmentSpec(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasField() {
        if (this._fieldField != null) {
            return true;
        }
        return this._map.containsKey("field");
    }

    public void removeField() {
        this._map.remove("field");
    }

    @Nullable
    public SchemaFieldSpec getField(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getField();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fieldField != null) {
                    return this._fieldField;
                }
                Object __rawValue = this._map.get("field");
                this._fieldField = __rawValue == null ? null : new SchemaFieldSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._fieldField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SchemaFieldSpec getField() {
        if (this._fieldField != null) {
            return this._fieldField;
        }
        Object __rawValue = this._map.get("field");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("field");
        }
        this._fieldField = __rawValue == null ? null : new SchemaFieldSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._fieldField;
    }

    public IncrementingSegmentSpec setField(@Nullable SchemaFieldSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setField(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field field of com.linkedin.assertion.IncrementingSegmentSpec");
                }
                CheckedUtil.putWithoutChecking(this._map, "field", value.data());
                this._fieldField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeField();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "field", value.data());
                this._fieldField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "field", value.data());
                this._fieldField = value;
            }
        }
        return this;
    }

    public IncrementingSegmentSpec setField(@Nonnull SchemaFieldSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field field of com.linkedin.assertion.IncrementingSegmentSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "field", value.data());
        this._fieldField = value;
        return this;
    }

    public boolean hasTransformer() {
        if (this._transformerField != null) {
            return true;
        }
        return this._map.containsKey("transformer");
    }

    public void removeTransformer() {
        this._map.remove("transformer");
    }

    @Nullable
    public IncrementingSegmentFieldTransformer getTransformer(GetMode mode) {
        return this.getTransformer();
    }

    @Nullable
    public IncrementingSegmentFieldTransformer getTransformer() {
        if (this._transformerField != null) {
            return this._transformerField;
        }
        Object __rawValue = this._map.get("transformer");
        this._transformerField = __rawValue == null ? null : new IncrementingSegmentFieldTransformer(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._transformerField;
    }

    public IncrementingSegmentSpec setTransformer(@Nullable IncrementingSegmentFieldTransformer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTransformer(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTransformer();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "transformer", value.data());
                this._transformerField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "transformer", value.data());
                this._transformerField = value;
            }
        }
        return this;
    }

    public IncrementingSegmentSpec setTransformer(@Nonnull IncrementingSegmentFieldTransformer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field transformer of com.linkedin.assertion.IncrementingSegmentSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "transformer", value.data());
        this._transformerField = value;
        return this;
    }

    @Override
    public IncrementingSegmentSpec clone() throws CloneNotSupportedException {
        IncrementingSegmentSpec __clone = (IncrementingSegmentSpec)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IncrementingSegmentSpec copy() throws CloneNotSupportedException {
        IncrementingSegmentSpec __copy = (IncrementingSegmentSpec)super.copy();
        __copy._fieldField = null;
        __copy._transformerField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IncrementingSegmentSpec __objectRef;

        private ChangeListener(IncrementingSegmentSpec reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "field": {
                    this.__objectRef._fieldField = null;
                    break;
                }
                case "transformer": {
                    this.__objectRef._transformerField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public SchemaFieldSpec.Fields field() {
            return new SchemaFieldSpec.Fields(this.getPathComponents(), "field");
        }

        public IncrementingSegmentFieldTransformer.Fields transformer() {
            return new IncrementingSegmentFieldTransformer.Fields(this.getPathComponents(), "transformer");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private SchemaFieldSpec.ProjectionMask _fieldMask;
        private IncrementingSegmentFieldTransformer.ProjectionMask _transformerMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withField(Function<SchemaFieldSpec.ProjectionMask, SchemaFieldSpec.ProjectionMask> nestedMask) {
            this._fieldMask = nestedMask.apply(this._fieldMask == null ? SchemaFieldSpec.createMask() : this._fieldMask);
            this.getDataMap().put("field", this._fieldMask.getDataMap());
            return this;
        }

        public ProjectionMask withField() {
            this._fieldMask = null;
            this.getDataMap().put("field", 1);
            return this;
        }

        public ProjectionMask withTransformer(Function<IncrementingSegmentFieldTransformer.ProjectionMask, IncrementingSegmentFieldTransformer.ProjectionMask> nestedMask) {
            this._transformerMask = nestedMask.apply(this._transformerMask == null ? IncrementingSegmentFieldTransformer.createMask() : this._transformerMask);
            this.getDataMap().put("transformer", this._transformerMask.getDataMap());
            return this;
        }

        public ProjectionMask withTransformer() {
            this._transformerMask = null;
            this.getDataMap().put("transformer", 1);
            return this;
        }
    }
}

