/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.AssertionStdOperator;
import com.linkedin.assertion.AssertionStdParameters;
import com.linkedin.assertion.FieldTransform;
import com.linkedin.assertion.FieldValuesFailThreshold;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.schema.SchemaFieldSpec;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldValuesAssertion
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Attributes defining a field values assertion, which asserts that the values for a field / column\nof a dataset / table matches a set of expectations.\n\nIn other words, this type of assertion acts as a semantic constraint applied to fields for a specific column.\n\nTODO: We should display the \"failed row count\" to the user if the column fails the verification rules.\nTODO: Determine whether we need an \"operator\" that can be applied to the field.*/record FieldValuesAssertion{/**The field under evaluation*/@Searchable.`/path`.fieldName=\"fieldPath\"field:{namespace com.linkedin.schema/**Lightweight spec used for referencing a particular schema field.\n*/record SchemaFieldSpec{/**The field path*/path:string/**The DataHub standard schema field type.*/type:string/**The native field type*/nativeType:string}}/**An optional transform to apply to field values\nbefore evaluating the operator.\n\nIf none is applied, the field value will be compared as is.*/transform:optional/**Definition of a transform applied to the values of a column / field.\nNote that the applicability of a field transform ultimately depends on the native type\nof the field / column.\n\nModel has single field to permit extension.*/record FieldTransform{/**The type of the field transform, e.g. the transformation\nfunction / operator to apply.*/type:enum FieldTransformType{/**Obtain the length of a string field / column (applicable to string types)*/LENGTH}}/**The predicate to evaluate against a single value of the field.\nDepending on the operator, parameters may be required in order to successfully\nevaluate the assertion against the field value.*/operator:/**A boolean operator that is applied on the input to an assertion, after an aggregation function has been applied.*/enum AssertionStdOperator{/**Value being asserted is between min_value and max_value.  Requires 'minValue' & 'maxValue' parameters.*/BETWEEN/**Value being asserted is less than a max value. Requires 'value' parameter.*/LESS_THAN/**Value being asserted is less than or equal to some value. Requires 'value' parameter.*/LESS_THAN_OR_EQUAL_TO/**Value being asserted is greater than some value. Requires 'value' parameter.*/GREATER_THAN/**Value being asserted is greater than or equal to some value. Requires 'value' parameter.*/GREATER_THAN_OR_EQUAL_TO/**Value being asserted is equal to value. Requires 'value' parameter.*/EQUAL_TO/**Value being asserted is not equal to value. Requires 'value' parameter.*/NOT_EQUAL_TO/**Value being asserted is null. Requires no parameters.*/NULL/**Value being asserted is not null. Requires no parameters.*/NOT_NULL/**Value being asserted contains value. Requires 'value' parameter.*/CONTAIN/**Value being asserted ends with value. Requires 'value' parameter.*/END_WITH/**Value being asserted starts with value. Requires 'value' parameter.*/START_WITH/**Value being asserted matches the regex value. Requires 'value' parameter.*/REGEX_MATCH/**Value being asserted is one of the array values. Requires 'value' parameter.*/IN/**Value being asserted is not in one of the array values. Requires 'value' parameter.*/NOT_IN/**Value being asserted is true. Requires no parameters.*/IS_TRUE/**Value being asserted is false. Requires no parameters.*/IS_FALSE/**Other*/_NATIVE_}/**Standard parameters required for the assertion. e.g. min_value, max_value, value, columns*/parameters:optional/**Parameters for AssertionStdOperators.*/record AssertionStdParameters{/**The value parameter of an assertion*/value:optional/**Single parameter for AssertionStdOperators.*/record AssertionStdParameter{/**The parameter value*/value:string/**The type of the parameter*/type:enum AssertionStdParameterType{/**A string value*/STRING/**A numeric value*/NUMBER/**A list of values. When used, value should be formatted as a serialized JSON array.*/LIST/**A set of values. When used, value should be formatted as a serialized JSON array.*/SET/**A value of unknown type*/UNKNOWN}}/**The maxValue parameter of an assertion*/maxValue:optional AssertionStdParameter/**The minValue parameter of an assertion*/minValue:optional AssertionStdParameter}/**Additional customization about when the assertion\nshould be officially considered failing.*/failThreshold:record FieldValuesFailThreshold{/**The type of failure threshold. Either based on the number\nof column values (rows) that fail the expectations, or the percentage\nof the total rows under consideration.*/type:enum FieldValuesFailThresholdType{COUNT,PERCENTAGE}=\"COUNT\"/**By default this is 0, meaning that ALL column values (i.e. rows) must\nmeet the defined expectations.*/value:long=0}/**Whether to ignore or allow nulls when running the values assertion. (i.e.\nconsider only non-null values) using operators OTHER than the IS_NULL operator.\n\nDefaults to true, allowing null values.*/excludeNulls:boolean=true}", SchemaFormatType.PDL);
    private SchemaFieldSpec _fieldField = null;
    private FieldTransform _transformField = null;
    private AssertionStdOperator _operatorField = null;
    private AssertionStdParameters _parametersField = null;
    private FieldValuesFailThreshold _failThresholdField = null;
    private Boolean _excludeNullsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Field = SCHEMA.getField("field");
    private static final RecordDataSchema.Field FIELD_Transform = SCHEMA.getField("transform");
    private static final RecordDataSchema.Field FIELD_Operator = SCHEMA.getField("operator");
    private static final RecordDataSchema.Field FIELD_Parameters = SCHEMA.getField("parameters");
    private static final RecordDataSchema.Field FIELD_FailThreshold = SCHEMA.getField("failThreshold");
    private static final RecordDataSchema.Field FIELD_ExcludeNulls = SCHEMA.getField("excludeNulls");
    private static final Boolean DEFAULT_ExcludeNulls = DataTemplateUtil.coerceBooleanOutput(FIELD_ExcludeNulls.getDefault());

    public FieldValuesAssertion() {
        super(new DataMap(8, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public FieldValuesAssertion(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasField() {
        if (this._fieldField != null) {
            return true;
        }
        return this._map.containsKey("field");
    }

    public void removeField() {
        this._map.remove("field");
    }

    @Nullable
    public SchemaFieldSpec getField(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getField();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fieldField != null) {
                    return this._fieldField;
                }
                Object __rawValue = this._map.get("field");
                this._fieldField = __rawValue == null ? null : new SchemaFieldSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._fieldField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SchemaFieldSpec getField() {
        if (this._fieldField != null) {
            return this._fieldField;
        }
        Object __rawValue = this._map.get("field");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("field");
        }
        this._fieldField = __rawValue == null ? null : new SchemaFieldSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._fieldField;
    }

    public FieldValuesAssertion setField(@Nullable SchemaFieldSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setField(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field field of com.linkedin.assertion.FieldValuesAssertion");
                }
                CheckedUtil.putWithoutChecking(this._map, "field", value.data());
                this._fieldField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeField();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "field", value.data());
                this._fieldField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "field", value.data());
                this._fieldField = value;
            }
        }
        return this;
    }

    public FieldValuesAssertion setField(@Nonnull SchemaFieldSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field field of com.linkedin.assertion.FieldValuesAssertion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "field", value.data());
        this._fieldField = value;
        return this;
    }

    public boolean hasTransform() {
        if (this._transformField != null) {
            return true;
        }
        return this._map.containsKey("transform");
    }

    public void removeTransform() {
        this._map.remove("transform");
    }

    @Nullable
    public FieldTransform getTransform(GetMode mode) {
        return this.getTransform();
    }

    @Nullable
    public FieldTransform getTransform() {
        if (this._transformField != null) {
            return this._transformField;
        }
        Object __rawValue = this._map.get("transform");
        this._transformField = __rawValue == null ? null : new FieldTransform(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._transformField;
    }

    public FieldValuesAssertion setTransform(@Nullable FieldTransform value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTransform(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTransform();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "transform", value.data());
                this._transformField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "transform", value.data());
                this._transformField = value;
            }
        }
        return this;
    }

    public FieldValuesAssertion setTransform(@Nonnull FieldTransform value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field transform of com.linkedin.assertion.FieldValuesAssertion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "transform", value.data());
        this._transformField = value;
        return this;
    }

    public boolean hasOperator() {
        if (this._operatorField != null) {
            return true;
        }
        return this._map.containsKey("operator");
    }

    public void removeOperator() {
        this._map.remove("operator");
    }

    @Nullable
    public AssertionStdOperator getOperator(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOperator();
            }
            case DEFAULT: 
            case NULL: {
                if (this._operatorField != null) {
                    return this._operatorField;
                }
                Object __rawValue = this._map.get("operator");
                this._operatorField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionStdOperator.class, AssertionStdOperator.$UNKNOWN);
                return this._operatorField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AssertionStdOperator getOperator() {
        if (this._operatorField != null) {
            return this._operatorField;
        }
        Object __rawValue = this._map.get("operator");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("operator");
        }
        this._operatorField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionStdOperator.class, AssertionStdOperator.$UNKNOWN);
        return this._operatorField;
    }

    public FieldValuesAssertion setOperator(@Nullable AssertionStdOperator value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOperator(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field operator of com.linkedin.assertion.FieldValuesAssertion");
                }
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOperator();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
            }
        }
        return this;
    }

    public FieldValuesAssertion setOperator(@Nonnull AssertionStdOperator value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field operator of com.linkedin.assertion.FieldValuesAssertion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
        this._operatorField = value;
        return this;
    }

    public boolean hasParameters() {
        if (this._parametersField != null) {
            return true;
        }
        return this._map.containsKey("parameters");
    }

    public void removeParameters() {
        this._map.remove("parameters");
    }

    @Nullable
    public AssertionStdParameters getParameters(GetMode mode) {
        return this.getParameters();
    }

    @Nullable
    public AssertionStdParameters getParameters() {
        if (this._parametersField != null) {
            return this._parametersField;
        }
        Object __rawValue = this._map.get("parameters");
        this._parametersField = __rawValue == null ? null : new AssertionStdParameters(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._parametersField;
    }

    public FieldValuesAssertion setParameters(@Nullable AssertionStdParameters value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParameters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParameters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
            }
        }
        return this;
    }

    public FieldValuesAssertion setParameters(@Nonnull AssertionStdParameters value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parameters of com.linkedin.assertion.FieldValuesAssertion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
        this._parametersField = value;
        return this;
    }

    public boolean hasFailThreshold() {
        if (this._failThresholdField != null) {
            return true;
        }
        return this._map.containsKey("failThreshold");
    }

    public void removeFailThreshold() {
        this._map.remove("failThreshold");
    }

    @Nullable
    public FieldValuesFailThreshold getFailThreshold(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFailThreshold();
            }
            case DEFAULT: 
            case NULL: {
                if (this._failThresholdField != null) {
                    return this._failThresholdField;
                }
                Object __rawValue = this._map.get("failThreshold");
                this._failThresholdField = __rawValue == null ? null : new FieldValuesFailThreshold(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._failThresholdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FieldValuesFailThreshold getFailThreshold() {
        if (this._failThresholdField != null) {
            return this._failThresholdField;
        }
        Object __rawValue = this._map.get("failThreshold");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("failThreshold");
        }
        this._failThresholdField = __rawValue == null ? null : new FieldValuesFailThreshold(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._failThresholdField;
    }

    public FieldValuesAssertion setFailThreshold(@Nullable FieldValuesFailThreshold value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFailThreshold(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field failThreshold of com.linkedin.assertion.FieldValuesAssertion");
                }
                CheckedUtil.putWithoutChecking(this._map, "failThreshold", value.data());
                this._failThresholdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFailThreshold();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "failThreshold", value.data());
                this._failThresholdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "failThreshold", value.data());
                this._failThresholdField = value;
            }
        }
        return this;
    }

    public FieldValuesAssertion setFailThreshold(@Nonnull FieldValuesFailThreshold value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field failThreshold of com.linkedin.assertion.FieldValuesAssertion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "failThreshold", value.data());
        this._failThresholdField = value;
        return this;
    }

    public boolean hasExcludeNulls() {
        if (this._excludeNullsField != null) {
            return true;
        }
        return this._map.containsKey("excludeNulls");
    }

    public void removeExcludeNulls() {
        this._map.remove("excludeNulls");
    }

    @Nullable
    public Boolean isExcludeNulls(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isExcludeNulls();
            }
            case NULL: {
                if (this._excludeNullsField != null) {
                    return this._excludeNullsField;
                }
                Object __rawValue = this._map.get("excludeNulls");
                this._excludeNullsField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._excludeNullsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isExcludeNulls() {
        if (this._excludeNullsField != null) {
            return this._excludeNullsField;
        }
        Object __rawValue = this._map.get("excludeNulls");
        if (__rawValue == null) {
            return DEFAULT_ExcludeNulls;
        }
        this._excludeNullsField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._excludeNullsField;
    }

    public FieldValuesAssertion setExcludeNulls(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExcludeNulls(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field excludeNulls of com.linkedin.assertion.FieldValuesAssertion");
                }
                CheckedUtil.putWithoutChecking(this._map, "excludeNulls", value);
                this._excludeNullsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExcludeNulls();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "excludeNulls", value);
                this._excludeNullsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "excludeNulls", value);
                this._excludeNullsField = value;
            }
        }
        return this;
    }

    public FieldValuesAssertion setExcludeNulls(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field excludeNulls of com.linkedin.assertion.FieldValuesAssertion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "excludeNulls", value);
        this._excludeNullsField = value;
        return this;
    }

    public FieldValuesAssertion setExcludeNulls(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "excludeNulls", value);
        this._excludeNullsField = value;
        return this;
    }

    @Override
    public FieldValuesAssertion clone() throws CloneNotSupportedException {
        FieldValuesAssertion __clone = (FieldValuesAssertion)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FieldValuesAssertion copy() throws CloneNotSupportedException {
        FieldValuesAssertion __copy = (FieldValuesAssertion)super.copy();
        __copy._excludeNullsField = null;
        __copy._transformField = null;
        __copy._fieldField = null;
        __copy._failThresholdField = null;
        __copy._parametersField = null;
        __copy._operatorField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FieldValuesAssertion __objectRef;

        private ChangeListener(FieldValuesAssertion reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "excludeNulls": {
                    this.__objectRef._excludeNullsField = null;
                    break;
                }
                case "transform": {
                    this.__objectRef._transformField = null;
                    break;
                }
                case "field": {
                    this.__objectRef._fieldField = null;
                    break;
                }
                case "failThreshold": {
                    this.__objectRef._failThresholdField = null;
                    break;
                }
                case "parameters": {
                    this.__objectRef._parametersField = null;
                    break;
                }
                case "operator": {
                    this.__objectRef._operatorField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public SchemaFieldSpec.Fields field() {
            return new SchemaFieldSpec.Fields(this.getPathComponents(), "field");
        }

        public FieldTransform.Fields transform() {
            return new FieldTransform.Fields(this.getPathComponents(), "transform");
        }

        public PathSpec operator() {
            return new PathSpec(this.getPathComponents(), "operator");
        }

        public AssertionStdParameters.Fields parameters() {
            return new AssertionStdParameters.Fields(this.getPathComponents(), "parameters");
        }

        public FieldValuesFailThreshold.Fields failThreshold() {
            return new FieldValuesFailThreshold.Fields(this.getPathComponents(), "failThreshold");
        }

        public PathSpec excludeNulls() {
            return new PathSpec(this.getPathComponents(), "excludeNulls");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private SchemaFieldSpec.ProjectionMask _fieldMask;
        private FieldTransform.ProjectionMask _transformMask;
        private AssertionStdParameters.ProjectionMask _parametersMask;
        private FieldValuesFailThreshold.ProjectionMask _failThresholdMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withField(Function<SchemaFieldSpec.ProjectionMask, SchemaFieldSpec.ProjectionMask> nestedMask) {
            this._fieldMask = nestedMask.apply(this._fieldMask == null ? SchemaFieldSpec.createMask() : this._fieldMask);
            this.getDataMap().put("field", this._fieldMask.getDataMap());
            return this;
        }

        public ProjectionMask withField() {
            this._fieldMask = null;
            this.getDataMap().put("field", 1);
            return this;
        }

        public ProjectionMask withTransform(Function<FieldTransform.ProjectionMask, FieldTransform.ProjectionMask> nestedMask) {
            this._transformMask = nestedMask.apply(this._transformMask == null ? FieldTransform.createMask() : this._transformMask);
            this.getDataMap().put("transform", this._transformMask.getDataMap());
            return this;
        }

        public ProjectionMask withTransform() {
            this._transformMask = null;
            this.getDataMap().put("transform", 1);
            return this;
        }

        public ProjectionMask withOperator() {
            this.getDataMap().put("operator", 1);
            return this;
        }

        public ProjectionMask withParameters(Function<AssertionStdParameters.ProjectionMask, AssertionStdParameters.ProjectionMask> nestedMask) {
            this._parametersMask = nestedMask.apply(this._parametersMask == null ? AssertionStdParameters.createMask() : this._parametersMask);
            this.getDataMap().put("parameters", this._parametersMask.getDataMap());
            return this;
        }

        public ProjectionMask withParameters() {
            this._parametersMask = null;
            this.getDataMap().put("parameters", 1);
            return this;
        }

        public ProjectionMask withFailThreshold(Function<FieldValuesFailThreshold.ProjectionMask, FieldValuesFailThreshold.ProjectionMask> nestedMask) {
            this._failThresholdMask = nestedMask.apply(this._failThresholdMask == null ? FieldValuesFailThreshold.createMask() : this._failThresholdMask);
            this.getDataMap().put("failThreshold", this._failThresholdMask.getDataMap());
            return this;
        }

        public ProjectionMask withFailThreshold() {
            this._failThresholdMask = null;
            this.getDataMap().put("failThreshold", 1);
            return this;
        }

        public ProjectionMask withExcludeNulls() {
            this.getDataMap().put("excludeNulls", 1);
            return this;
        }
    }
}

