/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.AssertionStdAggregation;
import com.linkedin.assertion.AssertionStdOperator;
import com.linkedin.assertion.AssertionStdParameters;
import com.linkedin.assertion.DatasetAssertionScope;
import com.linkedin.common.UrnArray;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatasetAssertionInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Attributes that are applicable to single-Dataset Assertions\n*/record DatasetAssertionInfo{/**The dataset targeted by this assertion.*/@Relationship={\"entityTypes\":[\"dataset\"],\"name\":\"Asserts\"}dataset:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Scope of the Assertion. What part of the dataset does this assertion apply to?\n*/@Searchable={}scope:enum DatasetAssertionScope{/**This assertion applies to dataset column(s)*/DATASET_COLUMN/**This assertion applies to entire rows of the dataset*/DATASET_ROWS/**This assertion applies to the storage size of the dataset*/DATASET_STORAGE_SIZE/**This assertion applies to the schema of the dataset*/DATASET_SCHEMA/**The scope of the assertion is unknown*/UNKNOWN}/**One or more dataset schema fields that are targeted by this assertion.\n\nThis field is expected to be provided if the assertion scope is DATASET_COLUMN.*/@Relationship.`/*`={\"entityTypes\":[\"schemaField\"],\"name\":\"Asserts\"}@Searchable.`/*`.fieldType=\"URN\"fields:optional array[com.linkedin.common.Urn]/**Standardized assertion operator\nThis field is left blank if there is no selected aggregation or metric for a particular column.*/@Searchable={}aggregation:optional/**The function that is applied to the aggregation input (schema, rows, column values) before evaluating an operator.*/enum AssertionStdAggregation{/**Assertion is applied on number of rows.*/ROW_COUNT/**Assertion is applied on all columns.*/COLUMNS/**Assertion is applied on number of columns.*/COLUMN_COUNT/**Assertion is applied on individual column value. (No aggregation)*/IDENTITY/**Assertion is applied on column mean*/MEAN/**Assertion is applied on column median*/MEDIAN/**Assertion is applied on number of distinct values in column*/UNIQUE_COUNT/**Assertion is applied on proportion of distinct values in column*/UNIQUE_PROPORTION/**Assertion is applied on proportion of distinct values in column\n\nDeprecated! Use UNIQUE_PROPORTION instead.*/UNIQUE_PROPOTION/**Assertion is applied on number of null values in column*/NULL_COUNT/**Assertion is applied on proportion of null values in column*/NULL_PROPORTION/**Assertion is applied on column std deviation*/STDDEV/**Assertion is applied on column min*/MIN/**Assertion is applied on column std deviation*/MAX/**Assertion is applied on column sum*/SUM/**Other*/_NATIVE_}/**Standardized assertion operator*/operator:/**A boolean operator that is applied on the input to an assertion, after an aggregation function has been applied.*/enum AssertionStdOperator{/**Value being asserted is between min_value and max_value.  Requires 'minValue' & 'maxValue' parameters.*/BETWEEN/**Value being asserted is less than a max value. Requires 'value' parameter.*/LESS_THAN/**Value being asserted is less than or equal to some value. Requires 'value' parameter.*/LESS_THAN_OR_EQUAL_TO/**Value being asserted is greater than some value. Requires 'value' parameter.*/GREATER_THAN/**Value being asserted is greater than or equal to some value. Requires 'value' parameter.*/GREATER_THAN_OR_EQUAL_TO/**Value being asserted is equal to value. Requires 'value' parameter.*/EQUAL_TO/**Value being asserted is not equal to value. Requires 'value' parameter.*/NOT_EQUAL_TO/**Value being asserted is null. Requires no parameters.*/NULL/**Value being asserted is not null. Requires no parameters.*/NOT_NULL/**Value being asserted contains value. Requires 'value' parameter.*/CONTAIN/**Value being asserted ends with value. Requires 'value' parameter.*/END_WITH/**Value being asserted starts with value. Requires 'value' parameter.*/START_WITH/**Value being asserted matches the regex value. Requires 'value' parameter.*/REGEX_MATCH/**Value being asserted is one of the array values. Requires 'value' parameter.*/IN/**Value being asserted is not in one of the array values. Requires 'value' parameter.*/NOT_IN/**Value being asserted is true. Requires no parameters.*/IS_TRUE/**Value being asserted is false. Requires no parameters.*/IS_FALSE/**Other*/_NATIVE_}/**Standard parameters required for the assertion. e.g. min_value, max_value, value, columns*/parameters:optional/**Parameters for AssertionStdOperators.*/record AssertionStdParameters{/**The value parameter of an assertion*/value:optional/**Single parameter for AssertionStdOperators.*/record AssertionStdParameter{/**The parameter value*/value:string/**The type of the parameter*/type:enum AssertionStdParameterType{/**A string value*/STRING/**A numeric value*/NUMBER/**A list of values. When used, value should be formatted as a serialized JSON array.*/LIST/**A set of values. When used, value should be formatted as a serialized JSON array.*/SET/**A value of unknown type*/UNKNOWN}}/**The maxValue parameter of an assertion*/maxValue:optional AssertionStdParameter/**The minValue parameter of an assertion*/minValue:optional AssertionStdParameter}/**Native assertion type*/nativeType:optional string/**Native parameters required for the assertion.*/nativeParameters:optional map[string,string]logic:optional string}", SchemaFormatType.PDL);
    private Urn _datasetField = null;
    private DatasetAssertionScope _scopeField = null;
    private UrnArray _fieldsField = null;
    private AssertionStdAggregation _aggregationField = null;
    private AssertionStdOperator _operatorField = null;
    private AssertionStdParameters _parametersField = null;
    private String _nativeTypeField = null;
    private StringMap _nativeParametersField = null;
    private String _logicField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Dataset = SCHEMA.getField("dataset");
    private static final RecordDataSchema.Field FIELD_Scope = SCHEMA.getField("scope");
    private static final RecordDataSchema.Field FIELD_Fields = SCHEMA.getField("fields");
    private static final RecordDataSchema.Field FIELD_Aggregation = SCHEMA.getField("aggregation");
    private static final RecordDataSchema.Field FIELD_Operator = SCHEMA.getField("operator");
    private static final RecordDataSchema.Field FIELD_Parameters = SCHEMA.getField("parameters");
    private static final RecordDataSchema.Field FIELD_NativeType = SCHEMA.getField("nativeType");
    private static final RecordDataSchema.Field FIELD_NativeParameters = SCHEMA.getField("nativeParameters");
    private static final RecordDataSchema.Field FIELD_Logic = SCHEMA.getField("logic");

    public DatasetAssertionInfo() {
        super(new DataMap(12, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public DatasetAssertionInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDataset() {
        if (this._datasetField != null) {
            return true;
        }
        return this._map.containsKey("dataset");
    }

    public void removeDataset() {
        this._map.remove("dataset");
    }

    @Nullable
    public Urn getDataset(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDataset();
            }
            case DEFAULT: 
            case NULL: {
                if (this._datasetField != null) {
                    return this._datasetField;
                }
                Object __rawValue = this._map.get("dataset");
                this._datasetField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._datasetField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getDataset() {
        if (this._datasetField != null) {
            return this._datasetField;
        }
        Object __rawValue = this._map.get("dataset");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("dataset");
        }
        this._datasetField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._datasetField;
    }

    public DatasetAssertionInfo setDataset(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDataset(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field dataset of com.linkedin.assertion.DatasetAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._datasetField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDataset();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._datasetField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._datasetField = value;
            }
        }
        return this;
    }

    public DatasetAssertionInfo setDataset(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dataset of com.linkedin.assertion.DatasetAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dataset", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._datasetField = value;
        return this;
    }

    public boolean hasScope() {
        if (this._scopeField != null) {
            return true;
        }
        return this._map.containsKey("scope");
    }

    public void removeScope() {
        this._map.remove("scope");
    }

    @Nullable
    public DatasetAssertionScope getScope(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getScope();
            }
            case DEFAULT: 
            case NULL: {
                if (this._scopeField != null) {
                    return this._scopeField;
                }
                Object __rawValue = this._map.get("scope");
                this._scopeField = DataTemplateUtil.coerceEnumOutput(__rawValue, DatasetAssertionScope.class, DatasetAssertionScope.$UNKNOWN);
                return this._scopeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DatasetAssertionScope getScope() {
        if (this._scopeField != null) {
            return this._scopeField;
        }
        Object __rawValue = this._map.get("scope");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("scope");
        }
        this._scopeField = DataTemplateUtil.coerceEnumOutput(__rawValue, DatasetAssertionScope.class, DatasetAssertionScope.$UNKNOWN);
        return this._scopeField;
    }

    public DatasetAssertionInfo setScope(@Nullable DatasetAssertionScope value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setScope(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field scope of com.linkedin.assertion.DatasetAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "scope", value.name());
                this._scopeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeScope();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "scope", value.name());
                this._scopeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "scope", value.name());
                this._scopeField = value;
            }
        }
        return this;
    }

    public DatasetAssertionInfo setScope(@Nonnull DatasetAssertionScope value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field scope of com.linkedin.assertion.DatasetAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "scope", value.name());
        this._scopeField = value;
        return this;
    }

    public boolean hasFields() {
        if (this._fieldsField != null) {
            return true;
        }
        return this._map.containsKey("fields");
    }

    public void removeFields() {
        this._map.remove("fields");
    }

    @Nullable
    public UrnArray getFields(GetMode mode) {
        return this.getFields();
    }

    @Nullable
    public UrnArray getFields() {
        if (this._fieldsField != null) {
            return this._fieldsField;
        }
        Object __rawValue = this._map.get("fields");
        this._fieldsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._fieldsField;
    }

    public DatasetAssertionInfo setFields(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFields(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFields();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fields", value.data());
                this._fieldsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fields", value.data());
                this._fieldsField = value;
            }
        }
        return this;
    }

    public DatasetAssertionInfo setFields(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fields of com.linkedin.assertion.DatasetAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fields", value.data());
        this._fieldsField = value;
        return this;
    }

    public boolean hasAggregation() {
        if (this._aggregationField != null) {
            return true;
        }
        return this._map.containsKey("aggregation");
    }

    public void removeAggregation() {
        this._map.remove("aggregation");
    }

    @Nullable
    public AssertionStdAggregation getAggregation(GetMode mode) {
        return this.getAggregation();
    }

    @Nullable
    public AssertionStdAggregation getAggregation() {
        if (this._aggregationField != null) {
            return this._aggregationField;
        }
        Object __rawValue = this._map.get("aggregation");
        this._aggregationField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionStdAggregation.class, AssertionStdAggregation.$UNKNOWN);
        return this._aggregationField;
    }

    public DatasetAssertionInfo setAggregation(@Nullable AssertionStdAggregation value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAggregation(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAggregation();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregation", value.name());
                this._aggregationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aggregation", value.name());
                this._aggregationField = value;
            }
        }
        return this;
    }

    public DatasetAssertionInfo setAggregation(@Nonnull AssertionStdAggregation value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aggregation of com.linkedin.assertion.DatasetAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aggregation", value.name());
        this._aggregationField = value;
        return this;
    }

    public boolean hasOperator() {
        if (this._operatorField != null) {
            return true;
        }
        return this._map.containsKey("operator");
    }

    public void removeOperator() {
        this._map.remove("operator");
    }

    @Nullable
    public AssertionStdOperator getOperator(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOperator();
            }
            case DEFAULT: 
            case NULL: {
                if (this._operatorField != null) {
                    return this._operatorField;
                }
                Object __rawValue = this._map.get("operator");
                this._operatorField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionStdOperator.class, AssertionStdOperator.$UNKNOWN);
                return this._operatorField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AssertionStdOperator getOperator() {
        if (this._operatorField != null) {
            return this._operatorField;
        }
        Object __rawValue = this._map.get("operator");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("operator");
        }
        this._operatorField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionStdOperator.class, AssertionStdOperator.$UNKNOWN);
        return this._operatorField;
    }

    public DatasetAssertionInfo setOperator(@Nullable AssertionStdOperator value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOperator(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field operator of com.linkedin.assertion.DatasetAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOperator();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
            }
        }
        return this;
    }

    public DatasetAssertionInfo setOperator(@Nonnull AssertionStdOperator value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field operator of com.linkedin.assertion.DatasetAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
        this._operatorField = value;
        return this;
    }

    public boolean hasParameters() {
        if (this._parametersField != null) {
            return true;
        }
        return this._map.containsKey("parameters");
    }

    public void removeParameters() {
        this._map.remove("parameters");
    }

    @Nullable
    public AssertionStdParameters getParameters(GetMode mode) {
        return this.getParameters();
    }

    @Nullable
    public AssertionStdParameters getParameters() {
        if (this._parametersField != null) {
            return this._parametersField;
        }
        Object __rawValue = this._map.get("parameters");
        this._parametersField = __rawValue == null ? null : new AssertionStdParameters(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._parametersField;
    }

    public DatasetAssertionInfo setParameters(@Nullable AssertionStdParameters value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParameters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParameters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
            }
        }
        return this;
    }

    public DatasetAssertionInfo setParameters(@Nonnull AssertionStdParameters value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parameters of com.linkedin.assertion.DatasetAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
        this._parametersField = value;
        return this;
    }

    public boolean hasNativeType() {
        if (this._nativeTypeField != null) {
            return true;
        }
        return this._map.containsKey("nativeType");
    }

    public void removeNativeType() {
        this._map.remove("nativeType");
    }

    @Nullable
    public String getNativeType(GetMode mode) {
        return this.getNativeType();
    }

    @Nullable
    public String getNativeType() {
        if (this._nativeTypeField != null) {
            return this._nativeTypeField;
        }
        Object __rawValue = this._map.get("nativeType");
        this._nativeTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nativeTypeField;
    }

    public DatasetAssertionInfo setNativeType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNativeType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNativeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "nativeType", value);
                this._nativeTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "nativeType", value);
                this._nativeTypeField = value;
            }
        }
        return this;
    }

    public DatasetAssertionInfo setNativeType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field nativeType of com.linkedin.assertion.DatasetAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "nativeType", value);
        this._nativeTypeField = value;
        return this;
    }

    public boolean hasNativeParameters() {
        if (this._nativeParametersField != null) {
            return true;
        }
        return this._map.containsKey("nativeParameters");
    }

    public void removeNativeParameters() {
        this._map.remove("nativeParameters");
    }

    @Nullable
    public StringMap getNativeParameters(GetMode mode) {
        return this.getNativeParameters();
    }

    @Nullable
    public StringMap getNativeParameters() {
        if (this._nativeParametersField != null) {
            return this._nativeParametersField;
        }
        Object __rawValue = this._map.get("nativeParameters");
        this._nativeParametersField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._nativeParametersField;
    }

    public DatasetAssertionInfo setNativeParameters(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNativeParameters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNativeParameters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "nativeParameters", value.data());
                this._nativeParametersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "nativeParameters", value.data());
                this._nativeParametersField = value;
            }
        }
        return this;
    }

    public DatasetAssertionInfo setNativeParameters(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field nativeParameters of com.linkedin.assertion.DatasetAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "nativeParameters", value.data());
        this._nativeParametersField = value;
        return this;
    }

    public boolean hasLogic() {
        if (this._logicField != null) {
            return true;
        }
        return this._map.containsKey("logic");
    }

    public void removeLogic() {
        this._map.remove("logic");
    }

    @Nullable
    public String getLogic(GetMode mode) {
        return this.getLogic();
    }

    @Nullable
    public String getLogic() {
        if (this._logicField != null) {
            return this._logicField;
        }
        Object __rawValue = this._map.get("logic");
        this._logicField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._logicField;
    }

    public DatasetAssertionInfo setLogic(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLogic(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLogic();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "logic", value);
                this._logicField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "logic", value);
                this._logicField = value;
            }
        }
        return this;
    }

    public DatasetAssertionInfo setLogic(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field logic of com.linkedin.assertion.DatasetAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "logic", value);
        this._logicField = value;
        return this;
    }

    @Override
    public DatasetAssertionInfo clone() throws CloneNotSupportedException {
        DatasetAssertionInfo __clone = (DatasetAssertionInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DatasetAssertionInfo copy() throws CloneNotSupportedException {
        DatasetAssertionInfo __copy = (DatasetAssertionInfo)super.copy();
        __copy._nativeParametersField = null;
        __copy._scopeField = null;
        __copy._nativeTypeField = null;
        __copy._aggregationField = null;
        __copy._logicField = null;
        __copy._fieldsField = null;
        __copy._datasetField = null;
        __copy._parametersField = null;
        __copy._operatorField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DatasetAssertionInfo __objectRef;

        private ChangeListener(DatasetAssertionInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "nativeParameters": {
                    this.__objectRef._nativeParametersField = null;
                    break;
                }
                case "scope": {
                    this.__objectRef._scopeField = null;
                    break;
                }
                case "nativeType": {
                    this.__objectRef._nativeTypeField = null;
                    break;
                }
                case "aggregation": {
                    this.__objectRef._aggregationField = null;
                    break;
                }
                case "logic": {
                    this.__objectRef._logicField = null;
                    break;
                }
                case "fields": {
                    this.__objectRef._fieldsField = null;
                    break;
                }
                case "dataset": {
                    this.__objectRef._datasetField = null;
                    break;
                }
                case "parameters": {
                    this.__objectRef._parametersField = null;
                    break;
                }
                case "operator": {
                    this.__objectRef._operatorField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec dataset() {
            return new PathSpec(this.getPathComponents(), "dataset");
        }

        public PathSpec scope() {
            return new PathSpec(this.getPathComponents(), "scope");
        }

        public PathSpec fields() {
            return new PathSpec(this.getPathComponents(), "fields");
        }

        public PathSpec fields(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "fields");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec aggregation() {
            return new PathSpec(this.getPathComponents(), "aggregation");
        }

        public PathSpec operator() {
            return new PathSpec(this.getPathComponents(), "operator");
        }

        public AssertionStdParameters.Fields parameters() {
            return new AssertionStdParameters.Fields(this.getPathComponents(), "parameters");
        }

        public PathSpec nativeType() {
            return new PathSpec(this.getPathComponents(), "nativeType");
        }

        public PathSpec nativeParameters() {
            return new PathSpec(this.getPathComponents(), "nativeParameters");
        }

        public PathSpec logic() {
            return new PathSpec(this.getPathComponents(), "logic");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AssertionStdParameters.ProjectionMask _parametersMask;

        ProjectionMask() {
            super(12);
        }

        public ProjectionMask withDataset() {
            this.getDataMap().put("dataset", 1);
            return this;
        }

        public ProjectionMask withScope() {
            this.getDataMap().put("scope", 1);
            return this;
        }

        public ProjectionMask withFields() {
            this.getDataMap().put("fields", 1);
            return this;
        }

        public ProjectionMask withFields(Integer start, Integer count) {
            this.getDataMap().put("fields", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("fields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAggregation() {
            this.getDataMap().put("aggregation", 1);
            return this;
        }

        public ProjectionMask withOperator() {
            this.getDataMap().put("operator", 1);
            return this;
        }

        public ProjectionMask withParameters(Function<AssertionStdParameters.ProjectionMask, AssertionStdParameters.ProjectionMask> nestedMask) {
            this._parametersMask = nestedMask.apply(this._parametersMask == null ? AssertionStdParameters.createMask() : this._parametersMask);
            this.getDataMap().put("parameters", this._parametersMask.getDataMap());
            return this;
        }

        public ProjectionMask withParameters() {
            this._parametersMask = null;
            this.getDataMap().put("parameters", 1);
            return this;
        }

        public ProjectionMask withNativeType() {
            this.getDataMap().put("nativeType", 1);
            return this;
        }

        public ProjectionMask withNativeParameters() {
            this.getDataMap().put("nativeParameters", 1);
            return this;
        }

        public ProjectionMask withLogic() {
            this.getDataMap().put("logic", 1);
            return this;
        }
    }
}

