/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.AssertionResult;
import com.linkedin.assertion.AssertionRunStatus;
import com.linkedin.assertion.BatchSpec;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.timeseries.PartitionSpec;
import com.linkedin.timeseries.TimeWindowSize;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssertionRunEvent
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**An event representing the current status of evaluating an assertion on a batch.\nAssertionRunEvent should be used for reporting the status of a run as an assertion evaluation progresses.*/@Aspect={\"name\":\"assertionRunEvent\",\"type\":\"timeseries\"}record AssertionRunEvent{/**The event timestamp field as epoch at UTC in milli seconds.*/@Searchable={\"fieldName\":\"lastCompletedTime\",\"fieldType\":\"DATETIME\"}timestampMillis:long/** Native (platform-specific) identifier for this run*/runId:string@TimeseriesField={}asserteeUrn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The status of the assertion run as per this timeseries event.*/@TimeseriesField={}status:/**The lifecycle status of an assertion run.*/enum AssertionRunStatus{/**The Assertion Run has completed*/COMPLETE}/**Results of assertion, present if the status is COMPLETE*/result:optional/**The result of running an assertion*/record AssertionResult{/** The final result, e.g. either SUCCESS, FAILURE, or ERROR.*/@Searchable={}@TimeseriesField={}type:/** The final result of evaluating an assertion, e.g. SUCCESS, FAILURE, or ERROR.*/enum AssertionResultType{/** The Assertion has not yet been fully evaluated*/INIT/** The Assertion Succeeded*/SUCCESS/** The Assertion Failed*/FAILURE/** The Assertion encountered an Error*/ERROR}/**Number of rows for evaluated batch*/rowCount:optional long/**Number of rows with missing value for evaluated batch*/missingCount:optional long/**Number of rows with unexpected value for evaluated batch*/unexpectedCount:optional long/**Observed aggregate value for evaluated batch*/actualAggValue:optional float/**Other results of evaluation*/nativeResults:optional map[string,string]/**External URL where full results are available. Only present when assertion source is not native.*/externalUrl:optional string/** The error object if AssertionResultType is an Error*/error:optional/** An error encountered when evaluating an AssertionResult*/record AssertionResultError{/** The type of error encountered*/type:enum AssertionResultErrorType{/** Source is unreachable*/SOURCE_CONNECTION_ERROR/** Source query failed to execute*/SOURCE_QUERY_FAILED/** Insufficient data to evaluate the assertion*/INSUFFICIENT_DATA/** Invalid parameters were detected*/INVALID_PARAMETERS/** Event type not supported by the specified source*/INVALID_SOURCE_TYPE/** Unsupported platform*/UNSUPPORTED_PLATFORM/** Error while executing a custom SQL assertion*/CUSTOM_SQL_ERROR/** Error while executing a field assertion*/FIELD_ASSERTION_ERROR/** Unknown error*/UNKNOWN_ERROR}/** Additional metadata depending on the type of error*/properties:optional map[string,string]}}/**Runtime parameters of evaluation*/runtimeContext:optional map[string,string]/**Specification of the batch which this run is evaluating*/batchSpec:optional/**A batch on which certain operations, e.g. data quality evaluation, is done.*/record BatchSpec includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{/**The native identifier as specified by the system operating on the batch.*/nativeBatchId:optional string/**A query that identifies a batch of data*/query:optional string/**Any limit to the number of rows in the batch, if applied*/limit:optional int}@TimeseriesField={}assertionUrn:com.linkedin.common.Urn/**Granularity of the event if applicable*/eventGranularity:optional{namespace com.linkedin.timeseries/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}}/**The optional partition specification.*/partitionSpec:optional{namespace com.linkedin.timeseries/**A reference to a specific partition in a dataset.*/record PartitionSpec{/**A unique id / value for the partition for which statistics were collected,\ngenerated by applying the key definition to a given row.*/@TimeseriesField={}partition:string/**Time window of the partition, if we are able to extract it from the partition key.*/timePartition:optional record TimeWindow{/**Start time as epoch at UTC.*/startTimeMillis:long/**The length of the window.*/length:TimeWindowSize}/**Unused!*/@deprecated,type:enum PartitionType{FULL_TABLE,QUERY,PARTITION}=\"PARTITION\"}}={\"partition\":\"FULL_TABLE_SNAPSHOT\",\"type\":\"FULL_TABLE\"}/**The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value.*/messageId:optional string}", SchemaFormatType.PDL);
    private Long _timestampMillisField = null;
    private String _runIdField = null;
    private Urn _asserteeUrnField = null;
    private AssertionRunStatus _statusField = null;
    private AssertionResult _resultField = null;
    private StringMap _runtimeContextField = null;
    private BatchSpec _batchSpecField = null;
    private Urn _assertionUrnField = null;
    private TimeWindowSize _eventGranularityField = null;
    private PartitionSpec _partitionSpecField = null;
    private String _messageIdField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TimestampMillis = SCHEMA.getField("timestampMillis");
    private static final RecordDataSchema.Field FIELD_RunId = SCHEMA.getField("runId");
    private static final RecordDataSchema.Field FIELD_AsserteeUrn = SCHEMA.getField("asserteeUrn");
    private static final RecordDataSchema.Field FIELD_Status = SCHEMA.getField("status");
    private static final RecordDataSchema.Field FIELD_Result = SCHEMA.getField("result");
    private static final RecordDataSchema.Field FIELD_RuntimeContext = SCHEMA.getField("runtimeContext");
    private static final RecordDataSchema.Field FIELD_BatchSpec = SCHEMA.getField("batchSpec");
    private static final RecordDataSchema.Field FIELD_AssertionUrn = SCHEMA.getField("assertionUrn");
    private static final RecordDataSchema.Field FIELD_EventGranularity = SCHEMA.getField("eventGranularity");
    private static final RecordDataSchema.Field FIELD_PartitionSpec = SCHEMA.getField("partitionSpec");
    private static final PartitionSpec DEFAULT_PartitionSpec;
    private static final RecordDataSchema.Field FIELD_MessageId;

    public AssertionRunEvent() {
        super(new DataMap(15, 0.75f), SCHEMA, 7);
        this.addChangeListener(this.__changeListener);
    }

    public AssertionRunEvent(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTimestampMillis() {
        if (this._timestampMillisField != null) {
            return true;
        }
        return this._map.containsKey("timestampMillis");
    }

    public void removeTimestampMillis() {
        this._map.remove("timestampMillis");
    }

    @Nullable
    public Long getTimestampMillis(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimestampMillis();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timestampMillisField != null) {
                    return this._timestampMillisField;
                }
                Object __rawValue = this._map.get("timestampMillis");
                this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timestampMillisField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTimestampMillis() {
        if (this._timestampMillisField != null) {
            return this._timestampMillisField;
        }
        Object __rawValue = this._map.get("timestampMillis");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timestampMillis");
        }
        this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timestampMillisField;
    }

    public AssertionRunEvent setTimestampMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimestampMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timestampMillis of com.linkedin.assertion.AssertionRunEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimestampMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
            }
        }
        return this;
    }

    public AssertionRunEvent setTimestampMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timestampMillis of com.linkedin.assertion.AssertionRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public AssertionRunEvent setTimestampMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public boolean hasRunId() {
        if (this._runIdField != null) {
            return true;
        }
        return this._map.containsKey("runId");
    }

    public void removeRunId() {
        this._map.remove("runId");
    }

    @Nullable
    public String getRunId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRunId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._runIdField != null) {
                    return this._runIdField;
                }
                Object __rawValue = this._map.get("runId");
                this._runIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._runIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getRunId() {
        if (this._runIdField != null) {
            return this._runIdField;
        }
        Object __rawValue = this._map.get("runId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("runId");
        }
        this._runIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._runIdField;
    }

    public AssertionRunEvent setRunId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRunId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field runId of com.linkedin.assertion.AssertionRunEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "runId", value);
                this._runIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRunId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "runId", value);
                this._runIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "runId", value);
                this._runIdField = value;
            }
        }
        return this;
    }

    public AssertionRunEvent setRunId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field runId of com.linkedin.assertion.AssertionRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "runId", value);
        this._runIdField = value;
        return this;
    }

    public boolean hasAsserteeUrn() {
        if (this._asserteeUrnField != null) {
            return true;
        }
        return this._map.containsKey("asserteeUrn");
    }

    public void removeAsserteeUrn() {
        this._map.remove("asserteeUrn");
    }

    @Nullable
    public Urn getAsserteeUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAsserteeUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._asserteeUrnField != null) {
                    return this._asserteeUrnField;
                }
                Object __rawValue = this._map.get("asserteeUrn");
                this._asserteeUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._asserteeUrnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getAsserteeUrn() {
        if (this._asserteeUrnField != null) {
            return this._asserteeUrnField;
        }
        Object __rawValue = this._map.get("asserteeUrn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("asserteeUrn");
        }
        this._asserteeUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._asserteeUrnField;
    }

    public AssertionRunEvent setAsserteeUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAsserteeUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field asserteeUrn of com.linkedin.assertion.AssertionRunEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "asserteeUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._asserteeUrnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAsserteeUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "asserteeUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._asserteeUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "asserteeUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._asserteeUrnField = value;
            }
        }
        return this;
    }

    public AssertionRunEvent setAsserteeUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field asserteeUrn of com.linkedin.assertion.AssertionRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "asserteeUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._asserteeUrnField = value;
        return this;
    }

    public boolean hasStatus() {
        if (this._statusField != null) {
            return true;
        }
        return this._map.containsKey("status");
    }

    public void removeStatus() {
        this._map.remove("status");
    }

    @Nullable
    public AssertionRunStatus getStatus(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStatus();
            }
            case DEFAULT: 
            case NULL: {
                if (this._statusField != null) {
                    return this._statusField;
                }
                Object __rawValue = this._map.get("status");
                this._statusField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionRunStatus.class, AssertionRunStatus.$UNKNOWN);
                return this._statusField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AssertionRunStatus getStatus() {
        if (this._statusField != null) {
            return this._statusField;
        }
        Object __rawValue = this._map.get("status");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("status");
        }
        this._statusField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionRunStatus.class, AssertionRunStatus.$UNKNOWN);
        return this._statusField;
    }

    public AssertionRunEvent setStatus(@Nullable AssertionRunStatus value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStatus(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field status of com.linkedin.assertion.AssertionRunEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "status", value.name());
                this._statusField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStatus();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "status", value.name());
                this._statusField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "status", value.name());
                this._statusField = value;
            }
        }
        return this;
    }

    public AssertionRunEvent setStatus(@Nonnull AssertionRunStatus value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field status of com.linkedin.assertion.AssertionRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "status", value.name());
        this._statusField = value;
        return this;
    }

    public boolean hasResult() {
        if (this._resultField != null) {
            return true;
        }
        return this._map.containsKey("result");
    }

    public void removeResult() {
        this._map.remove("result");
    }

    @Nullable
    public AssertionResult getResult(GetMode mode) {
        return this.getResult();
    }

    @Nullable
    public AssertionResult getResult() {
        if (this._resultField != null) {
            return this._resultField;
        }
        Object __rawValue = this._map.get("result");
        this._resultField = __rawValue == null ? null : new AssertionResult(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._resultField;
    }

    public AssertionRunEvent setResult(@Nullable AssertionResult value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResult(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResult();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "result", value.data());
                this._resultField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "result", value.data());
                this._resultField = value;
            }
        }
        return this;
    }

    public AssertionRunEvent setResult(@Nonnull AssertionResult value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field result of com.linkedin.assertion.AssertionRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "result", value.data());
        this._resultField = value;
        return this;
    }

    public boolean hasRuntimeContext() {
        if (this._runtimeContextField != null) {
            return true;
        }
        return this._map.containsKey("runtimeContext");
    }

    public void removeRuntimeContext() {
        this._map.remove("runtimeContext");
    }

    @Nullable
    public StringMap getRuntimeContext(GetMode mode) {
        return this.getRuntimeContext();
    }

    @Nullable
    public StringMap getRuntimeContext() {
        if (this._runtimeContextField != null) {
            return this._runtimeContextField;
        }
        Object __rawValue = this._map.get("runtimeContext");
        this._runtimeContextField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._runtimeContextField;
    }

    public AssertionRunEvent setRuntimeContext(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRuntimeContext(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRuntimeContext();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "runtimeContext", value.data());
                this._runtimeContextField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "runtimeContext", value.data());
                this._runtimeContextField = value;
            }
        }
        return this;
    }

    public AssertionRunEvent setRuntimeContext(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field runtimeContext of com.linkedin.assertion.AssertionRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "runtimeContext", value.data());
        this._runtimeContextField = value;
        return this;
    }

    public boolean hasBatchSpec() {
        if (this._batchSpecField != null) {
            return true;
        }
        return this._map.containsKey("batchSpec");
    }

    public void removeBatchSpec() {
        this._map.remove("batchSpec");
    }

    @Nullable
    public BatchSpec getBatchSpec(GetMode mode) {
        return this.getBatchSpec();
    }

    @Nullable
    public BatchSpec getBatchSpec() {
        if (this._batchSpecField != null) {
            return this._batchSpecField;
        }
        Object __rawValue = this._map.get("batchSpec");
        this._batchSpecField = __rawValue == null ? null : new BatchSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._batchSpecField;
    }

    public AssertionRunEvent setBatchSpec(@Nullable BatchSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setBatchSpec(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeBatchSpec();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "batchSpec", value.data());
                this._batchSpecField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "batchSpec", value.data());
                this._batchSpecField = value;
            }
        }
        return this;
    }

    public AssertionRunEvent setBatchSpec(@Nonnull BatchSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field batchSpec of com.linkedin.assertion.AssertionRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "batchSpec", value.data());
        this._batchSpecField = value;
        return this;
    }

    public boolean hasAssertionUrn() {
        if (this._assertionUrnField != null) {
            return true;
        }
        return this._map.containsKey("assertionUrn");
    }

    public void removeAssertionUrn() {
        this._map.remove("assertionUrn");
    }

    @Nullable
    public Urn getAssertionUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAssertionUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._assertionUrnField != null) {
                    return this._assertionUrnField;
                }
                Object __rawValue = this._map.get("assertionUrn");
                this._assertionUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._assertionUrnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getAssertionUrn() {
        if (this._assertionUrnField != null) {
            return this._assertionUrnField;
        }
        Object __rawValue = this._map.get("assertionUrn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("assertionUrn");
        }
        this._assertionUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._assertionUrnField;
    }

    public AssertionRunEvent setAssertionUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAssertionUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field assertionUrn of com.linkedin.assertion.AssertionRunEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "assertionUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._assertionUrnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAssertionUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "assertionUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._assertionUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "assertionUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._assertionUrnField = value;
            }
        }
        return this;
    }

    public AssertionRunEvent setAssertionUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field assertionUrn of com.linkedin.assertion.AssertionRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "assertionUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._assertionUrnField = value;
        return this;
    }

    public boolean hasEventGranularity() {
        if (this._eventGranularityField != null) {
            return true;
        }
        return this._map.containsKey("eventGranularity");
    }

    public void removeEventGranularity() {
        this._map.remove("eventGranularity");
    }

    @Nullable
    public TimeWindowSize getEventGranularity(GetMode mode) {
        return this.getEventGranularity();
    }

    @Nullable
    public TimeWindowSize getEventGranularity() {
        if (this._eventGranularityField != null) {
            return this._eventGranularityField;
        }
        Object __rawValue = this._map.get("eventGranularity");
        this._eventGranularityField = __rawValue == null ? null : new TimeWindowSize(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._eventGranularityField;
    }

    public AssertionRunEvent setEventGranularity(@Nullable TimeWindowSize value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEventGranularity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEventGranularity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
            }
        }
        return this;
    }

    public AssertionRunEvent setEventGranularity(@Nonnull TimeWindowSize value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field eventGranularity of com.linkedin.assertion.AssertionRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
        this._eventGranularityField = value;
        return this;
    }

    public boolean hasPartitionSpec() {
        if (this._partitionSpecField != null) {
            return true;
        }
        return this._map.containsKey("partitionSpec");
    }

    public void removePartitionSpec() {
        this._map.remove("partitionSpec");
    }

    @Nullable
    public PartitionSpec getPartitionSpec(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPartitionSpec();
            }
            case NULL: {
                if (this._partitionSpecField != null) {
                    return this._partitionSpecField;
                }
                Object __rawValue = this._map.get("partitionSpec");
                this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._partitionSpecField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public PartitionSpec getPartitionSpec() {
        if (this._partitionSpecField != null) {
            return this._partitionSpecField;
        }
        Object __rawValue = this._map.get("partitionSpec");
        if (__rawValue == null) {
            return DEFAULT_PartitionSpec;
        }
        this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._partitionSpecField;
    }

    public AssertionRunEvent setPartitionSpec(@Nullable PartitionSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPartitionSpec(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePartitionSpec();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
            }
        }
        return this;
    }

    public AssertionRunEvent setPartitionSpec(@Nonnull PartitionSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field partitionSpec of com.linkedin.assertion.AssertionRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
        this._partitionSpecField = value;
        return this;
    }

    public boolean hasMessageId() {
        if (this._messageIdField != null) {
            return true;
        }
        return this._map.containsKey("messageId");
    }

    public void removeMessageId() {
        this._map.remove("messageId");
    }

    @Nullable
    public String getMessageId(GetMode mode) {
        return this.getMessageId();
    }

    @Nullable
    public String getMessageId() {
        if (this._messageIdField != null) {
            return this._messageIdField;
        }
        Object __rawValue = this._map.get("messageId");
        this._messageIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._messageIdField;
    }

    public AssertionRunEvent setMessageId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMessageId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMessageId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
            }
        }
        return this;
    }

    public AssertionRunEvent setMessageId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field messageId of com.linkedin.assertion.AssertionRunEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "messageId", value);
        this._messageIdField = value;
        return this;
    }

    @Override
    public AssertionRunEvent clone() throws CloneNotSupportedException {
        AssertionRunEvent __clone = (AssertionRunEvent)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AssertionRunEvent copy() throws CloneNotSupportedException {
        AssertionRunEvent __copy = (AssertionRunEvent)super.copy();
        __copy._resultField = null;
        __copy._assertionUrnField = null;
        __copy._timestampMillisField = null;
        __copy._runtimeContextField = null;
        __copy._eventGranularityField = null;
        __copy._messageIdField = null;
        __copy._asserteeUrnField = null;
        __copy._runIdField = null;
        __copy._batchSpecField = null;
        __copy._partitionSpecField = null;
        __copy._statusField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_MessageId = SCHEMA.getField("messageId");
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_PartitionSpec = FIELD_PartitionSpec.getDefault() == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(FIELD_PartitionSpec.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AssertionRunEvent __objectRef;

        private ChangeListener(AssertionRunEvent reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "result": {
                    this.__objectRef._resultField = null;
                    break;
                }
                case "assertionUrn": {
                    this.__objectRef._assertionUrnField = null;
                    break;
                }
                case "timestampMillis": {
                    this.__objectRef._timestampMillisField = null;
                    break;
                }
                case "runtimeContext": {
                    this.__objectRef._runtimeContextField = null;
                    break;
                }
                case "eventGranularity": {
                    this.__objectRef._eventGranularityField = null;
                    break;
                }
                case "messageId": {
                    this.__objectRef._messageIdField = null;
                    break;
                }
                case "asserteeUrn": {
                    this.__objectRef._asserteeUrnField = null;
                    break;
                }
                case "runId": {
                    this.__objectRef._runIdField = null;
                    break;
                }
                case "batchSpec": {
                    this.__objectRef._batchSpecField = null;
                    break;
                }
                case "partitionSpec": {
                    this.__objectRef._partitionSpecField = null;
                    break;
                }
                case "status": {
                    this.__objectRef._statusField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec timestampMillis() {
            return new PathSpec(this.getPathComponents(), "timestampMillis");
        }

        public PathSpec runId() {
            return new PathSpec(this.getPathComponents(), "runId");
        }

        public PathSpec asserteeUrn() {
            return new PathSpec(this.getPathComponents(), "asserteeUrn");
        }

        public PathSpec status() {
            return new PathSpec(this.getPathComponents(), "status");
        }

        public AssertionResult.Fields result() {
            return new AssertionResult.Fields(this.getPathComponents(), "result");
        }

        public PathSpec runtimeContext() {
            return new PathSpec(this.getPathComponents(), "runtimeContext");
        }

        public BatchSpec.Fields batchSpec() {
            return new BatchSpec.Fields(this.getPathComponents(), "batchSpec");
        }

        public PathSpec assertionUrn() {
            return new PathSpec(this.getPathComponents(), "assertionUrn");
        }

        public TimeWindowSize.Fields eventGranularity() {
            return new TimeWindowSize.Fields(this.getPathComponents(), "eventGranularity");
        }

        public PartitionSpec.Fields partitionSpec() {
            return new PartitionSpec.Fields(this.getPathComponents(), "partitionSpec");
        }

        public PathSpec messageId() {
            return new PathSpec(this.getPathComponents(), "messageId");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AssertionResult.ProjectionMask _resultMask;
        private BatchSpec.ProjectionMask _batchSpecMask;
        private TimeWindowSize.ProjectionMask _eventGranularityMask;
        private PartitionSpec.ProjectionMask _partitionSpecMask;

        ProjectionMask() {
            super(15);
        }

        public ProjectionMask withTimestampMillis() {
            this.getDataMap().put("timestampMillis", 1);
            return this;
        }

        public ProjectionMask withRunId() {
            this.getDataMap().put("runId", 1);
            return this;
        }

        public ProjectionMask withAsserteeUrn() {
            this.getDataMap().put("asserteeUrn", 1);
            return this;
        }

        public ProjectionMask withStatus() {
            this.getDataMap().put("status", 1);
            return this;
        }

        public ProjectionMask withResult(Function<AssertionResult.ProjectionMask, AssertionResult.ProjectionMask> nestedMask) {
            this._resultMask = nestedMask.apply(this._resultMask == null ? AssertionResult.createMask() : this._resultMask);
            this.getDataMap().put("result", this._resultMask.getDataMap());
            return this;
        }

        public ProjectionMask withResult() {
            this._resultMask = null;
            this.getDataMap().put("result", 1);
            return this;
        }

        public ProjectionMask withRuntimeContext() {
            this.getDataMap().put("runtimeContext", 1);
            return this;
        }

        public ProjectionMask withBatchSpec(Function<BatchSpec.ProjectionMask, BatchSpec.ProjectionMask> nestedMask) {
            this._batchSpecMask = nestedMask.apply(this._batchSpecMask == null ? BatchSpec.createMask() : this._batchSpecMask);
            this.getDataMap().put("batchSpec", this._batchSpecMask.getDataMap());
            return this;
        }

        public ProjectionMask withBatchSpec() {
            this._batchSpecMask = null;
            this.getDataMap().put("batchSpec", 1);
            return this;
        }

        public ProjectionMask withAssertionUrn() {
            this.getDataMap().put("assertionUrn", 1);
            return this;
        }

        public ProjectionMask withEventGranularity(Function<TimeWindowSize.ProjectionMask, TimeWindowSize.ProjectionMask> nestedMask) {
            this._eventGranularityMask = nestedMask.apply(this._eventGranularityMask == null ? TimeWindowSize.createMask() : this._eventGranularityMask);
            this.getDataMap().put("eventGranularity", this._eventGranularityMask.getDataMap());
            return this;
        }

        public ProjectionMask withEventGranularity() {
            this._eventGranularityMask = null;
            this.getDataMap().put("eventGranularity", 1);
            return this;
        }

        public ProjectionMask withPartitionSpec(Function<PartitionSpec.ProjectionMask, PartitionSpec.ProjectionMask> nestedMask) {
            this._partitionSpecMask = nestedMask.apply(this._partitionSpecMask == null ? PartitionSpec.createMask() : this._partitionSpecMask);
            this.getDataMap().put("partitionSpec", this._partitionSpecMask.getDataMap());
            return this;
        }

        public ProjectionMask withPartitionSpec() {
            this._partitionSpecMask = null;
            this.getDataMap().put("partitionSpec", 1);
            return this;
        }

        public ProjectionMask withMessageId() {
            this.getDataMap().put("messageId", 1);
            return this;
        }
    }
}

