/*
 * Decompiled with CFR 0.152.
 */
package com.datahub.util;

import com.datahub.common.DummySnapshot;
import com.datahub.util.RecordUtils;
import com.datahub.util.exception.InvalidSchemaException;
import com.datahub.util.validator.AspectValidator;
import com.datahub.util.validator.DeltaValidator;
import com.datahub.util.validator.DocumentValidator;
import com.datahub.util.validator.EntityValidator;
import com.datahub.util.validator.RelationshipValidator;
import com.datahub.util.validator.SnapshotValidator;
import com.datahub.util.validator.ValidationUtils;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.data.template.WrappingArrayTemplate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ModelUtils {
    private static final ClassLoader CLASS_LOADER = DummySnapshot.class.getClassLoader();
    private static final String METADATA_AUDIT_EVENT_PREFIX = "METADATA_AUDIT_EVENT";

    private ModelUtils() {
    }

    public static <T extends DataTemplate> String getAspectName(@Nonnull Class<T> aspectClass) {
        return aspectClass.getCanonicalName();
    }

    @Nonnull
    public static Class<? extends RecordTemplate> getAspectClass(@Nonnull String aspectName) {
        return ModelUtils.getClassFromName(aspectName, RecordTemplate.class);
    }

    @Nonnull
    public static <ASPECT_UNION extends UnionTemplate> Set<Class<? extends RecordTemplate>> getValidAspectTypes(@Nonnull Class<ASPECT_UNION> aspectUnionClass) {
        AspectValidator.validateAspectUnionSchema(aspectUnionClass);
        HashSet<Class<? extends RecordTemplate>> validTypes = new HashSet<Class<? extends RecordTemplate>>();
        for (UnionDataSchema.Member member : ValidationUtils.getUnionSchema(aspectUnionClass).getMembers()) {
            if (member.getType().getType() != DataSchema.Type.RECORD) continue;
            String fqcn = ((RecordDataSchema)member.getType()).getBindingName();
            try {
                validTypes.add(CLASS_LOADER.loadClass(fqcn).asSubclass(RecordTemplate.class));
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return validTypes;
    }

    @Nonnull
    public static <T> Class<? extends T> getClassFromName(@Nonnull String className, @Nonnull Class<T> parentClass) {
        try {
            return CLASS_LOADER.loadClass(className).asSubclass(parentClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static Class<? extends RecordTemplate> getMetadataSnapshotClassFromName(@Nonnull String className) {
        Class<RecordTemplate> snapshotClass = ModelUtils.getClassFromName(className, RecordTemplate.class);
        SnapshotValidator.validateSnapshotSchema(snapshotClass);
        return snapshotClass;
    }

    @Nonnull
    public static <SNAPSHOT extends RecordTemplate> Urn getUrnFromSnapshot(@Nonnull SNAPSHOT snapshot) {
        SnapshotValidator.validateSnapshotSchema(snapshot.getClass());
        return RecordUtils.getRecordTemplateField(snapshot, "urn", ModelUtils.urnClassForSnapshot(snapshot.getClass()));
    }

    @Nonnull
    public static Urn getUrnFromSnapshotUnion(@Nonnull UnionTemplate snapshotUnion) {
        return ModelUtils.getUrnFromSnapshot(RecordUtils.getSelectedRecordTemplateFromUnion(snapshotUnion));
    }

    @Nonnull
    public static <DELTA extends RecordTemplate> Urn getUrnFromDelta(@Nonnull DELTA delta) {
        DeltaValidator.validateDeltaSchema(delta.getClass());
        return RecordUtils.getRecordTemplateField(delta, "urn", ModelUtils.urnClassForDelta(delta.getClass()));
    }

    @Nonnull
    public static Urn getUrnFromDeltaUnion(@Nonnull UnionTemplate deltaUnion) {
        return ModelUtils.getUrnFromDelta(RecordUtils.getSelectedRecordTemplateFromUnion(deltaUnion));
    }

    @Nonnull
    public static <DOCUMENT extends RecordTemplate> Urn getUrnFromDocument(@Nonnull DOCUMENT document) {
        DocumentValidator.validateDocumentSchema(document.getClass());
        return RecordUtils.getRecordTemplateField(document, "urn", ModelUtils.urnClassForDocument(document.getClass()));
    }

    @Nonnull
    public static <ENTITY extends RecordTemplate> Urn getUrnFromEntity(@Nonnull ENTITY entity) {
        EntityValidator.validateEntitySchema(entity.getClass());
        return RecordUtils.getRecordTemplateField(entity, "urn", ModelUtils.urnClassForDocument(entity.getClass()));
    }

    @Nonnull
    private static <RELATIONSHIP extends RecordTemplate> Urn getUrnFromRelationship(@Nonnull RELATIONSHIP relationship, @Nonnull String fieldName) {
        RelationshipValidator.validateRelationshipSchema(relationship.getClass());
        return RecordUtils.getRecordTemplateField(relationship, fieldName, ModelUtils.urnClassForRelationship(relationship.getClass(), fieldName));
    }

    @Nonnull
    public static <RELATIONSHIP extends RecordTemplate> Urn getSourceUrnFromRelationship(@Nonnull RELATIONSHIP relationship) {
        return ModelUtils.getUrnFromRelationship(relationship, "source");
    }

    @Nonnull
    public static <RELATIONSHIP extends RecordTemplate> Urn getDestinationUrnFromRelationship(@Nonnull RELATIONSHIP relationship) {
        return ModelUtils.getUrnFromRelationship(relationship, "destination");
    }

    @Nonnull
    public static <SNAPSHOT extends RecordTemplate> List<RecordTemplate> getAspectsFromSnapshot(@Nonnull SNAPSHOT snapshot) {
        SnapshotValidator.validateSnapshotSchema(snapshot.getClass());
        return ModelUtils.getAspects(snapshot);
    }

    @Nonnull
    public static <SNAPSHOT extends RecordTemplate, ASPECT extends DataTemplate> Optional<ASPECT> getAspectFromSnapshot(@Nonnull SNAPSHOT snapshot, @Nonnull Class<ASPECT> aspectClass) {
        return ModelUtils.getAspectsFromSnapshot(snapshot).stream().filter(aspect -> aspect.getClass().equals(aspectClass)).findFirst().map(aspectClass::cast);
    }

    @Nonnull
    public static List<RecordTemplate> getAspectsFromSnapshotUnion(@Nonnull UnionTemplate snapshotUnion) {
        return ModelUtils.getAspects(RecordUtils.getSelectedRecordTemplateFromUnion(snapshotUnion));
    }

    @Nonnull
    private static List<RecordTemplate> getAspects(@Nonnull RecordTemplate snapshot) {
        Class<WrappingArrayTemplate> clazz = ModelUtils.getAspectsArrayClass(snapshot.getClass());
        WrappingArrayTemplate aspectArray = RecordUtils.getRecordTemplateWrappedField(snapshot, "aspects", clazz);
        ArrayList<RecordTemplate> aspects = new ArrayList<RecordTemplate>();
        aspectArray.forEach(item -> aspects.add(RecordUtils.getSelectedRecordTemplateFromUnion((UnionTemplate)item)));
        return aspects;
    }

    @Nonnull
    public static <SNAPSHOT extends RecordTemplate, ASPECT_UNION extends UnionTemplate, URN extends Urn> SNAPSHOT newSnapshot(@Nonnull Class<SNAPSHOT> snapshotClass, @Nonnull URN urn, @Nonnull List<ASPECT_UNION> aspects) {
        SnapshotValidator.validateSnapshotSchema(snapshotClass);
        Class<WrappingArrayTemplate> aspectArrayClass = ModelUtils.getAspectsArrayClass(snapshotClass);
        try {
            RecordTemplate snapshot = (RecordTemplate)snapshotClass.newInstance();
            RecordUtils.setRecordTemplatePrimitiveField(snapshot, "urn", urn.toString());
            WrappingArrayTemplate aspectArray = aspectArrayClass.newInstance();
            aspectArray.addAll(aspects);
            RecordUtils.setRecordTemplateComplexField(snapshot, "aspects", aspectArray);
            return (SNAPSHOT)snapshot;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private static <SNAPSHOT extends RecordTemplate> Class<? extends WrappingArrayTemplate> getAspectsArrayClass(@Nonnull Class<SNAPSHOT> snapshotClass) {
        try {
            return snapshotClass.getMethod("getAspects", new Class[0]).getReturnType().asSubclass(WrappingArrayTemplate.class);
        }
        catch (ClassCastException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static <ASPECT_UNION extends UnionTemplate, ASPECT extends RecordTemplate> ASPECT_UNION newAspectUnion(@Nonnull Class<ASPECT_UNION> aspectUnionClass, @Nonnull ASPECT aspect) {
        AspectValidator.validateAspectUnionSchema(aspectUnionClass);
        try {
            UnionTemplate aspectUnion = (UnionTemplate)aspectUnionClass.newInstance();
            RecordUtils.setSelectedRecordTemplateInUnion(aspectUnion, aspect);
            return (ASPECT_UNION)aspectUnion;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static Class<? extends UnionTemplate> aspectClassForSnapshot(@Nonnull Class<? extends RecordTemplate> snapshotClass) {
        SnapshotValidator.validateSnapshotSchema(snapshotClass);
        String aspectClassName = ((TyperefDataSchema)((ArrayDataSchema)ValidationUtils.getRecordSchema(snapshotClass).getField("aspects").getType()).getItems()).getBindingName();
        return ModelUtils.getClassFromName(aspectClassName, UnionTemplate.class);
    }

    @Nonnull
    public static Class<? extends Urn> urnClassForEntity(@Nonnull Class<? extends RecordTemplate> entityClass) {
        EntityValidator.validateEntitySchema(entityClass);
        return ModelUtils.urnClassForField(entityClass, "urn");
    }

    @Nonnull
    public static Class<? extends Urn> urnClassForSnapshot(@Nonnull Class<? extends RecordTemplate> snapshotClass) {
        SnapshotValidator.validateSnapshotSchema(snapshotClass);
        return ModelUtils.urnClassForField(snapshotClass, "urn");
    }

    @Nonnull
    public static Class<? extends Urn> urnClassForDelta(@Nonnull Class<? extends RecordTemplate> deltaClass) {
        DeltaValidator.validateDeltaSchema(deltaClass);
        return ModelUtils.urnClassForField(deltaClass, "urn");
    }

    @Nonnull
    public static Class<? extends Urn> urnClassForDocument(@Nonnull Class<? extends RecordTemplate> documentClass) {
        DocumentValidator.validateDocumentSchema(documentClass);
        return ModelUtils.urnClassForField(documentClass, "urn");
    }

    @Nonnull
    private static Class<? extends Urn> urnClassForRelationship(@Nonnull Class<? extends RecordTemplate> relationshipClass, @Nonnull String fieldName) {
        RelationshipValidator.validateRelationshipSchema(relationshipClass);
        return ModelUtils.urnClassForField(relationshipClass, fieldName);
    }

    @Nonnull
    public static Class<? extends Urn> sourceUrnClassForRelationship(@Nonnull Class<? extends RecordTemplate> relationshipClass) {
        return ModelUtils.urnClassForRelationship(relationshipClass, "source");
    }

    @Nonnull
    public static Class<? extends Urn> destinationUrnClassForRelationship(@Nonnull Class<? extends RecordTemplate> relationshipClass) {
        return ModelUtils.urnClassForRelationship(relationshipClass, "destination");
    }

    @Nonnull
    private static Class<? extends Urn> urnClassForField(@Nonnull Class<? extends RecordTemplate> recordClass, @Nonnull String fieldName) {
        String urnClassName = ((DataMap)ValidationUtils.getRecordSchema(recordClass).getField(fieldName).getType().getProperties().get("java")).getString("class");
        return ModelUtils.getClassFromName(urnClassName, Urn.class);
    }

    public static <SNAPSHOT extends RecordTemplate, ASPECT_UNION extends UnionTemplate> void validateSnapshotAspect(@Nonnull Class<SNAPSHOT> snapshotClass, @Nonnull Class<ASPECT_UNION> aspectUnionClass) {
        SnapshotValidator.validateSnapshotSchema(snapshotClass);
        AspectValidator.validateAspectUnionSchema(aspectUnionClass);
        if (!ModelUtils.aspectClassForSnapshot(snapshotClass).equals(aspectUnionClass)) {
            throw new InvalidSchemaException(aspectUnionClass.getCanonicalName() + " is not a supported aspect class of " + snapshotClass.getCanonicalName());
        }
    }

    public static <SNAPSHOT extends RecordTemplate, URN extends Urn> void validateSnapshotUrn(@Nonnull Class<SNAPSHOT> snapshotClass, @Nonnull Class<URN> urnClass) {
        SnapshotValidator.validateSnapshotSchema(snapshotClass);
        if (!ModelUtils.urnClassForSnapshot(snapshotClass).isAssignableFrom(urnClass)) {
            throw new InvalidSchemaException(urnClass.getCanonicalName() + " is not a supported URN class of " + snapshotClass.getCanonicalName());
        }
    }

    @Nonnull
    public static <RELATIONSHIP_UNION extends UnionTemplate, RELATIONSHIP extends RecordTemplate> RELATIONSHIP_UNION newRelationshipUnion(@Nonnull Class<RELATIONSHIP_UNION> relationshipUnionClass, @Nonnull RELATIONSHIP relationship) {
        RelationshipValidator.validateRelationshipUnionSchema(relationshipUnionClass);
        try {
            UnionTemplate relationshipUnion = (UnionTemplate)relationshipUnionClass.newInstance();
            RecordUtils.setSelectedRecordTemplateInUnion(relationshipUnion, relationship);
            return (RELATIONSHIP_UNION)relationshipUnion;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static Set<Class<? extends RecordTemplate>> getAllEntities() {
        return new Reflections("com.linkedin.metadata.entity", new Scanner[0]).getSubTypesOf(RecordTemplate.class).stream().filter(EntityValidator::isValidEntitySchema).collect(Collectors.toSet());
    }

    @Nonnull
    public static String getEntityTypeFromUrnClass(@Nonnull Class<? extends Urn> urnClass) {
        try {
            return urnClass.getDeclaredField("ENTITY_TYPE").get(null).toString();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static <URN extends Urn, ASPECT extends RecordTemplate> String getAspectSpecificMAETopicName(@Nonnull URN urn, @Nonnull ASPECT newValue) {
        return String.format("%s_%s_%s", METADATA_AUDIT_EVENT_PREFIX, urn.getEntityType().toUpperCase(), newValue.getClass().getSimpleName().toUpperCase());
    }

    @Nonnull
    public static <ENTITY_UNION extends UnionTemplate, ENTITY extends RecordTemplate> ENTITY_UNION newEntityUnion(@Nonnull Class<ENTITY_UNION> entityUnionClass, @Nonnull ENTITY entity) {
        EntityValidator.validateEntityUnionSchema(entityUnionClass);
        try {
            UnionTemplate entityUnion = (UnionTemplate)entityUnionClass.newInstance();
            RecordUtils.setSelectedRecordTemplateInUnion(entityUnion, entity);
            return (ENTITY_UNION)entityUnion;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

