/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.schema;

import com.linkedin.common.GlobalTags;
import com.linkedin.common.GlossaryTerms;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EditableSchemaFieldInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.schema/**SchemaField to describe metadata related to dataset schema.*/record EditableSchemaFieldInfo{/**FieldPath uniquely identifying the SchemaField this metadata is associated with*/fieldPath:string/**Description*/@Searchable={\"boostScore\":0.1,\"fieldName\":\"editedFieldDescriptions\",\"fieldType\":\"TEXT\",\"searchTier\":2}description:optional string/**Tags associated with the field*/@Relationship.`/tags/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"EditableSchemaFieldTaggedWith\"}@Searchable={\"/tags/*/attribution/actor\":{\"fieldName\":\"editedFieldTagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/source\":{\"fieldName\":\"editedFieldTagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/tags/*/attribution/time\":{\"fieldName\":\"editedFieldTagAttributionDates\",\"fieldType\":\"DATETIME\"},\"/tags/*/tag\":{\"boostScore\":0.5,\"fieldName\":\"editedFieldTags\",\"fieldType\":\"URN\"}}globalTags:optional{namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tagged With\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true,\"searchTier\":2}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]}}/**Glossary terms associated with the field*/@Relationship.`/terms/*/urn`={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"EditableSchemaFieldWithGlossaryTerm\"}@Searchable={\"/terms/*/attribution/actor\":{\"fieldName\":\"editedFieldTermAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/source\":{\"fieldName\":\"editedFieldTermAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/terms/*/attribution/time\":{\"fieldName\":\"editedFieldTermAttributionDates\",\"fieldType\":\"DATETIME\"},\"/terms/*/urn\":{\"boostScore\":0.5,\"fieldName\":\"editedFieldGlossaryTerms\",\"fieldType\":\"URN\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"schemaFieldTermsModifiedAt\"}}glossaryTerms:optional{namespace com.linkedin.common/**Related business terms information*/@Aspect.name=\"glossaryTerms\"record GlossaryTerms{/**The related business terms*/terms:array[/**Properties of an applied glossary term.*/record GlossaryTermAssociation{/**Urn of the applied glossary term*/@Relationship={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"TermedWith\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"glossaryTerms\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Glossary Term\",\"hasValuesFieldName\":\"hasGlossaryTerms\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"termsModifiedAt\"}urn:/**Business Term*/@java.class=\"com.linkedin.common.urn.GlossaryTermUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"business term\",\"entityType\":\"glossaryTerm\",\"fields\":[{\"doc\":\"The name of business term with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryTerm\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryTermUrn=string/**The user URN which will be credited for adding associating this term to the entity*/actor:optional Urn/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"termAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"termAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"termAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional MetadataAttribution}]/**Audit stamp containing who reported the related business term*/auditStamp:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:Time/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}}", SchemaFormatType.PDL);
    private String _fieldPathField = null;
    private String _descriptionField = null;
    private GlobalTags _globalTagsField = null;
    private GlossaryTerms _glossaryTermsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_FieldPath = SCHEMA.getField("fieldPath");
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");
    private static final RecordDataSchema.Field FIELD_GlobalTags = SCHEMA.getField("globalTags");
    private static final RecordDataSchema.Field FIELD_GlossaryTerms = SCHEMA.getField("glossaryTerms");

    public EditableSchemaFieldInfo() {
        super(new DataMap(6, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public EditableSchemaFieldInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasFieldPath() {
        if (this._fieldPathField != null) {
            return true;
        }
        return this._map.containsKey("fieldPath");
    }

    public void removeFieldPath() {
        this._map.remove("fieldPath");
    }

    @Nullable
    public String getFieldPath(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFieldPath();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fieldPathField != null) {
                    return this._fieldPathField;
                }
                Object __rawValue = this._map.get("fieldPath");
                this._fieldPathField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._fieldPathField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getFieldPath() {
        if (this._fieldPathField != null) {
            return this._fieldPathField;
        }
        Object __rawValue = this._map.get("fieldPath");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("fieldPath");
        }
        this._fieldPathField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._fieldPathField;
    }

    public EditableSchemaFieldInfo setFieldPath(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFieldPath(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field fieldPath of com.linkedin.schema.EditableSchemaFieldInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFieldPath();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
            }
        }
        return this;
    }

    public EditableSchemaFieldInfo setFieldPath(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fieldPath of com.linkedin.schema.EditableSchemaFieldInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
        this._fieldPathField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public EditableSchemaFieldInfo setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public EditableSchemaFieldInfo setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.schema.EditableSchemaFieldInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasGlobalTags() {
        if (this._globalTagsField != null) {
            return true;
        }
        return this._map.containsKey("globalTags");
    }

    public void removeGlobalTags() {
        this._map.remove("globalTags");
    }

    @Nullable
    public GlobalTags getGlobalTags(GetMode mode) {
        return this.getGlobalTags();
    }

    @Nullable
    public GlobalTags getGlobalTags() {
        if (this._globalTagsField != null) {
            return this._globalTagsField;
        }
        Object __rawValue = this._map.get("globalTags");
        this._globalTagsField = __rawValue == null ? null : new GlobalTags(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._globalTagsField;
    }

    public EditableSchemaFieldInfo setGlobalTags(@Nullable GlobalTags value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGlobalTags(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGlobalTags();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "globalTags", value.data());
                this._globalTagsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "globalTags", value.data());
                this._globalTagsField = value;
            }
        }
        return this;
    }

    public EditableSchemaFieldInfo setGlobalTags(@Nonnull GlobalTags value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field globalTags of com.linkedin.schema.EditableSchemaFieldInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "globalTags", value.data());
        this._globalTagsField = value;
        return this;
    }

    public boolean hasGlossaryTerms() {
        if (this._glossaryTermsField != null) {
            return true;
        }
        return this._map.containsKey("glossaryTerms");
    }

    public void removeGlossaryTerms() {
        this._map.remove("glossaryTerms");
    }

    @Nullable
    public GlossaryTerms getGlossaryTerms(GetMode mode) {
        return this.getGlossaryTerms();
    }

    @Nullable
    public GlossaryTerms getGlossaryTerms() {
        if (this._glossaryTermsField != null) {
            return this._glossaryTermsField;
        }
        Object __rawValue = this._map.get("glossaryTerms");
        this._glossaryTermsField = __rawValue == null ? null : new GlossaryTerms(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._glossaryTermsField;
    }

    public EditableSchemaFieldInfo setGlossaryTerms(@Nullable GlossaryTerms value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGlossaryTerms(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGlossaryTerms();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "glossaryTerms", value.data());
                this._glossaryTermsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "glossaryTerms", value.data());
                this._glossaryTermsField = value;
            }
        }
        return this;
    }

    public EditableSchemaFieldInfo setGlossaryTerms(@Nonnull GlossaryTerms value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field glossaryTerms of com.linkedin.schema.EditableSchemaFieldInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "glossaryTerms", value.data());
        this._glossaryTermsField = value;
        return this;
    }

    @Override
    public EditableSchemaFieldInfo clone() throws CloneNotSupportedException {
        EditableSchemaFieldInfo __clone = (EditableSchemaFieldInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public EditableSchemaFieldInfo copy() throws CloneNotSupportedException {
        EditableSchemaFieldInfo __copy = (EditableSchemaFieldInfo)super.copy();
        __copy._fieldPathField = null;
        __copy._descriptionField = null;
        __copy._glossaryTermsField = null;
        __copy._globalTagsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final EditableSchemaFieldInfo __objectRef;

        private ChangeListener(EditableSchemaFieldInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "fieldPath": {
                    this.__objectRef._fieldPathField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "glossaryTerms": {
                    this.__objectRef._glossaryTermsField = null;
                    break;
                }
                case "globalTags": {
                    this.__objectRef._globalTagsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec fieldPath() {
            return new PathSpec(this.getPathComponents(), "fieldPath");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public GlobalTags.Fields globalTags() {
            return new GlobalTags.Fields(this.getPathComponents(), "globalTags");
        }

        public GlossaryTerms.Fields glossaryTerms() {
            return new GlossaryTerms.Fields(this.getPathComponents(), "glossaryTerms");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private GlobalTags.ProjectionMask _globalTagsMask;
        private GlossaryTerms.ProjectionMask _glossaryTermsMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withFieldPath() {
            this.getDataMap().put("fieldPath", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withGlobalTags(Function<GlobalTags.ProjectionMask, GlobalTags.ProjectionMask> nestedMask) {
            this._globalTagsMask = nestedMask.apply(this._globalTagsMask == null ? GlobalTags.createMask() : this._globalTagsMask);
            this.getDataMap().put("globalTags", this._globalTagsMask.getDataMap());
            return this;
        }

        public ProjectionMask withGlobalTags() {
            this._globalTagsMask = null;
            this.getDataMap().put("globalTags", 1);
            return this;
        }

        public ProjectionMask withGlossaryTerms(Function<GlossaryTerms.ProjectionMask, GlossaryTerms.ProjectionMask> nestedMask) {
            this._glossaryTermsMask = nestedMask.apply(this._glossaryTermsMask == null ? GlossaryTerms.createMask() : this._glossaryTermsMask);
            this.getDataMap().put("glossaryTerms", this._glossaryTermsMask.getDataMap());
            return this;
        }

        public ProjectionMask withGlossaryTerms() {
            this._glossaryTermsMask = null;
            this.getDataMap().put("glossaryTerms", 1);
            return this;
        }
    }
}

