/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.role;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.role.RoleGroupArray;
import com.linkedin.role.RoleUserArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Actors
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.role/**Provisioned users and groups of a role*/@Aspect.name=\"actors\"record Actors{/**List of provisioned users of a role*/users:optional array[/**Provisioned users of a role*/record RoleUser{/**Link provisioned corp user for a role*/@Relationship={\"entityTypes\":[\"corpuser\"],\"name\":\"Has\"}user:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}]/**List of provisioned groups of a role*/groups:optional array[/**Provisioned groups of a role*/record RoleGroup{/**Link provisioned corp group for a role*/@Relationship={\"entityTypes\":[\"corpGroup\"],\"name\":\"Has\"}group:com.linkedin.common.Urn}]}", SchemaFormatType.PDL);
    private RoleUserArray _usersField = null;
    private RoleGroupArray _groupsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Users = SCHEMA.getField("users");
    private static final RecordDataSchema.Field FIELD_Groups = SCHEMA.getField("groups");

    public Actors() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public Actors(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUsers() {
        if (this._usersField != null) {
            return true;
        }
        return this._map.containsKey("users");
    }

    public void removeUsers() {
        this._map.remove("users");
    }

    @Nullable
    public RoleUserArray getUsers(GetMode mode) {
        return this.getUsers();
    }

    @Nullable
    public RoleUserArray getUsers() {
        if (this._usersField != null) {
            return this._usersField;
        }
        Object __rawValue = this._map.get("users");
        this._usersField = __rawValue == null ? null : new RoleUserArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._usersField;
    }

    public Actors setUsers(@Nullable RoleUserArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUsers(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUsers();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "users", value.data());
                this._usersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "users", value.data());
                this._usersField = value;
            }
        }
        return this;
    }

    public Actors setUsers(@Nonnull RoleUserArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field users of com.linkedin.role.Actors to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "users", value.data());
        this._usersField = value;
        return this;
    }

    public boolean hasGroups() {
        if (this._groupsField != null) {
            return true;
        }
        return this._map.containsKey("groups");
    }

    public void removeGroups() {
        this._map.remove("groups");
    }

    @Nullable
    public RoleGroupArray getGroups(GetMode mode) {
        return this.getGroups();
    }

    @Nullable
    public RoleGroupArray getGroups() {
        if (this._groupsField != null) {
            return this._groupsField;
        }
        Object __rawValue = this._map.get("groups");
        this._groupsField = __rawValue == null ? null : new RoleGroupArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._groupsField;
    }

    public Actors setGroups(@Nullable RoleGroupArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGroups(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGroups();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
            }
        }
        return this;
    }

    public Actors setGroups(@Nonnull RoleGroupArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field groups of com.linkedin.role.Actors to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
        this._groupsField = value;
        return this;
    }

    @Override
    public Actors clone() throws CloneNotSupportedException {
        Actors __clone = (Actors)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Actors copy() throws CloneNotSupportedException {
        Actors __copy = (Actors)super.copy();
        __copy._groupsField = null;
        __copy._usersField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Actors __objectRef;

        private ChangeListener(Actors reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "groups": {
                    this.__objectRef._groupsField = null;
                    break;
                }
                case "users": {
                    this.__objectRef._usersField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public RoleUserArray.Fields users() {
            return new RoleUserArray.Fields(this.getPathComponents(), "users");
        }

        public PathSpec users(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "users");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public RoleGroupArray.Fields groups() {
            return new RoleGroupArray.Fields(this.getPathComponents(), "groups");
        }

        public PathSpec groups(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "groups");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private RoleUserArray.ProjectionMask _usersMask;
        private RoleGroupArray.ProjectionMask _groupsMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withUsers(Function<RoleUserArray.ProjectionMask, RoleUserArray.ProjectionMask> nestedMask) {
            this._usersMask = nestedMask.apply(this._usersMask == null ? RoleUserArray.createMask() : this._usersMask);
            this.getDataMap().put("users", this._usersMask.getDataMap());
            return this;
        }

        public ProjectionMask withUsers() {
            this._usersMask = null;
            this.getDataMap().put("users", 1);
            return this;
        }

        public ProjectionMask withUsers(Function<RoleUserArray.ProjectionMask, RoleUserArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._usersMask = nestedMask.apply(this._usersMask == null ? RoleUserArray.createMask() : this._usersMask);
            this.getDataMap().put("users", this._usersMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("users").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("users").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withUsers(Integer start, Integer count) {
            this._usersMask = null;
            this.getDataMap().put("users", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("users").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("users").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withGroups(Function<RoleGroupArray.ProjectionMask, RoleGroupArray.ProjectionMask> nestedMask) {
            this._groupsMask = nestedMask.apply(this._groupsMask == null ? RoleGroupArray.createMask() : this._groupsMask);
            this.getDataMap().put("groups", this._groupsMask.getDataMap());
            return this;
        }

        public ProjectionMask withGroups() {
            this._groupsMask = null;
            this.getDataMap().put("groups", 1);
            return this;
        }

        public ProjectionMask withGroups(Function<RoleGroupArray.ProjectionMask, RoleGroupArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._groupsMask = nestedMask.apply(this._groupsMask == null ? RoleGroupArray.createMask() : this._groupsMask);
            this.getDataMap().put("groups", this._groupsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("groups").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groups").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withGroups(Integer start, Integer count) {
            this._groupsMask = null;
            this.getDataMap().put("groups", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("groups").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groups").put("$count", count);
            }
            return this;
        }
    }
}

