/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.policy;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.policy.PolicyMatchFilter;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubResourceFilter
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.policy/**Information used to filter DataHub resource.*/record DataHubResourceFilter{/**The type of resource that the policy applies to. This will most often be a data asset entity name, for\nexample 'dataset'. It is not strictly required because in the future we will want to support filtering a resource\nby domain, as well.*/@deprecated,type:optional string/**A specific set of resources to apply the policy to, e.g. asset urns*/@deprecated,resources:optional array[string]/**Whether the policy should be applied to all assets matching the filter.*/@deprecated,allResources:boolean=false/**Filter to apply privileges to*/filter:optional/**The filter for specifying the resource or actor to apply privileges to*/record PolicyMatchFilter{/**A list of criteria to apply conjunctively (so all criteria must pass)*/criteria:array[/**A criterion for matching a field with given value*/record PolicyMatchCriterion{/**The name of the field that the criterion refers to*/field:string/**Values. Matches criterion if any one of the values matches condition (OR-relationship)*/values:array[string]/**The condition for the criterion*/condition:/**The matching condition in a filter criterion*/enum PolicyMatchCondition{/**Whether the field matches the value*/EQUALS/**Whether the field value starts with the value*/STARTS_WITH/**Whether the field does not match the value*/NOT_EQUALS}=\"EQUALS\"}]}/**Constraints around what sub-resources operations are allowed to modify, i.e. NOT_EQUALS - cannot modify a particular defined tag, EQUALS - can only modify a particular defined tag, STARTS_WITH - can only modify a tag starting with xyz*/privilegeConstraints:optional PolicyMatchFilter}", SchemaFormatType.PDL);
    private String _typeField = null;
    private StringArray _resourcesField = null;
    private Boolean _allResourcesField = null;
    private PolicyMatchFilter _filterField = null;
    private PolicyMatchFilter _privilegeConstraintsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Resources = SCHEMA.getField("resources");
    private static final RecordDataSchema.Field FIELD_AllResources = SCHEMA.getField("allResources");
    private static final Boolean DEFAULT_AllResources;
    private static final RecordDataSchema.Field FIELD_Filter;
    private static final RecordDataSchema.Field FIELD_PrivilegeConstraints;

    public DataHubResourceFilter() {
        super(new DataMap(7, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubResourceFilter(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    @Deprecated
    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    @Deprecated
    public void removeType() {
        this._map.remove("type");
    }

    @Deprecated
    @Nullable
    public String getType(GetMode mode) {
        return this.getType();
    }

    @Deprecated
    @Nullable
    public String getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._typeField;
    }

    @Deprecated
    public DataHubResourceFilter setType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
            }
        }
        return this;
    }

    @Deprecated
    public DataHubResourceFilter setType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.policy.DataHubResourceFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value);
        this._typeField = value;
        return this;
    }

    @Deprecated
    public boolean hasResources() {
        if (this._resourcesField != null) {
            return true;
        }
        return this._map.containsKey("resources");
    }

    @Deprecated
    public void removeResources() {
        this._map.remove("resources");
    }

    @Deprecated
    @Nullable
    public StringArray getResources(GetMode mode) {
        return this.getResources();
    }

    @Deprecated
    @Nullable
    public StringArray getResources() {
        if (this._resourcesField != null) {
            return this._resourcesField;
        }
        Object __rawValue = this._map.get("resources");
        this._resourcesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._resourcesField;
    }

    @Deprecated
    public DataHubResourceFilter setResources(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResources(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResources();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "resources", value.data());
                this._resourcesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "resources", value.data());
                this._resourcesField = value;
            }
        }
        return this;
    }

    @Deprecated
    public DataHubResourceFilter setResources(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field resources of com.linkedin.policy.DataHubResourceFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "resources", value.data());
        this._resourcesField = value;
        return this;
    }

    @Deprecated
    public boolean hasAllResources() {
        if (this._allResourcesField != null) {
            return true;
        }
        return this._map.containsKey("allResources");
    }

    @Deprecated
    public void removeAllResources() {
        this._map.remove("allResources");
    }

    @Deprecated
    @Nullable
    public Boolean isAllResources(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isAllResources();
            }
            case NULL: {
                if (this._allResourcesField != null) {
                    return this._allResourcesField;
                }
                Object __rawValue = this._map.get("allResources");
                this._allResourcesField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._allResourcesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public Boolean isAllResources() {
        if (this._allResourcesField != null) {
            return this._allResourcesField;
        }
        Object __rawValue = this._map.get("allResources");
        if (__rawValue == null) {
            return DEFAULT_AllResources;
        }
        this._allResourcesField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._allResourcesField;
    }

    @Deprecated
    public DataHubResourceFilter setAllResources(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAllResources(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field allResources of com.linkedin.policy.DataHubResourceFilter");
                }
                CheckedUtil.putWithoutChecking(this._map, "allResources", value);
                this._allResourcesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAllResources();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "allResources", value);
                this._allResourcesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "allResources", value);
                this._allResourcesField = value;
            }
        }
        return this;
    }

    @Deprecated
    public DataHubResourceFilter setAllResources(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field allResources of com.linkedin.policy.DataHubResourceFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "allResources", value);
        this._allResourcesField = value;
        return this;
    }

    @Deprecated
    public DataHubResourceFilter setAllResources(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "allResources", value);
        this._allResourcesField = value;
        return this;
    }

    public boolean hasFilter() {
        if (this._filterField != null) {
            return true;
        }
        return this._map.containsKey("filter");
    }

    public void removeFilter() {
        this._map.remove("filter");
    }

    @Nullable
    public PolicyMatchFilter getFilter(GetMode mode) {
        return this.getFilter();
    }

    @Nullable
    public PolicyMatchFilter getFilter() {
        if (this._filterField != null) {
            return this._filterField;
        }
        Object __rawValue = this._map.get("filter");
        this._filterField = __rawValue == null ? null : new PolicyMatchFilter(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._filterField;
    }

    public DataHubResourceFilter setFilter(@Nullable PolicyMatchFilter value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFilter(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFilter();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "filter", value.data());
                this._filterField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "filter", value.data());
                this._filterField = value;
            }
        }
        return this;
    }

    public DataHubResourceFilter setFilter(@Nonnull PolicyMatchFilter value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field filter of com.linkedin.policy.DataHubResourceFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "filter", value.data());
        this._filterField = value;
        return this;
    }

    public boolean hasPrivilegeConstraints() {
        if (this._privilegeConstraintsField != null) {
            return true;
        }
        return this._map.containsKey("privilegeConstraints");
    }

    public void removePrivilegeConstraints() {
        this._map.remove("privilegeConstraints");
    }

    @Nullable
    public PolicyMatchFilter getPrivilegeConstraints(GetMode mode) {
        return this.getPrivilegeConstraints();
    }

    @Nullable
    public PolicyMatchFilter getPrivilegeConstraints() {
        if (this._privilegeConstraintsField != null) {
            return this._privilegeConstraintsField;
        }
        Object __rawValue = this._map.get("privilegeConstraints");
        this._privilegeConstraintsField = __rawValue == null ? null : new PolicyMatchFilter(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._privilegeConstraintsField;
    }

    public DataHubResourceFilter setPrivilegeConstraints(@Nullable PolicyMatchFilter value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPrivilegeConstraints(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePrivilegeConstraints();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "privilegeConstraints", value.data());
                this._privilegeConstraintsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "privilegeConstraints", value.data());
                this._privilegeConstraintsField = value;
            }
        }
        return this;
    }

    public DataHubResourceFilter setPrivilegeConstraints(@Nonnull PolicyMatchFilter value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field privilegeConstraints of com.linkedin.policy.DataHubResourceFilter to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "privilegeConstraints", value.data());
        this._privilegeConstraintsField = value;
        return this;
    }

    @Override
    public DataHubResourceFilter clone() throws CloneNotSupportedException {
        DataHubResourceFilter __clone = (DataHubResourceFilter)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubResourceFilter copy() throws CloneNotSupportedException {
        DataHubResourceFilter __copy = (DataHubResourceFilter)super.copy();
        __copy._filterField = null;
        __copy._allResourcesField = null;
        __copy._privilegeConstraintsField = null;
        __copy._resourcesField = null;
        __copy._typeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Filter = SCHEMA.getField("filter");
        FIELD_PrivilegeConstraints = SCHEMA.getField("privilegeConstraints");
        DEFAULT_AllResources = DataTemplateUtil.coerceBooleanOutput(FIELD_AllResources.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubResourceFilter __objectRef;

        private ChangeListener(DataHubResourceFilter reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "filter": {
                    this.__objectRef._filterField = null;
                    break;
                }
                case "allResources": {
                    this.__objectRef._allResourcesField = null;
                    break;
                }
                case "privilegeConstraints": {
                    this.__objectRef._privilegeConstraintsField = null;
                    break;
                }
                case "resources": {
                    this.__objectRef._resourcesField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        @Deprecated
        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        @Deprecated
        public PathSpec resources() {
            return new PathSpec(this.getPathComponents(), "resources");
        }

        @Deprecated
        public PathSpec resources(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "resources");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        @Deprecated
        public PathSpec allResources() {
            return new PathSpec(this.getPathComponents(), "allResources");
        }

        public PolicyMatchFilter.Fields filter() {
            return new PolicyMatchFilter.Fields(this.getPathComponents(), "filter");
        }

        public PolicyMatchFilter.Fields privilegeConstraints() {
            return new PolicyMatchFilter.Fields(this.getPathComponents(), "privilegeConstraints");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private PolicyMatchFilter.ProjectionMask _filterMask;
        private PolicyMatchFilter.ProjectionMask _privilegeConstraintsMask;

        ProjectionMask() {
            super(7);
        }

        @Deprecated
        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withResources() {
            this.getDataMap().put("resources", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withResources(Integer start, Integer count) {
            this.getDataMap().put("resources", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("resources").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("resources").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withAllResources() {
            this.getDataMap().put("allResources", 1);
            return this;
        }

        public ProjectionMask withFilter(Function<PolicyMatchFilter.ProjectionMask, PolicyMatchFilter.ProjectionMask> nestedMask) {
            this._filterMask = nestedMask.apply(this._filterMask == null ? PolicyMatchFilter.createMask() : this._filterMask);
            this.getDataMap().put("filter", this._filterMask.getDataMap());
            return this;
        }

        public ProjectionMask withFilter() {
            this._filterMask = null;
            this.getDataMap().put("filter", 1);
            return this;
        }

        public ProjectionMask withPrivilegeConstraints(Function<PolicyMatchFilter.ProjectionMask, PolicyMatchFilter.ProjectionMask> nestedMask) {
            this._privilegeConstraintsMask = nestedMask.apply(this._privilegeConstraintsMask == null ? PolicyMatchFilter.createMask() : this._privilegeConstraintsMask);
            this.getDataMap().put("privilegeConstraints", this._privilegeConstraintsMask.getDataMap());
            return this;
        }

        public ProjectionMask withPrivilegeConstraints() {
            this._privilegeConstraintsMask = null;
            this.getDataMap().put("privilegeConstraints", 1);
            return this;
        }
    }
}

