/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MLModelFactors
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**Factors affecting the performance of the MLModel.*/record MLModelFactors{/**Groups refers to distinct categories with similar characteristics that are present in the evaluation data instances.\nFor human-centric machine learning MLModels, groups are people who share one or multiple characteristics.*/groups:optional array[string]/**The performance of a MLModel can vary depending on what instruments were used to capture the input to the MLModel.\nFor example, a face detection model may perform differently depending on the camera's hardware and software,\nincluding lens, image stabilization, high dynamic range techniques, and background blurring for portrait mode.*/instrumentation:optional array[string]/**A further factor affecting MLModel performance is the environment in which it is deployed.*/environment:optional array[string]}", SchemaFormatType.PDL);
    private StringArray _groupsField = null;
    private StringArray _instrumentationField = null;
    private StringArray _environmentField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Groups = SCHEMA.getField("groups");
    private static final RecordDataSchema.Field FIELD_Instrumentation = SCHEMA.getField("instrumentation");
    private static final RecordDataSchema.Field FIELD_Environment = SCHEMA.getField("environment");

    public MLModelFactors() {
        super(new DataMap(4, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public MLModelFactors(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasGroups() {
        if (this._groupsField != null) {
            return true;
        }
        return this._map.containsKey("groups");
    }

    public void removeGroups() {
        this._map.remove("groups");
    }

    @Nullable
    public StringArray getGroups(GetMode mode) {
        return this.getGroups();
    }

    @Nullable
    public StringArray getGroups() {
        if (this._groupsField != null) {
            return this._groupsField;
        }
        Object __rawValue = this._map.get("groups");
        this._groupsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._groupsField;
    }

    public MLModelFactors setGroups(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGroups(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGroups();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
            }
        }
        return this;
    }

    public MLModelFactors setGroups(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field groups of com.linkedin.ml.metadata.MLModelFactors to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
        this._groupsField = value;
        return this;
    }

    public boolean hasInstrumentation() {
        if (this._instrumentationField != null) {
            return true;
        }
        return this._map.containsKey("instrumentation");
    }

    public void removeInstrumentation() {
        this._map.remove("instrumentation");
    }

    @Nullable
    public StringArray getInstrumentation(GetMode mode) {
        return this.getInstrumentation();
    }

    @Nullable
    public StringArray getInstrumentation() {
        if (this._instrumentationField != null) {
            return this._instrumentationField;
        }
        Object __rawValue = this._map.get("instrumentation");
        this._instrumentationField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._instrumentationField;
    }

    public MLModelFactors setInstrumentation(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInstrumentation(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInstrumentation();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "instrumentation", value.data());
                this._instrumentationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "instrumentation", value.data());
                this._instrumentationField = value;
            }
        }
        return this;
    }

    public MLModelFactors setInstrumentation(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field instrumentation of com.linkedin.ml.metadata.MLModelFactors to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "instrumentation", value.data());
        this._instrumentationField = value;
        return this;
    }

    public boolean hasEnvironment() {
        if (this._environmentField != null) {
            return true;
        }
        return this._map.containsKey("environment");
    }

    public void removeEnvironment() {
        this._map.remove("environment");
    }

    @Nullable
    public StringArray getEnvironment(GetMode mode) {
        return this.getEnvironment();
    }

    @Nullable
    public StringArray getEnvironment() {
        if (this._environmentField != null) {
            return this._environmentField;
        }
        Object __rawValue = this._map.get("environment");
        this._environmentField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._environmentField;
    }

    public MLModelFactors setEnvironment(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEnvironment(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEnvironment();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "environment", value.data());
                this._environmentField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "environment", value.data());
                this._environmentField = value;
            }
        }
        return this;
    }

    public MLModelFactors setEnvironment(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field environment of com.linkedin.ml.metadata.MLModelFactors to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "environment", value.data());
        this._environmentField = value;
        return this;
    }

    @Override
    public MLModelFactors clone() throws CloneNotSupportedException {
        MLModelFactors __clone = (MLModelFactors)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MLModelFactors copy() throws CloneNotSupportedException {
        MLModelFactors __copy = (MLModelFactors)super.copy();
        __copy._environmentField = null;
        __copy._groupsField = null;
        __copy._instrumentationField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MLModelFactors __objectRef;

        private ChangeListener(MLModelFactors reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "environment": {
                    this.__objectRef._environmentField = null;
                    break;
                }
                case "groups": {
                    this.__objectRef._groupsField = null;
                    break;
                }
                case "instrumentation": {
                    this.__objectRef._instrumentationField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec groups() {
            return new PathSpec(this.getPathComponents(), "groups");
        }

        public PathSpec groups(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "groups");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec instrumentation() {
            return new PathSpec(this.getPathComponents(), "instrumentation");
        }

        public PathSpec instrumentation(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "instrumentation");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec environment() {
            return new PathSpec(this.getPathComponents(), "environment");
        }

        public PathSpec environment(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "environment");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withGroups() {
            this.getDataMap().put("groups", 1);
            return this;
        }

        public ProjectionMask withGroups(Integer start, Integer count) {
            this.getDataMap().put("groups", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("groups").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groups").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withInstrumentation() {
            this.getDataMap().put("instrumentation", 1);
            return this;
        }

        public ProjectionMask withInstrumentation(Integer start, Integer count) {
            this.getDataMap().put("instrumentation", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("instrumentation").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("instrumentation").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withEnvironment() {
            this.getDataMap().put("environment", 1);
            return this;
        }

        public ProjectionMask withEnvironment(Integer start, Integer count) {
            this.getDataMap().put("environment", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("environment").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("environment").put("$count", count);
            }
            return this;
        }
    }
}

