/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.ml.metadata.IntendedUserTypeArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IntendedUse
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**Intended Use for the ML Model*/@Aspect.name=\"intendedUse\"record IntendedUse{/**Primary Use cases for the MLModel.*/primaryUses:optional array[string]/**Primary Intended Users - For example, was the MLModel developed for entertainment purposes, for hobbyists, or enterprise solutions?*/primaryUsers:optional array[enum IntendedUserType{ENTERPRISE,HOBBY,ENTERTAINMENT}]/**Highlight technology that the MLModel might easily be confused with, or related contexts that users could try to apply the MLModel to.*/outOfScopeUses:optional array[string]}", SchemaFormatType.PDL);
    private StringArray _primaryUsesField = null;
    private IntendedUserTypeArray _primaryUsersField = null;
    private StringArray _outOfScopeUsesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_PrimaryUses = SCHEMA.getField("primaryUses");
    private static final RecordDataSchema.Field FIELD_PrimaryUsers = SCHEMA.getField("primaryUsers");
    private static final RecordDataSchema.Field FIELD_OutOfScopeUses = SCHEMA.getField("outOfScopeUses");

    public IntendedUse() {
        super(new DataMap(4, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public IntendedUse(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasPrimaryUses() {
        if (this._primaryUsesField != null) {
            return true;
        }
        return this._map.containsKey("primaryUses");
    }

    public void removePrimaryUses() {
        this._map.remove("primaryUses");
    }

    @Nullable
    public StringArray getPrimaryUses(GetMode mode) {
        return this.getPrimaryUses();
    }

    @Nullable
    public StringArray getPrimaryUses() {
        if (this._primaryUsesField != null) {
            return this._primaryUsesField;
        }
        Object __rawValue = this._map.get("primaryUses");
        this._primaryUsesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._primaryUsesField;
    }

    public IntendedUse setPrimaryUses(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPrimaryUses(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePrimaryUses();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "primaryUses", value.data());
                this._primaryUsesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "primaryUses", value.data());
                this._primaryUsesField = value;
            }
        }
        return this;
    }

    public IntendedUse setPrimaryUses(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field primaryUses of com.linkedin.ml.metadata.IntendedUse to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "primaryUses", value.data());
        this._primaryUsesField = value;
        return this;
    }

    public boolean hasPrimaryUsers() {
        if (this._primaryUsersField != null) {
            return true;
        }
        return this._map.containsKey("primaryUsers");
    }

    public void removePrimaryUsers() {
        this._map.remove("primaryUsers");
    }

    @Nullable
    public IntendedUserTypeArray getPrimaryUsers(GetMode mode) {
        return this.getPrimaryUsers();
    }

    @Nullable
    public IntendedUserTypeArray getPrimaryUsers() {
        if (this._primaryUsersField != null) {
            return this._primaryUsersField;
        }
        Object __rawValue = this._map.get("primaryUsers");
        this._primaryUsersField = __rawValue == null ? null : new IntendedUserTypeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._primaryUsersField;
    }

    public IntendedUse setPrimaryUsers(@Nullable IntendedUserTypeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPrimaryUsers(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePrimaryUsers();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "primaryUsers", value.data());
                this._primaryUsersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "primaryUsers", value.data());
                this._primaryUsersField = value;
            }
        }
        return this;
    }

    public IntendedUse setPrimaryUsers(@Nonnull IntendedUserTypeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field primaryUsers of com.linkedin.ml.metadata.IntendedUse to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "primaryUsers", value.data());
        this._primaryUsersField = value;
        return this;
    }

    public boolean hasOutOfScopeUses() {
        if (this._outOfScopeUsesField != null) {
            return true;
        }
        return this._map.containsKey("outOfScopeUses");
    }

    public void removeOutOfScopeUses() {
        this._map.remove("outOfScopeUses");
    }

    @Nullable
    public StringArray getOutOfScopeUses(GetMode mode) {
        return this.getOutOfScopeUses();
    }

    @Nullable
    public StringArray getOutOfScopeUses() {
        if (this._outOfScopeUsesField != null) {
            return this._outOfScopeUsesField;
        }
        Object __rawValue = this._map.get("outOfScopeUses");
        this._outOfScopeUsesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._outOfScopeUsesField;
    }

    public IntendedUse setOutOfScopeUses(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOutOfScopeUses(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOutOfScopeUses();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "outOfScopeUses", value.data());
                this._outOfScopeUsesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "outOfScopeUses", value.data());
                this._outOfScopeUsesField = value;
            }
        }
        return this;
    }

    public IntendedUse setOutOfScopeUses(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field outOfScopeUses of com.linkedin.ml.metadata.IntendedUse to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "outOfScopeUses", value.data());
        this._outOfScopeUsesField = value;
        return this;
    }

    @Override
    public IntendedUse clone() throws CloneNotSupportedException {
        IntendedUse __clone = (IntendedUse)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IntendedUse copy() throws CloneNotSupportedException {
        IntendedUse __copy = (IntendedUse)super.copy();
        __copy._primaryUsesField = null;
        __copy._outOfScopeUsesField = null;
        __copy._primaryUsersField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IntendedUse __objectRef;

        private ChangeListener(IntendedUse reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "primaryUses": {
                    this.__objectRef._primaryUsesField = null;
                    break;
                }
                case "outOfScopeUses": {
                    this.__objectRef._outOfScopeUsesField = null;
                    break;
                }
                case "primaryUsers": {
                    this.__objectRef._primaryUsersField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec primaryUses() {
            return new PathSpec(this.getPathComponents(), "primaryUses");
        }

        public PathSpec primaryUses(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "primaryUses");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec primaryUsers() {
            return new PathSpec(this.getPathComponents(), "primaryUsers");
        }

        public PathSpec primaryUsers(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "primaryUsers");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec outOfScopeUses() {
            return new PathSpec(this.getPathComponents(), "outOfScopeUses");
        }

        public PathSpec outOfScopeUses(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "outOfScopeUses");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withPrimaryUses() {
            this.getDataMap().put("primaryUses", 1);
            return this;
        }

        public ProjectionMask withPrimaryUses(Integer start, Integer count) {
            this.getDataMap().put("primaryUses", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("primaryUses").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("primaryUses").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withPrimaryUsers() {
            this.getDataMap().put("primaryUsers", 1);
            return this;
        }

        public ProjectionMask withPrimaryUsers(Integer start, Integer count) {
            this.getDataMap().put("primaryUsers", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("primaryUsers").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("primaryUsers").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOutOfScopeUses() {
            this.getDataMap().put("outOfScopeUses", 1);
            return this;
        }

        public ProjectionMask withOutOfScopeUses(Integer start, Integer count) {
            this.getDataMap().put("outOfScopeUses", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("outOfScopeUses").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("outOfScopeUses").put("$count", count);
            }
            return this;
        }
    }
}

