/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.query.FreshnessStats;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnyResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.query/**A common model for the result of any query. \nExpected to be included into other top level query results.*/record AnyResult{/**Freshness Stats to help a caller understand the freshness of the results\nUseful when the results are being retrieved from a cache, index or other eventually consistent storage*/freshness:optional/**Stats that describe the freshness of a dataset or query result.\nUseful to describe consistency and staleness of results when served\nout of a cache or other eventually consistent system.*/record FreshnessStats{cached:optional boolean,systemFreshness:optional map[string,long]}}", SchemaFormatType.PDL);
    private FreshnessStats _freshnessField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Freshness = SCHEMA.getField("freshness");

    public AnyResult() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public AnyResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasFreshness() {
        if (this._freshnessField != null) {
            return true;
        }
        return this._map.containsKey("freshness");
    }

    public void removeFreshness() {
        this._map.remove("freshness");
    }

    @Nullable
    public FreshnessStats getFreshness(GetMode mode) {
        return this.getFreshness();
    }

    @Nullable
    public FreshnessStats getFreshness() {
        if (this._freshnessField != null) {
            return this._freshnessField;
        }
        Object __rawValue = this._map.get("freshness");
        this._freshnessField = __rawValue == null ? null : new FreshnessStats(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._freshnessField;
    }

    public AnyResult setFreshness(@Nullable FreshnessStats value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFreshness(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFreshness();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "freshness", value.data());
                this._freshnessField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "freshness", value.data());
                this._freshnessField = value;
            }
        }
        return this;
    }

    public AnyResult setFreshness(@Nonnull FreshnessStats value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field freshness of com.linkedin.metadata.query.AnyResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "freshness", value.data());
        this._freshnessField = value;
        return this;
    }

    @Override
    public AnyResult clone() throws CloneNotSupportedException {
        AnyResult __clone = (AnyResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AnyResult copy() throws CloneNotSupportedException {
        AnyResult __copy = (AnyResult)super.copy();
        __copy._freshnessField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AnyResult __objectRef;

        private ChangeListener(AnyResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "freshness": {
                    this.__objectRef._freshnessField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public FreshnessStats.Fields freshness() {
            return new FreshnessStats.Fields(this.getPathComponents(), "freshness");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private FreshnessStats.ProjectionMask _freshnessMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withFreshness(Function<FreshnessStats.ProjectionMask, FreshnessStats.ProjectionMask> nestedMask) {
            this._freshnessMask = nestedMask.apply(this._freshnessMask == null ? FreshnessStats.createMask() : this._freshnessMask);
            this.getDataMap().put("freshness", this._freshnessMask.getDataMap());
            return this;
        }

        public ProjectionMask withFreshness() {
            this._freshnessMask = null;
            this.getDataMap().put("freshness", 1);
            return this;
        }
    }
}

