/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.google.common.collect.ImmutableSet;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ComplexDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitorTraversalResult;
import com.linkedin.data.schema.annotation.TraverserContext;
import com.linkedin.metadata.models.FieldSpecUtils;
import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.SearchableFieldSpec;
import com.linkedin.metadata.models.annotation.SearchableAnnotation;
import com.linkedin.metadata.models.annotation.SearchableAnnotationValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchableFieldSpecExtractor
implements SchemaVisitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchableFieldSpecExtractor.class);
    private final List<SearchableFieldSpec> _specs = new ArrayList<SearchableFieldSpec>();
    private final Map<String, String> _searchFieldNamesToPatch = new HashMap<String, String>();
    private final List<SearchableAnnotationValidator.AnnotatedField> _annotatedFields = new ArrayList<SearchableAnnotationValidator.AnnotatedField>();
    private static final String MAP = "map";
    public static final Map<String, Object> PRIMARY_URN_SEARCH_PROPERTIES = new DataMap();
    private static final float SECONDARY_URN_FACTOR = 0.1f;
    private static final Set<String> SECONDARY_URN_FIELD_TYPES;

    public List<SearchableFieldSpec> getSpecs() {
        SearchableAnnotationValidator.validateCrossAnnotationCompatibility(this._annotatedFields);
        return this._specs.stream().filter(spec -> {
            String fieldName = spec.getSearchableAnnotation().getFieldName();
            if (fieldName != null && fieldName.contains("__")) {
                log.warn("Filtering out searchable field spec with problematic field name: {}", (Object)fieldName);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    @Override
    public void callbackOnContext(TraverserContext context, DataSchemaTraverse.Order order) {
        if (context.getEnclosingField() == null) {
            return;
        }
        if (DataSchemaTraverse.Order.PRE_ORDER.equals((Object)order)) {
            DataSchema currentSchema = context.getCurrentSchema().getDereferencedDataSchema();
            Object annotationObj = this.getAnnotationObj(context);
            if (!FieldSpecUtils.isNullAnnotation(annotationObj)) {
                if (currentSchema.getDereferencedDataSchema().isComplex()) {
                    ComplexDataSchema complexSchema = (ComplexDataSchema)currentSchema;
                    if (this.isValidComplexType(complexSchema).booleanValue()) {
                        this.extractSearchableAnnotation(annotationObj, currentSchema, context);
                    }
                } else if (this.isValidPrimitiveType((PrimitiveDataSchema)currentSchema).booleanValue()) {
                    this.extractSearchableAnnotation(annotationObj, currentSchema, context);
                } else {
                    throw new ModelValidationException(String.format("Invalid @Searchable Annotation at %s", context.getSchemaPathSpec().toString()));
                }
            }
        }
    }

    private Object getAnnotationObj(TraverserContext context) {
        DataSchema currentSchema = context.getCurrentSchema().getDereferencedDataSchema();
        Map<String, Object> properties = context.getEnclosingField().getProperties();
        Object primaryAnnotationObj = properties.get("Searchable");
        if (primaryAnnotationObj != null) {
            this.validatePropertiesAnnotation(currentSchema, primaryAnnotationObj, context.getTraversePath().toString());
        }
        if (currentSchema.getDereferencedType() == DataSchema.Type.MAP) {
            MapDataSchema mapSchema = (MapDataSchema)currentSchema;
            Object maybeKeyAnnotation = mapSchema.getKey().getResolvedProperties().get("Searchable");
            Object maybeValueAnnotation = mapSchema.getValues().getResolvedProperties().get("Searchable");
            return maybeKeyAnnotation != null ? maybeKeyAnnotation : maybeValueAnnotation;
        }
        if (context.getTraversePath().contains(MAP)) {
            return null;
        }
        Map<String, Object> resolvedProperties = FieldSpecUtils.getResolvedProperties(currentSchema, Collections.emptyMap());
        boolean isUrn = ((DataMap)context.getParentSchema().getProperties().getOrDefault("java", new DataMap())).getOrDefault("class", "").equals("com.linkedin.common.urn.Urn");
        if (isUrn) {
            Object resolvedAnnotationObj = resolvedProperties.get("Searchable");
            if (FieldSpecUtils.isNullAnnotation(resolvedAnnotationObj)) {
                return null;
            }
            DataMap annotationMap = (DataMap)resolvedAnnotationObj;
            HashMap<String, Object> result = new HashMap<String, Object>(annotationMap);
            if (SECONDARY_URN_FIELD_TYPES.contains(annotationMap.getOrDefault("fieldType", "URN").toString())) {
                result.put("boostScore", Float.valueOf(Float.parseFloat(String.valueOf(annotationMap.getOrDefault("boostScore", "1.0"))) * 0.1f));
            }
            return result;
        }
        return resolvedProperties.get("Searchable");
    }

    private void extractSearchableAnnotation(Object annotationObj, DataSchema currentSchema, TraverserContext context) {
        PathSpec path = new PathSpec(context.getSchemaPathSpec());
        Optional<PathSpec> fullPath = FieldSpecUtils.getPathSpecWithAspectName(context);
        SearchableAnnotation annotation = SearchableAnnotation.fromPegasusAnnotationObject(annotationObj, FieldSpecUtils.getSchemaFieldName(path), currentSchema.getDereferencedType(), path.toString());
        String schemaPathSpec = context.getSchemaPathSpec().toString();
        if (this._searchFieldNamesToPatch.containsKey(annotation.getFieldName()) && !this._searchFieldNamesToPatch.get(annotation.getFieldName()).equals(schemaPathSpec)) {
            String pathName = path.toString().replace('/', '_').replace("*", "");
            if (pathName.startsWith("_")) {
                pathName = pathName.replaceFirst("_", "");
            }
            if (this._searchFieldNamesToPatch.containsKey(pathName) && !this._searchFieldNamesToPatch.get(pathName).equals(schemaPathSpec)) {
                throw new ModelValidationException(String.format("Entity has multiple searchable fields with the same field name %s, path: %s", annotation.getFieldName(), fullPath.orElse(path)));
            }
            annotation = new SearchableAnnotation(pathName, annotation.getFieldType(), annotation.isQueryByDefault(), annotation.isEnableAutocomplete(), annotation.isAddToFilters(), annotation.isAddHasValuesToFilters(), annotation.getFilterNameOverride(), annotation.getHasValuesFilterNameOverride(), annotation.getBoostScore(), annotation.getHasValuesFieldName(), annotation.getNumValuesFieldName(), annotation.getWeightsPerFieldValue(), annotation.getFieldNameAliases(), annotation.isIncludeQueryEmptyAggregation(), annotation.isIncludeSystemModifiedAt(), annotation.getSystemModifiedAtFieldName(), annotation.getSearchTier(), annotation.getSearchLabel(), annotation.getSearchIndexed(), annotation.getEntityFieldName(), annotation.getEagerGlobalOrdinals());
        }
        log.debug("Searchable annotation for field: {} : {}", (Object)schemaPathSpec, (Object)annotation);
        SearchableFieldSpec fieldSpec = new SearchableFieldSpec(path, annotation, currentSchema);
        this._specs.add(fieldSpec);
        this._searchFieldNamesToPatch.put(annotation.getFieldName(), context.getSchemaPathSpec().toString());
        this._annotatedFields.add(new SearchableAnnotationValidator.AnnotatedField(annotation, currentSchema.getDereferencedType(), path.toString()));
    }

    @Override
    public SchemaVisitor.VisitorContext getInitialVisitorContext() {
        return null;
    }

    @Override
    public SchemaVisitorTraversalResult getSchemaVisitorTraversalResult() {
        return new SchemaVisitorTraversalResult();
    }

    private Boolean isValidComplexType(ComplexDataSchema schema) {
        return DataSchema.Type.ENUM.equals((Object)schema.getDereferencedDataSchema().getDereferencedType()) || DataSchema.Type.MAP.equals((Object)schema.getDereferencedDataSchema().getDereferencedType());
    }

    private Boolean isValidPrimitiveType(PrimitiveDataSchema schema) {
        return true;
    }

    private void validatePropertiesAnnotation(DataSchema currentSchema, Object annotationObj, String pathStr) {
        if (currentSchema.isPrimitive() || currentSchema.getDereferencedType().equals((Object)DataSchema.Type.ENUM) || currentSchema.getDereferencedType().equals((Object)DataSchema.Type.MAP)) {
            return;
        }
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared inside %s: Invalid value type provided (Expected Map)", "Searchable", pathStr));
        }
        Map annotationMap = (Map)annotationObj;
        if (annotationMap.size() == 0) {
            throw new ModelValidationException(String.format("Invalid @Searchable Annotation at %s. Annotation placed on invalid field of type %s. Must be placed on primitive field.", new Object[]{pathStr, currentSchema.getType()}));
        }
        for (String key : annotationMap.keySet()) {
            if (key.startsWith(Character.toString('/'))) continue;
            throw new ModelValidationException(String.format("Invalid @Searchable Annotation at %s. Annotation placed on invalid field of type %s. Must be placed on primitive field.", new Object[]{pathStr, currentSchema.getType()}));
        }
    }

    static {
        PRIMARY_URN_SEARCH_PROPERTIES.put("enableAutocomplete", "true");
        PRIMARY_URN_SEARCH_PROPERTIES.put("fieldType", "URN");
        PRIMARY_URN_SEARCH_PROPERTIES.put("boostScore", "10.0");
        SECONDARY_URN_FIELD_TYPES = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("URN")).add("URN_PARTIAL")).build();
    }
}

