/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.SearchableFieldSpec;
import com.linkedin.metadata.models.annotation.EntityAnnotation;
import com.linkedin.metadata.models.annotation.SearchableAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;

public class ConfigEntitySpec
implements EntitySpec {
    private final EntityAnnotation _entityAnnotation;
    private final Map<String, AspectSpec> _aspectSpecs;
    private List<SearchableFieldSpec> _searchableFieldSpecs;
    private Map<String, Set<SearchableAnnotation.FieldType>> searchableFieldTypeMap;
    private Map<PathSpec, String> searchableFieldPathMap;
    private Map<String, List<PathSpec>> fieldPathToSearchableFieldMap;

    public ConfigEntitySpec(@Nonnull String entityName, @Nonnull String keyAspect, @Nonnull Collection<AspectSpec> aspectSpecs, @Nonnull String searchGroup) {
        this._aspectSpecs = aspectSpecs.stream().collect(Collectors.toMap(AspectSpec::getName, Function.identity()));
        this._entityAnnotation = new EntityAnnotation(entityName, keyAspect, searchGroup);
    }

    @Override
    public String getName() {
        return this._entityAnnotation.getName();
    }

    @Override
    public EntityAnnotation getEntityAnnotation() {
        return this._entityAnnotation;
    }

    @Override
    public String getKeyAspectName() {
        return this._entityAnnotation.getKeyAspect();
    }

    @Override
    public AspectSpec getKeyAspectSpec() {
        return this._aspectSpecs.get(this._entityAnnotation.getKeyAspect());
    }

    @Override
    public List<AspectSpec> getAspectSpecs() {
        return new ArrayList<AspectSpec>(this._aspectSpecs.values());
    }

    @Override
    public Map<String, AspectSpec> getAspectSpecMap() {
        return this._aspectSpecs;
    }

    @Override
    public Boolean hasAspect(String name) {
        return this._aspectSpecs.containsKey(name);
    }

    @Override
    public AspectSpec getAspectSpec(String name) {
        return this._aspectSpecs.get(name);
    }

    @Override
    public RecordDataSchema getSnapshotSchema() {
        throw new UnsupportedOperationException("Failed to find Snapshot associated with Config-based Entity");
    }

    @Override
    public TyperefDataSchema getAspectTyperefSchema() {
        throw new UnsupportedOperationException("Failed to find Typeref schema associated with Config-based Entity");
    }

    @Override
    public List<SearchableFieldSpec> getSearchableFieldSpecs() {
        if (this._searchableFieldSpecs == null) {
            this._searchableFieldSpecs = EntitySpec.super.getSearchableFieldSpecs();
        }
        return this._searchableFieldSpecs;
    }

    @Override
    public Map<String, Set<SearchableAnnotation.FieldType>> getSearchableFieldTypes() {
        if (this.searchableFieldTypeMap == null) {
            this.searchableFieldTypeMap = EntitySpec.super.getSearchableFieldTypes();
        }
        return this.searchableFieldTypeMap;
    }

    @Override
    public Map<PathSpec, String> getSearchableFieldPathMap() {
        if (this.searchableFieldPathMap == null) {
            this.searchableFieldPathMap = EntitySpec.super.getSearchableFieldPathMap();
        }
        return this.searchableFieldPathMap;
    }

    @Override
    public Map<String, List<PathSpec>> getSearchableFieldsToPathSpecsMap() {
        if (this.fieldPathToSearchableFieldMap == null) {
            this.fieldPathToSearchableFieldMap = EntitySpec.super.getSearchableFieldsToPathSpecsMap();
        }
        return this.fieldPathToSearchableFieldMap;
    }

    @Override
    public String getSearchGroup() {
        return this._entityAnnotation.getSearchGroup();
    }

    @Generated
    public String toString() {
        return "ConfigEntitySpec(_entityAnnotation=" + String.valueOf(this._entityAnnotation) + ", _aspectSpecs=" + String.valueOf(this._aspectSpecs) + ", _searchableFieldSpecs=" + String.valueOf(this._searchableFieldSpecs) + ", searchableFieldTypeMap=" + String.valueOf(this.searchableFieldTypeMap) + ", searchableFieldPathMap=" + String.valueOf(this.getSearchableFieldPathMap()) + ", fieldPathToSearchableFieldMap=" + String.valueOf(this.fieldPathToSearchableFieldMap) + ")";
    }
}

