/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.entity;

import com.linkedin.metadata.entity.SearchRetriever;
import com.linkedin.metadata.query.filter.Filter;
import com.linkedin.metadata.search.ScrollResult;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class GenericScrollIterator
implements Iterator<ScrollResult> {
    @Nonnull
    private final Filter filter;
    @Nonnull
    private final List<String> entities;
    @Nonnull
    private final SearchRetriever searchRetriever;
    @Nullable
    private Integer count;
    private String scrollId;
    private boolean started;

    @Override
    public boolean hasNext() {
        return !this.started || this.scrollId != null;
    }

    @Override
    public ScrollResult next() {
        this.started = true;
        ScrollResult result = this.searchRetriever.scroll(this.entities, this.filter, this.scrollId, this.count);
        this.scrollId = result.getScrollId();
        return result;
    }

    @Generated
    private static String $default$scrollId() {
        return null;
    }

    @Generated
    private static boolean $default$started() {
        return false;
    }

    @Generated
    GenericScrollIterator(@Nonnull Filter filter, @Nonnull List<String> entities, @Nonnull SearchRetriever searchRetriever, @Nullable Integer count, String scrollId, boolean started) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        if (searchRetriever == null) {
            throw new NullPointerException("searchRetriever is marked non-null but is null");
        }
        this.filter = filter;
        this.entities = entities;
        this.searchRetriever = searchRetriever;
        this.count = count;
        this.scrollId = scrollId;
        this.started = started;
    }

    @Generated
    public static GenericScrollIteratorBuilder builder() {
        return new GenericScrollIteratorBuilder();
    }

    @Generated
    public static class GenericScrollIteratorBuilder {
        @Generated
        private Filter filter;
        @Generated
        private List<String> entities;
        @Generated
        private SearchRetriever searchRetriever;
        @Generated
        private Integer count;
        @Generated
        private boolean scrollId$set;
        @Generated
        private String scrollId$value;
        @Generated
        private boolean started$set;
        @Generated
        private boolean started$value;

        @Generated
        GenericScrollIteratorBuilder() {
        }

        @Generated
        public GenericScrollIteratorBuilder filter(@Nonnull Filter filter) {
            if (filter == null) {
                throw new NullPointerException("filter is marked non-null but is null");
            }
            this.filter = filter;
            return this;
        }

        @Generated
        public GenericScrollIteratorBuilder entities(@Nonnull List<String> entities) {
            if (entities == null) {
                throw new NullPointerException("entities is marked non-null but is null");
            }
            this.entities = entities;
            return this;
        }

        @Generated
        public GenericScrollIteratorBuilder searchRetriever(@Nonnull SearchRetriever searchRetriever) {
            if (searchRetriever == null) {
                throw new NullPointerException("searchRetriever is marked non-null but is null");
            }
            this.searchRetriever = searchRetriever;
            return this;
        }

        @Generated
        public GenericScrollIteratorBuilder count(@Nullable Integer count) {
            this.count = count;
            return this;
        }

        @Generated
        public GenericScrollIteratorBuilder scrollId(String scrollId) {
            this.scrollId$value = scrollId;
            this.scrollId$set = true;
            return this;
        }

        @Generated
        public GenericScrollIteratorBuilder started(boolean started) {
            this.started$value = started;
            this.started$set = true;
            return this;
        }

        @Generated
        public GenericScrollIterator build() {
            String scrollId$value = this.scrollId$value;
            if (!this.scrollId$set) {
                scrollId$value = GenericScrollIterator.$default$scrollId();
            }
            boolean started$value = this.started$value;
            if (!this.started$set) {
                started$value = GenericScrollIterator.$default$started();
            }
            return new GenericScrollIterator(this.filter, this.entities, this.searchRetriever, this.count, scrollId$value, started$value);
        }

        @Generated
        public String toString() {
            return "GenericScrollIterator.GenericScrollIteratorBuilder(filter=" + String.valueOf(this.filter) + ", entities=" + String.valueOf(this.entities) + ", searchRetriever=" + String.valueOf(this.searchRetriever) + ", count=" + this.count + ", scrollId$value=" + this.scrollId$value + ", started$value=" + this.started$value + ")";
        }
    }
}

