/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.template.dataset;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.dataset.FineGrainedLineageArray;
import com.linkedin.dataset.UpstreamArray;
import com.linkedin.dataset.UpstreamLineage;
import com.linkedin.metadata.aspect.patch.template.CompoundKeyTemplate;
import com.linkedin.metadata.aspect.patch.template.FineGrainedLineageTemplateHelper;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.node.ObjectNode;
import java.util.Collections;
import javax.annotation.Nonnull;

public class UpstreamLineageTemplate
extends CompoundKeyTemplate<UpstreamLineage> {
    private static final String UPSTREAMS_FIELD_NAME = "upstreams";
    private static final String DATASET_FIELD_NAME = "dataset";
    private static final String FINE_GRAINED_LINEAGES_FIELD_NAME = "fineGrainedLineages";

    @Override
    public UpstreamLineage getSubtype(RecordTemplate recordTemplate) throws ClassCastException {
        if (recordTemplate instanceof UpstreamLineage) {
            return (UpstreamLineage)recordTemplate;
        }
        throw new ClassCastException("Unable to cast RecordTemplate to UpstreamLineage");
    }

    @Override
    public Class<UpstreamLineage> getTemplateType() {
        return UpstreamLineage.class;
    }

    @Override
    @Nonnull
    public UpstreamLineage getDefault() {
        UpstreamLineage upstreamLineage = new UpstreamLineage();
        upstreamLineage.setUpstreams(new UpstreamArray());
        upstreamLineage.setFineGrainedLineages(new FineGrainedLineageArray());
        return upstreamLineage;
    }

    @Override
    @Nonnull
    public JsonNode transformFields(JsonNode baseNode) {
        JsonNode transformedNode = this.arrayFieldToMap(baseNode, UPSTREAMS_FIELD_NAME, Collections.singletonList(DATASET_FIELD_NAME));
        ((ObjectNode)transformedNode).set(FINE_GRAINED_LINEAGES_FIELD_NAME, FineGrainedLineageTemplateHelper.combineAndTransformFineGrainedLineages(transformedNode.get(FINE_GRAINED_LINEAGES_FIELD_NAME)));
        return transformedNode;
    }

    @Override
    @Nonnull
    public JsonNode rebaseFields(JsonNode patched) {
        JsonNode rebasedNode = this.transformedMapToArray(patched, UPSTREAMS_FIELD_NAME, Collections.singletonList(DATASET_FIELD_NAME));
        ((ObjectNode)rebasedNode).set(FINE_GRAINED_LINEAGES_FIELD_NAME, FineGrainedLineageTemplateHelper.reconstructFineGrainedLineages(rebasedNode.get(FINE_GRAINED_LINEAGES_FIELD_NAME)));
        return rebasedNode;
    }
}

