/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.template.common;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.aspect.patch.template.ArrayMergingTemplate;
import com.linkedin.structured.StructuredProperties;
import com.linkedin.structured.StructuredPropertyValueAssignmentArray;
import datahub.shaded.jackson.databind.JsonNode;
import java.util.Collections;
import javax.annotation.Nonnull;

public class StructuredPropertiesTemplate
implements ArrayMergingTemplate<StructuredProperties> {
    private static final String PROPERTIES_FIELD_NAME = "properties";
    private static final String URN_FIELD_NAME = "propertyUrn";

    @Override
    public StructuredProperties getSubtype(RecordTemplate recordTemplate) throws ClassCastException {
        if (recordTemplate instanceof StructuredProperties) {
            return (StructuredProperties)recordTemplate;
        }
        throw new ClassCastException("Unable to cast RecordTemplate to StructuredProperties");
    }

    @Override
    public Class<StructuredProperties> getTemplateType() {
        return StructuredProperties.class;
    }

    @Override
    @Nonnull
    public StructuredProperties getDefault() {
        StructuredProperties structuredProperties = new StructuredProperties();
        structuredProperties.setProperties(new StructuredPropertyValueAssignmentArray());
        return structuredProperties;
    }

    @Override
    @Nonnull
    public JsonNode transformFields(JsonNode baseNode) {
        return this.arrayFieldToMap(baseNode, PROPERTIES_FIELD_NAME, Collections.singletonList(URN_FIELD_NAME));
    }

    @Override
    @Nonnull
    public JsonNode rebaseFields(JsonNode patched) {
        return this.transformedMapToArray(patched, PROPERTIES_FIELD_NAME, Collections.singletonList(URN_FIELD_NAME));
    }
}

