/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.knowledge;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.knowledge.RelatedAsset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class RelatedAssetArray
extends WrappingArrayTemplate<RelatedAsset> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.knowledge/**A data asset referenced by a document.*/record RelatedAsset{/**The asset referenced by or related to the document. */@Relationship={\"entityTypes\":[\"container\",\"dataset\",\"dataJob\",\"dataFlow\",\"dashboard\",\"chart\",\"application\",\"dataPlatform\",\"mlModel\",\"mlModelGroup\",\"mlPrimaryKey\",\"mlFeatureTable\",\"corpuser\",\"corpGroup\",\"dataProduct\",\"domain\",\"glossaryTerm\",\"glossaryNode\",\"tag\",\"structuredProperty\"],\"name\":\"RelatedAsset\"}@Searchable.fieldName=\"relatedAssets\"asset:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}}]", SchemaFormatType.PDL);

    public RelatedAssetArray() {
        this(new DataList());
    }

    public RelatedAssetArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public RelatedAssetArray(Collection<RelatedAsset> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public RelatedAssetArray(DataList data) {
        super(data, SCHEMA, RelatedAsset.class);
    }

    public RelatedAssetArray(RelatedAsset first, RelatedAsset ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public RelatedAssetArray clone() throws CloneNotSupportedException {
        RelatedAssetArray __clone = (RelatedAssetArray)super.clone();
        return __clone;
    }

    @Override
    public RelatedAssetArray copy() throws CloneNotSupportedException {
        RelatedAssetArray __copy = (RelatedAssetArray)super.copy();
        return __copy;
    }

    @Override
    protected RelatedAsset coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new RelatedAsset(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private RelatedAsset.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<RelatedAsset.ProjectionMask, RelatedAsset.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? RelatedAsset.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public RelatedAsset.Fields items() {
            return new RelatedAsset.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

