/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.knowledge;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.knowledge.DocumentSourceType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentSource
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.knowledge/**Information about the source of a document, especially for externally sourced documents.\nThis record is embedded within DocumentInfo to track whether a document is first-party \n(created in DataHub) or third-party (ingested from external sources like Slack, Notion, etc.)*/record DocumentSource{/**The type of the source (e.g., \"Confluence\", \"Notion\", \"Google Docs\", \"SharePoint\", \"Slack\")*/@Searchable.queryByDefault=false,sourceType:enum DocumentSourceType{/**Created via the DataHub UI or API*/NATIVE/**External - The document was ingested from an external source. */EXTERNAL}/**URL to the external source where this document originated*/@Searchable.queryByDefault=false,externalUrl:optional string/**Unique identifier in the external system. Searchable in case we need to find ingested docs via filtering.*/@Searchable.queryByDefault=false,externalId:optional string}", SchemaFormatType.PDL);
    private DocumentSourceType _sourceTypeField = null;
    private String _externalUrlField = null;
    private String _externalIdField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_SourceType = SCHEMA.getField("sourceType");
    private static final RecordDataSchema.Field FIELD_ExternalUrl = SCHEMA.getField("externalUrl");
    private static final RecordDataSchema.Field FIELD_ExternalId = SCHEMA.getField("externalId");

    public DocumentSource() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DocumentSource(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSourceType() {
        if (this._sourceTypeField != null) {
            return true;
        }
        return this._map.containsKey("sourceType");
    }

    public void removeSourceType() {
        this._map.remove("sourceType");
    }

    @Nullable
    public DocumentSourceType getSourceType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSourceType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._sourceTypeField != null) {
                    return this._sourceTypeField;
                }
                Object __rawValue = this._map.get("sourceType");
                this._sourceTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, DocumentSourceType.class, DocumentSourceType.$UNKNOWN);
                return this._sourceTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DocumentSourceType getSourceType() {
        if (this._sourceTypeField != null) {
            return this._sourceTypeField;
        }
        Object __rawValue = this._map.get("sourceType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("sourceType");
        }
        this._sourceTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, DocumentSourceType.class, DocumentSourceType.$UNKNOWN);
        return this._sourceTypeField;
    }

    public DocumentSource setSourceType(@Nullable DocumentSourceType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSourceType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field sourceType of com.linkedin.knowledge.DocumentSource");
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceType", value.name());
                this._sourceTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSourceType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceType", value.name());
                this._sourceTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sourceType", value.name());
                this._sourceTypeField = value;
            }
        }
        return this;
    }

    public DocumentSource setSourceType(@Nonnull DocumentSourceType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sourceType of com.linkedin.knowledge.DocumentSource to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sourceType", value.name());
        this._sourceTypeField = value;
        return this;
    }

    public boolean hasExternalUrl() {
        if (this._externalUrlField != null) {
            return true;
        }
        return this._map.containsKey("externalUrl");
    }

    public void removeExternalUrl() {
        this._map.remove("externalUrl");
    }

    @Nullable
    public String getExternalUrl(GetMode mode) {
        return this.getExternalUrl();
    }

    @Nullable
    public String getExternalUrl() {
        if (this._externalUrlField != null) {
            return this._externalUrlField;
        }
        Object __rawValue = this._map.get("externalUrl");
        this._externalUrlField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._externalUrlField;
    }

    public DocumentSource setExternalUrl(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", value);
                this._externalUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", value);
                this._externalUrlField = value;
            }
        }
        return this;
    }

    public DocumentSource setExternalUrl(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalUrl of com.linkedin.knowledge.DocumentSource to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalUrl", value);
        this._externalUrlField = value;
        return this;
    }

    public boolean hasExternalId() {
        if (this._externalIdField != null) {
            return true;
        }
        return this._map.containsKey("externalId");
    }

    public void removeExternalId() {
        this._map.remove("externalId");
    }

    @Nullable
    public String getExternalId(GetMode mode) {
        return this.getExternalId();
    }

    @Nullable
    public String getExternalId() {
        if (this._externalIdField != null) {
            return this._externalIdField;
        }
        Object __rawValue = this._map.get("externalId");
        this._externalIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._externalIdField;
    }

    public DocumentSource setExternalId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalId", value);
                this._externalIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalId", value);
                this._externalIdField = value;
            }
        }
        return this;
    }

    public DocumentSource setExternalId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalId of com.linkedin.knowledge.DocumentSource to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalId", value);
        this._externalIdField = value;
        return this;
    }

    @Override
    public DocumentSource clone() throws CloneNotSupportedException {
        DocumentSource __clone = (DocumentSource)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DocumentSource copy() throws CloneNotSupportedException {
        DocumentSource __copy = (DocumentSource)super.copy();
        __copy._externalUrlField = null;
        __copy._sourceTypeField = null;
        __copy._externalIdField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DocumentSource __objectRef;

        private ChangeListener(DocumentSource reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "externalUrl": {
                    this.__objectRef._externalUrlField = null;
                    break;
                }
                case "sourceType": {
                    this.__objectRef._sourceTypeField = null;
                    break;
                }
                case "externalId": {
                    this.__objectRef._externalIdField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec sourceType() {
            return new PathSpec(this.getPathComponents(), "sourceType");
        }

        public PathSpec externalUrl() {
            return new PathSpec(this.getPathComponents(), "externalUrl");
        }

        public PathSpec externalId() {
            return new PathSpec(this.getPathComponents(), "externalId");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withSourceType() {
            this.getDataMap().put("sourceType", 1);
            return this;
        }

        public ProjectionMask withExternalUrl() {
            this.getDataMap().put("externalUrl", 1);
            return this;
        }

        public ProjectionMask withExternalId() {
            this.getDataMap().put("externalId", 1);
            return this;
        }
    }
}

