/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ingestion;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubIngestionSourceConfig
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ingestion,record DataHubIngestionSourceConfig{/**The JSON recipe to use for ingestion*/recipe:string/**The PyPI version of the datahub CLI to use when executing a recipe*/version:optional string/**The id of the executor to use to execute the ingestion run*/@Searchable={\"fieldName\":\"sourceExecutorId\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false}executorId:optional string/**Whether or not to run this ingestion source in debug mode*/debugMode:optional boolean/**Extra arguments for the ingestion run.*/extraArgs:optional map[string,string]}", SchemaFormatType.PDL);
    private String _recipeField = null;
    private String _versionField = null;
    private String _executorIdField = null;
    private Boolean _debugModeField = null;
    private StringMap _extraArgsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Recipe = SCHEMA.getField("recipe");
    private static final RecordDataSchema.Field FIELD_Version = SCHEMA.getField("version");
    private static final RecordDataSchema.Field FIELD_ExecutorId = SCHEMA.getField("executorId");
    private static final RecordDataSchema.Field FIELD_DebugMode = SCHEMA.getField("debugMode");
    private static final RecordDataSchema.Field FIELD_ExtraArgs = SCHEMA.getField("extraArgs");

    public DataHubIngestionSourceConfig() {
        super(new DataMap(7, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubIngestionSourceConfig(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasRecipe() {
        if (this._recipeField != null) {
            return true;
        }
        return this._map.containsKey("recipe");
    }

    public void removeRecipe() {
        this._map.remove("recipe");
    }

    @Nullable
    public String getRecipe(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRecipe();
            }
            case DEFAULT: 
            case NULL: {
                if (this._recipeField != null) {
                    return this._recipeField;
                }
                Object __rawValue = this._map.get("recipe");
                this._recipeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._recipeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getRecipe() {
        if (this._recipeField != null) {
            return this._recipeField;
        }
        Object __rawValue = this._map.get("recipe");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("recipe");
        }
        this._recipeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._recipeField;
    }

    public DataHubIngestionSourceConfig setRecipe(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRecipe(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field recipe of com.linkedin.ingestion.DataHubIngestionSourceConfig");
                }
                CheckedUtil.putWithoutChecking(this._map, "recipe", value);
                this._recipeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRecipe();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "recipe", value);
                this._recipeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "recipe", value);
                this._recipeField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceConfig setRecipe(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field recipe of com.linkedin.ingestion.DataHubIngestionSourceConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "recipe", value);
        this._recipeField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public String getVersion(GetMode mode) {
        return this.getVersion();
    }

    @Nullable
    public String getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        this._versionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._versionField;
    }

    public DataHubIngestionSourceConfig setVersion(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value);
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", value);
                this._versionField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceConfig setVersion(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.ingestion.DataHubIngestionSourceConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", value);
        this._versionField = value;
        return this;
    }

    public boolean hasExecutorId() {
        if (this._executorIdField != null) {
            return true;
        }
        return this._map.containsKey("executorId");
    }

    public void removeExecutorId() {
        this._map.remove("executorId");
    }

    @Nullable
    public String getExecutorId(GetMode mode) {
        return this.getExecutorId();
    }

    @Nullable
    public String getExecutorId() {
        if (this._executorIdField != null) {
            return this._executorIdField;
        }
        Object __rawValue = this._map.get("executorId");
        this._executorIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._executorIdField;
    }

    public DataHubIngestionSourceConfig setExecutorId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExecutorId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExecutorId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "executorId", value);
                this._executorIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "executorId", value);
                this._executorIdField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceConfig setExecutorId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field executorId of com.linkedin.ingestion.DataHubIngestionSourceConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "executorId", value);
        this._executorIdField = value;
        return this;
    }

    public boolean hasDebugMode() {
        if (this._debugModeField != null) {
            return true;
        }
        return this._map.containsKey("debugMode");
    }

    public void removeDebugMode() {
        this._map.remove("debugMode");
    }

    @Nullable
    public Boolean isDebugMode(GetMode mode) {
        return this.isDebugMode();
    }

    @Nullable
    public Boolean isDebugMode() {
        if (this._debugModeField != null) {
            return this._debugModeField;
        }
        Object __rawValue = this._map.get("debugMode");
        this._debugModeField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._debugModeField;
    }

    public DataHubIngestionSourceConfig setDebugMode(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDebugMode(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDebugMode();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "debugMode", value);
                this._debugModeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "debugMode", value);
                this._debugModeField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceConfig setDebugMode(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field debugMode of com.linkedin.ingestion.DataHubIngestionSourceConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "debugMode", value);
        this._debugModeField = value;
        return this;
    }

    public DataHubIngestionSourceConfig setDebugMode(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "debugMode", value);
        this._debugModeField = value;
        return this;
    }

    public boolean hasExtraArgs() {
        if (this._extraArgsField != null) {
            return true;
        }
        return this._map.containsKey("extraArgs");
    }

    public void removeExtraArgs() {
        this._map.remove("extraArgs");
    }

    @Nullable
    public StringMap getExtraArgs(GetMode mode) {
        return this.getExtraArgs();
    }

    @Nullable
    public StringMap getExtraArgs() {
        if (this._extraArgsField != null) {
            return this._extraArgsField;
        }
        Object __rawValue = this._map.get("extraArgs");
        this._extraArgsField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._extraArgsField;
    }

    public DataHubIngestionSourceConfig setExtraArgs(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExtraArgs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExtraArgs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "extraArgs", value.data());
                this._extraArgsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "extraArgs", value.data());
                this._extraArgsField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceConfig setExtraArgs(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field extraArgs of com.linkedin.ingestion.DataHubIngestionSourceConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "extraArgs", value.data());
        this._extraArgsField = value;
        return this;
    }

    @Override
    public DataHubIngestionSourceConfig clone() throws CloneNotSupportedException {
        DataHubIngestionSourceConfig __clone = (DataHubIngestionSourceConfig)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubIngestionSourceConfig copy() throws CloneNotSupportedException {
        DataHubIngestionSourceConfig __copy = (DataHubIngestionSourceConfig)super.copy();
        __copy._extraArgsField = null;
        __copy._executorIdField = null;
        __copy._recipeField = null;
        __copy._versionField = null;
        __copy._debugModeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubIngestionSourceConfig __objectRef;

        private ChangeListener(DataHubIngestionSourceConfig reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "extraArgs": {
                    this.__objectRef._extraArgsField = null;
                    break;
                }
                case "executorId": {
                    this.__objectRef._executorIdField = null;
                    break;
                }
                case "recipe": {
                    this.__objectRef._recipeField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                    break;
                }
                case "debugMode": {
                    this.__objectRef._debugModeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec recipe() {
            return new PathSpec(this.getPathComponents(), "recipe");
        }

        public PathSpec version() {
            return new PathSpec(this.getPathComponents(), "version");
        }

        public PathSpec executorId() {
            return new PathSpec(this.getPathComponents(), "executorId");
        }

        public PathSpec debugMode() {
            return new PathSpec(this.getPathComponents(), "debugMode");
        }

        public PathSpec extraArgs() {
            return new PathSpec(this.getPathComponents(), "extraArgs");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withRecipe() {
            this.getDataMap().put("recipe", 1);
            return this;
        }

        public ProjectionMask withVersion() {
            this.getDataMap().put("version", 1);
            return this;
        }

        public ProjectionMask withExecutorId() {
            this.getDataMap().put("executorId", 1);
            return this;
        }

        public ProjectionMask withDebugMode() {
            this.getDataMap().put("debugMode", 1);
            return this;
        }

        public ProjectionMask withExtraArgs() {
            this.getDataMap().put("extraArgs", 1);
            return this;
        }
    }
}

