/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.file;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.file.BucketStorageLocation;
import com.linkedin.file.FileUploadScenario;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubFileInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.file/**Information about a DataHub file - a file stored in S3 for use within DataHub platform features like documentation, home pages, and announcements.*/@Aspect.name=\"dataHubFileInfo\"record DataHubFileInfo{/**Info about where a file is stored*/bucketStorageLocation:/**Information where a file is stored*/record BucketStorageLocation{/**The storage bucket this file is stored in*/@Searchable.fieldType=\"KEYWORD\"storageBucket:string/**The key for where this file is stored inside of the given bucket*/@Searchable.fieldType=\"KEYWORD\"storageKey:string}/**The original filename as uploaded by the user*/@Searchable.fieldType=\"TEXT_PARTIAL\"originalFileName:string/**MIME type of the file (e.g., image/png, application/pdf)*/@Searchable.fieldType=\"KEYWORD\"mimeType:string/**Size of the file in bytes*/sizeInBytes:long/**The scenario/context in which this file was uploaded*/@Searchable.fieldType=\"KEYWORD\"scenario:enum FileUploadScenario{/**File uploaded for entity documentation*/ASSET_DOCUMENTATION}/**Optional URN of the entity this file is associated with (e.g., the dataset whose docs contain this file)*/@Relationship={\"entityTypes\":[\"dataset\",\"chart\",\"container\",\"dashboard\",\"dataFlow\",\"dataJob\",\"glossaryTerm\",\"glossaryNode\",\"mlModel\",\"mlFeature\",\"notebook\",\"mlFeatureTable\",\"mlPrimaryKey\",\"mlModelGroup\",\"domain\",\"dataProduct\",\"businessAttribute\"],\"name\":\"ReferencedBy\"}@Searchable.fieldType=\"URN\"referencedByAsset:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The dataset schema field urn this file is referenced by*/@Relationship={\"entityTypes\":[\"schemaField\"],\"name\":\"ReferencedBy\"}@Searchable.fieldType=\"URN\"schemaField:optional com.linkedin.common.Urn/**Timestamp when this file was created and by whom*/@Searchable={\"/actor\":{\"fieldName\":\"createdBy\",\"fieldType\":\"URN\"},\"/time\":{\"fieldName\":\"createdAt\",\"fieldType\":\"DATETIME\"}}created:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**SHA-256 hash of file contents*/@Searchable.fieldType=\"KEYWORD\"contentHash:optional string}", SchemaFormatType.PDL);
    private BucketStorageLocation _bucketStorageLocationField = null;
    private String _originalFileNameField = null;
    private String _mimeTypeField = null;
    private Long _sizeInBytesField = null;
    private FileUploadScenario _scenarioField = null;
    private Urn _referencedByAssetField = null;
    private Urn _schemaFieldField = null;
    private AuditStamp _createdField = null;
    private String _contentHashField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_BucketStorageLocation = SCHEMA.getField("bucketStorageLocation");
    private static final RecordDataSchema.Field FIELD_OriginalFileName = SCHEMA.getField("originalFileName");
    private static final RecordDataSchema.Field FIELD_MimeType = SCHEMA.getField("mimeType");
    private static final RecordDataSchema.Field FIELD_SizeInBytes = SCHEMA.getField("sizeInBytes");
    private static final RecordDataSchema.Field FIELD_Scenario = SCHEMA.getField("scenario");
    private static final RecordDataSchema.Field FIELD_ReferencedByAsset = SCHEMA.getField("referencedByAsset");
    private static final RecordDataSchema.Field FIELD_SchemaField = SCHEMA.getField("schemaField");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final RecordDataSchema.Field FIELD_ContentHash = SCHEMA.getField("contentHash");

    public DataHubFileInfo() {
        super(new DataMap(12, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubFileInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasBucketStorageLocation() {
        if (this._bucketStorageLocationField != null) {
            return true;
        }
        return this._map.containsKey("bucketStorageLocation");
    }

    public void removeBucketStorageLocation() {
        this._map.remove("bucketStorageLocation");
    }

    @Nullable
    public BucketStorageLocation getBucketStorageLocation(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getBucketStorageLocation();
            }
            case DEFAULT: 
            case NULL: {
                if (this._bucketStorageLocationField != null) {
                    return this._bucketStorageLocationField;
                }
                Object __rawValue = this._map.get("bucketStorageLocation");
                this._bucketStorageLocationField = __rawValue == null ? null : new BucketStorageLocation(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._bucketStorageLocationField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public BucketStorageLocation getBucketStorageLocation() {
        if (this._bucketStorageLocationField != null) {
            return this._bucketStorageLocationField;
        }
        Object __rawValue = this._map.get("bucketStorageLocation");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("bucketStorageLocation");
        }
        this._bucketStorageLocationField = __rawValue == null ? null : new BucketStorageLocation(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._bucketStorageLocationField;
    }

    public DataHubFileInfo setBucketStorageLocation(@Nullable BucketStorageLocation value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setBucketStorageLocation(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field bucketStorageLocation of com.linkedin.file.DataHubFileInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "bucketStorageLocation", value.data());
                this._bucketStorageLocationField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeBucketStorageLocation();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "bucketStorageLocation", value.data());
                this._bucketStorageLocationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "bucketStorageLocation", value.data());
                this._bucketStorageLocationField = value;
            }
        }
        return this;
    }

    public DataHubFileInfo setBucketStorageLocation(@Nonnull BucketStorageLocation value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field bucketStorageLocation of com.linkedin.file.DataHubFileInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "bucketStorageLocation", value.data());
        this._bucketStorageLocationField = value;
        return this;
    }

    public boolean hasOriginalFileName() {
        if (this._originalFileNameField != null) {
            return true;
        }
        return this._map.containsKey("originalFileName");
    }

    public void removeOriginalFileName() {
        this._map.remove("originalFileName");
    }

    @Nullable
    public String getOriginalFileName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOriginalFileName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._originalFileNameField != null) {
                    return this._originalFileNameField;
                }
                Object __rawValue = this._map.get("originalFileName");
                this._originalFileNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._originalFileNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getOriginalFileName() {
        if (this._originalFileNameField != null) {
            return this._originalFileNameField;
        }
        Object __rawValue = this._map.get("originalFileName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("originalFileName");
        }
        this._originalFileNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._originalFileNameField;
    }

    public DataHubFileInfo setOriginalFileName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOriginalFileName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field originalFileName of com.linkedin.file.DataHubFileInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "originalFileName", value);
                this._originalFileNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOriginalFileName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "originalFileName", value);
                this._originalFileNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "originalFileName", value);
                this._originalFileNameField = value;
            }
        }
        return this;
    }

    public DataHubFileInfo setOriginalFileName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field originalFileName of com.linkedin.file.DataHubFileInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "originalFileName", value);
        this._originalFileNameField = value;
        return this;
    }

    public boolean hasMimeType() {
        if (this._mimeTypeField != null) {
            return true;
        }
        return this._map.containsKey("mimeType");
    }

    public void removeMimeType() {
        this._map.remove("mimeType");
    }

    @Nullable
    public String getMimeType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getMimeType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._mimeTypeField != null) {
                    return this._mimeTypeField;
                }
                Object __rawValue = this._map.get("mimeType");
                this._mimeTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._mimeTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getMimeType() {
        if (this._mimeTypeField != null) {
            return this._mimeTypeField;
        }
        Object __rawValue = this._map.get("mimeType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("mimeType");
        }
        this._mimeTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._mimeTypeField;
    }

    public DataHubFileInfo setMimeType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMimeType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field mimeType of com.linkedin.file.DataHubFileInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "mimeType", value);
                this._mimeTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMimeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "mimeType", value);
                this._mimeTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "mimeType", value);
                this._mimeTypeField = value;
            }
        }
        return this;
    }

    public DataHubFileInfo setMimeType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field mimeType of com.linkedin.file.DataHubFileInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "mimeType", value);
        this._mimeTypeField = value;
        return this;
    }

    public boolean hasSizeInBytes() {
        if (this._sizeInBytesField != null) {
            return true;
        }
        return this._map.containsKey("sizeInBytes");
    }

    public void removeSizeInBytes() {
        this._map.remove("sizeInBytes");
    }

    @Nullable
    public Long getSizeInBytes(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSizeInBytes();
            }
            case DEFAULT: 
            case NULL: {
                if (this._sizeInBytesField != null) {
                    return this._sizeInBytesField;
                }
                Object __rawValue = this._map.get("sizeInBytes");
                this._sizeInBytesField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._sizeInBytesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getSizeInBytes() {
        if (this._sizeInBytesField != null) {
            return this._sizeInBytesField;
        }
        Object __rawValue = this._map.get("sizeInBytes");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("sizeInBytes");
        }
        this._sizeInBytesField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._sizeInBytesField;
    }

    public DataHubFileInfo setSizeInBytes(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSizeInBytes(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field sizeInBytes of com.linkedin.file.DataHubFileInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "sizeInBytes", DataTemplateUtil.coerceLongInput(value));
                this._sizeInBytesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSizeInBytes();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sizeInBytes", DataTemplateUtil.coerceLongInput(value));
                this._sizeInBytesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sizeInBytes", DataTemplateUtil.coerceLongInput(value));
                this._sizeInBytesField = value;
            }
        }
        return this;
    }

    public DataHubFileInfo setSizeInBytes(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sizeInBytes of com.linkedin.file.DataHubFileInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sizeInBytes", DataTemplateUtil.coerceLongInput(value));
        this._sizeInBytesField = value;
        return this;
    }

    public DataHubFileInfo setSizeInBytes(long value) {
        CheckedUtil.putWithoutChecking(this._map, "sizeInBytes", DataTemplateUtil.coerceLongInput(value));
        this._sizeInBytesField = value;
        return this;
    }

    public boolean hasScenario() {
        if (this._scenarioField != null) {
            return true;
        }
        return this._map.containsKey("scenario");
    }

    public void removeScenario() {
        this._map.remove("scenario");
    }

    @Nullable
    public FileUploadScenario getScenario(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getScenario();
            }
            case DEFAULT: 
            case NULL: {
                if (this._scenarioField != null) {
                    return this._scenarioField;
                }
                Object __rawValue = this._map.get("scenario");
                this._scenarioField = DataTemplateUtil.coerceEnumOutput(__rawValue, FileUploadScenario.class, FileUploadScenario.$UNKNOWN);
                return this._scenarioField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FileUploadScenario getScenario() {
        if (this._scenarioField != null) {
            return this._scenarioField;
        }
        Object __rawValue = this._map.get("scenario");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("scenario");
        }
        this._scenarioField = DataTemplateUtil.coerceEnumOutput(__rawValue, FileUploadScenario.class, FileUploadScenario.$UNKNOWN);
        return this._scenarioField;
    }

    public DataHubFileInfo setScenario(@Nullable FileUploadScenario value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setScenario(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field scenario of com.linkedin.file.DataHubFileInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "scenario", value.name());
                this._scenarioField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeScenario();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "scenario", value.name());
                this._scenarioField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "scenario", value.name());
                this._scenarioField = value;
            }
        }
        return this;
    }

    public DataHubFileInfo setScenario(@Nonnull FileUploadScenario value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field scenario of com.linkedin.file.DataHubFileInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "scenario", value.name());
        this._scenarioField = value;
        return this;
    }

    public boolean hasReferencedByAsset() {
        if (this._referencedByAssetField != null) {
            return true;
        }
        return this._map.containsKey("referencedByAsset");
    }

    public void removeReferencedByAsset() {
        this._map.remove("referencedByAsset");
    }

    @Nullable
    public Urn getReferencedByAsset(GetMode mode) {
        return this.getReferencedByAsset();
    }

    @Nullable
    public Urn getReferencedByAsset() {
        if (this._referencedByAssetField != null) {
            return this._referencedByAssetField;
        }
        Object __rawValue = this._map.get("referencedByAsset");
        this._referencedByAssetField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._referencedByAssetField;
    }

    public DataHubFileInfo setReferencedByAsset(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setReferencedByAsset(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeReferencedByAsset();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "referencedByAsset", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._referencedByAssetField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "referencedByAsset", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._referencedByAssetField = value;
            }
        }
        return this;
    }

    public DataHubFileInfo setReferencedByAsset(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field referencedByAsset of com.linkedin.file.DataHubFileInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "referencedByAsset", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._referencedByAssetField = value;
        return this;
    }

    public boolean hasSchemaField() {
        if (this._schemaFieldField != null) {
            return true;
        }
        return this._map.containsKey("schemaField");
    }

    public void removeSchemaField() {
        this._map.remove("schemaField");
    }

    @Nullable
    public Urn getSchemaField(GetMode mode) {
        return this.getSchemaField();
    }

    @Nullable
    public Urn getSchemaField() {
        if (this._schemaFieldField != null) {
            return this._schemaFieldField;
        }
        Object __rawValue = this._map.get("schemaField");
        this._schemaFieldField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._schemaFieldField;
    }

    public DataHubFileInfo setSchemaField(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSchemaField(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSchemaField();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "schemaField", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._schemaFieldField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "schemaField", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._schemaFieldField = value;
            }
        }
        return this;
    }

    public DataHubFileInfo setSchemaField(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field schemaField of com.linkedin.file.DataHubFileInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "schemaField", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._schemaFieldField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreated();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("created");
        }
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public DataHubFileInfo setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.file.DataHubFileInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public DataHubFileInfo setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.file.DataHubFileInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasContentHash() {
        if (this._contentHashField != null) {
            return true;
        }
        return this._map.containsKey("contentHash");
    }

    public void removeContentHash() {
        this._map.remove("contentHash");
    }

    @Nullable
    public String getContentHash(GetMode mode) {
        return this.getContentHash();
    }

    @Nullable
    public String getContentHash() {
        if (this._contentHashField != null) {
            return this._contentHashField;
        }
        Object __rawValue = this._map.get("contentHash");
        this._contentHashField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._contentHashField;
    }

    public DataHubFileInfo setContentHash(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setContentHash(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeContentHash();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "contentHash", value);
                this._contentHashField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "contentHash", value);
                this._contentHashField = value;
            }
        }
        return this;
    }

    public DataHubFileInfo setContentHash(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field contentHash of com.linkedin.file.DataHubFileInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "contentHash", value);
        this._contentHashField = value;
        return this;
    }

    @Override
    public DataHubFileInfo clone() throws CloneNotSupportedException {
        DataHubFileInfo __clone = (DataHubFileInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubFileInfo copy() throws CloneNotSupportedException {
        DataHubFileInfo __copy = (DataHubFileInfo)super.copy();
        __copy._originalFileNameField = null;
        __copy._sizeInBytesField = null;
        __copy._scenarioField = null;
        __copy._schemaFieldField = null;
        __copy._createdField = null;
        __copy._mimeTypeField = null;
        __copy._bucketStorageLocationField = null;
        __copy._referencedByAssetField = null;
        __copy._contentHashField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubFileInfo __objectRef;

        private ChangeListener(DataHubFileInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "originalFileName": {
                    this.__objectRef._originalFileNameField = null;
                    break;
                }
                case "sizeInBytes": {
                    this.__objectRef._sizeInBytesField = null;
                    break;
                }
                case "scenario": {
                    this.__objectRef._scenarioField = null;
                    break;
                }
                case "schemaField": {
                    this.__objectRef._schemaFieldField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "mimeType": {
                    this.__objectRef._mimeTypeField = null;
                    break;
                }
                case "bucketStorageLocation": {
                    this.__objectRef._bucketStorageLocationField = null;
                    break;
                }
                case "referencedByAsset": {
                    this.__objectRef._referencedByAssetField = null;
                    break;
                }
                case "contentHash": {
                    this.__objectRef._contentHashField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public BucketStorageLocation.Fields bucketStorageLocation() {
            return new BucketStorageLocation.Fields(this.getPathComponents(), "bucketStorageLocation");
        }

        public PathSpec originalFileName() {
            return new PathSpec(this.getPathComponents(), "originalFileName");
        }

        public PathSpec mimeType() {
            return new PathSpec(this.getPathComponents(), "mimeType");
        }

        public PathSpec sizeInBytes() {
            return new PathSpec(this.getPathComponents(), "sizeInBytes");
        }

        public PathSpec scenario() {
            return new PathSpec(this.getPathComponents(), "scenario");
        }

        public PathSpec referencedByAsset() {
            return new PathSpec(this.getPathComponents(), "referencedByAsset");
        }

        public PathSpec schemaField() {
            return new PathSpec(this.getPathComponents(), "schemaField");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public PathSpec contentHash() {
            return new PathSpec(this.getPathComponents(), "contentHash");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private BucketStorageLocation.ProjectionMask _bucketStorageLocationMask;
        private AuditStamp.ProjectionMask _createdMask;

        ProjectionMask() {
            super(12);
        }

        public ProjectionMask withBucketStorageLocation(Function<BucketStorageLocation.ProjectionMask, BucketStorageLocation.ProjectionMask> nestedMask) {
            this._bucketStorageLocationMask = nestedMask.apply(this._bucketStorageLocationMask == null ? BucketStorageLocation.createMask() : this._bucketStorageLocationMask);
            this.getDataMap().put("bucketStorageLocation", this._bucketStorageLocationMask.getDataMap());
            return this;
        }

        public ProjectionMask withBucketStorageLocation() {
            this._bucketStorageLocationMask = null;
            this.getDataMap().put("bucketStorageLocation", 1);
            return this;
        }

        public ProjectionMask withOriginalFileName() {
            this.getDataMap().put("originalFileName", 1);
            return this;
        }

        public ProjectionMask withMimeType() {
            this.getDataMap().put("mimeType", 1);
            return this;
        }

        public ProjectionMask withSizeInBytes() {
            this.getDataMap().put("sizeInBytes", 1);
            return this;
        }

        public ProjectionMask withScenario() {
            this.getDataMap().put("scenario", 1);
            return this;
        }

        public ProjectionMask withReferencedByAsset() {
            this.getDataMap().put("referencedByAsset", 1);
            return this;
        }

        public ProjectionMask withSchemaField() {
            this.getDataMap().put("schemaField", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withContentHash() {
            this.getDataMap().put("contentHash", 1);
            return this;
        }
    }
}

