/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.execution;

import com.linkedin.common.AuditStamp;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExecutionRequestSignal
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.execution/**An signal sent to a running execution request*/@Aspect.name=\"dataHubExecutionRequestSignal\"record ExecutionRequestSignal{/**The signal to issue, e.g. KILL*/signal:string/**Advanced: specify a specific executor to route the request to. If none is provided, a \"default\" executor is used.*/executorId:optional string/**Audit Stamp*/createdAt:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}", SchemaFormatType.PDL);
    private String _signalField = null;
    private String _executorIdField = null;
    private AuditStamp _createdAtField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Signal = SCHEMA.getField("signal");
    private static final RecordDataSchema.Field FIELD_ExecutorId = SCHEMA.getField("executorId");
    private static final RecordDataSchema.Field FIELD_CreatedAt = SCHEMA.getField("createdAt");

    public ExecutionRequestSignal() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public ExecutionRequestSignal(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSignal() {
        if (this._signalField != null) {
            return true;
        }
        return this._map.containsKey("signal");
    }

    public void removeSignal() {
        this._map.remove("signal");
    }

    @Nullable
    public String getSignal(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSignal();
            }
            case DEFAULT: 
            case NULL: {
                if (this._signalField != null) {
                    return this._signalField;
                }
                Object __rawValue = this._map.get("signal");
                this._signalField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._signalField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getSignal() {
        if (this._signalField != null) {
            return this._signalField;
        }
        Object __rawValue = this._map.get("signal");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("signal");
        }
        this._signalField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._signalField;
    }

    public ExecutionRequestSignal setSignal(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSignal(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field signal of com.linkedin.execution.ExecutionRequestSignal");
                }
                CheckedUtil.putWithoutChecking(this._map, "signal", value);
                this._signalField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSignal();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "signal", value);
                this._signalField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "signal", value);
                this._signalField = value;
            }
        }
        return this;
    }

    public ExecutionRequestSignal setSignal(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field signal of com.linkedin.execution.ExecutionRequestSignal to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "signal", value);
        this._signalField = value;
        return this;
    }

    public boolean hasExecutorId() {
        if (this._executorIdField != null) {
            return true;
        }
        return this._map.containsKey("executorId");
    }

    public void removeExecutorId() {
        this._map.remove("executorId");
    }

    @Nullable
    public String getExecutorId(GetMode mode) {
        return this.getExecutorId();
    }

    @Nullable
    public String getExecutorId() {
        if (this._executorIdField != null) {
            return this._executorIdField;
        }
        Object __rawValue = this._map.get("executorId");
        this._executorIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._executorIdField;
    }

    public ExecutionRequestSignal setExecutorId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExecutorId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExecutorId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "executorId", value);
                this._executorIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "executorId", value);
                this._executorIdField = value;
            }
        }
        return this;
    }

    public ExecutionRequestSignal setExecutorId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field executorId of com.linkedin.execution.ExecutionRequestSignal to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "executorId", value);
        this._executorIdField = value;
        return this;
    }

    public boolean hasCreatedAt() {
        if (this._createdAtField != null) {
            return true;
        }
        return this._map.containsKey("createdAt");
    }

    public void removeCreatedAt() {
        this._map.remove("createdAt");
    }

    @Nullable
    public AuditStamp getCreatedAt(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreatedAt();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createdAtField != null) {
                    return this._createdAtField;
                }
                Object __rawValue = this._map.get("createdAt");
                this._createdAtField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdAtField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreatedAt() {
        if (this._createdAtField != null) {
            return this._createdAtField;
        }
        Object __rawValue = this._map.get("createdAt");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("createdAt");
        }
        this._createdAtField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdAtField;
    }

    public ExecutionRequestSignal setCreatedAt(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreatedAt(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field createdAt of com.linkedin.execution.ExecutionRequestSignal");
                }
                CheckedUtil.putWithoutChecking(this._map, "createdAt", value.data());
                this._createdAtField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreatedAt();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "createdAt", value.data());
                this._createdAtField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "createdAt", value.data());
                this._createdAtField = value;
            }
        }
        return this;
    }

    public ExecutionRequestSignal setCreatedAt(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field createdAt of com.linkedin.execution.ExecutionRequestSignal to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "createdAt", value.data());
        this._createdAtField = value;
        return this;
    }

    @Override
    public ExecutionRequestSignal clone() throws CloneNotSupportedException {
        ExecutionRequestSignal __clone = (ExecutionRequestSignal)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ExecutionRequestSignal copy() throws CloneNotSupportedException {
        ExecutionRequestSignal __copy = (ExecutionRequestSignal)super.copy();
        __copy._createdAtField = null;
        __copy._executorIdField = null;
        __copy._signalField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ExecutionRequestSignal __objectRef;

        private ChangeListener(ExecutionRequestSignal reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "createdAt": {
                    this.__objectRef._createdAtField = null;
                    break;
                }
                case "executorId": {
                    this.__objectRef._executorIdField = null;
                    break;
                }
                case "signal": {
                    this.__objectRef._signalField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec signal() {
            return new PathSpec(this.getPathComponents(), "signal");
        }

        public PathSpec executorId() {
            return new PathSpec(this.getPathComponents(), "executorId");
        }

        public AuditStamp.Fields createdAt() {
            return new AuditStamp.Fields(this.getPathComponents(), "createdAt");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _createdAtMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withSignal() {
            this.getDataMap().put("signal", 1);
            return this;
        }

        public ProjectionMask withExecutorId() {
            this.getDataMap().put("executorId", 1);
            return this;
        }

        public ProjectionMask withCreatedAt(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdAtMask = nestedMask.apply(this._createdAtMask == null ? AuditStamp.createMask() : this._createdAtMask);
            this.getDataMap().put("createdAt", this._createdAtMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreatedAt(MaskMap nestedMask) {
            this.getDataMap().put("createdAt", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreatedAt() {
            this._createdAtMask = null;
            this.getDataMap().put("createdAt", 1);
            return this;
        }
    }
}

