/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PartitionSummary
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Defines how the data is partitioned*/record PartitionSummary{/**A unique id / value for the partition for which statistics were collected,\ngenerated by applying the key definition to a given row.*/partition:string/**The created time for a given partition.*/createdTime:optional long/**The last modified / touched time for a given partition.*/lastModifiedTime:optional long}", SchemaFormatType.PDL);
    private String _partitionField = null;
    private Long _createdTimeField = null;
    private Long _lastModifiedTimeField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Partition = SCHEMA.getField("partition");
    private static final RecordDataSchema.Field FIELD_CreatedTime = SCHEMA.getField("createdTime");
    private static final RecordDataSchema.Field FIELD_LastModifiedTime = SCHEMA.getField("lastModifiedTime");

    public PartitionSummary() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public PartitionSummary(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasPartition() {
        if (this._partitionField != null) {
            return true;
        }
        return this._map.containsKey("partition");
    }

    public void removePartition() {
        this._map.remove("partition");
    }

    @Nullable
    public String getPartition(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPartition();
            }
            case DEFAULT: 
            case NULL: {
                if (this._partitionField != null) {
                    return this._partitionField;
                }
                Object __rawValue = this._map.get("partition");
                this._partitionField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._partitionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getPartition() {
        if (this._partitionField != null) {
            return this._partitionField;
        }
        Object __rawValue = this._map.get("partition");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("partition");
        }
        this._partitionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._partitionField;
    }

    public PartitionSummary setPartition(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPartition(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field partition of com.linkedin.dataset.PartitionSummary");
                }
                CheckedUtil.putWithoutChecking(this._map, "partition", value);
                this._partitionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePartition();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "partition", value);
                this._partitionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "partition", value);
                this._partitionField = value;
            }
        }
        return this;
    }

    public PartitionSummary setPartition(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field partition of com.linkedin.dataset.PartitionSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "partition", value);
        this._partitionField = value;
        return this;
    }

    public boolean hasCreatedTime() {
        if (this._createdTimeField != null) {
            return true;
        }
        return this._map.containsKey("createdTime");
    }

    public void removeCreatedTime() {
        this._map.remove("createdTime");
    }

    @Nullable
    public Long getCreatedTime(GetMode mode) {
        return this.getCreatedTime();
    }

    @Nullable
    public Long getCreatedTime() {
        if (this._createdTimeField != null) {
            return this._createdTimeField;
        }
        Object __rawValue = this._map.get("createdTime");
        this._createdTimeField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._createdTimeField;
    }

    public PartitionSummary setCreatedTime(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreatedTime(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreatedTime();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "createdTime", DataTemplateUtil.coerceLongInput(value));
                this._createdTimeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "createdTime", DataTemplateUtil.coerceLongInput(value));
                this._createdTimeField = value;
            }
        }
        return this;
    }

    public PartitionSummary setCreatedTime(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field createdTime of com.linkedin.dataset.PartitionSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "createdTime", DataTemplateUtil.coerceLongInput(value));
        this._createdTimeField = value;
        return this;
    }

    public PartitionSummary setCreatedTime(long value) {
        CheckedUtil.putWithoutChecking(this._map, "createdTime", DataTemplateUtil.coerceLongInput(value));
        this._createdTimeField = value;
        return this;
    }

    public boolean hasLastModifiedTime() {
        if (this._lastModifiedTimeField != null) {
            return true;
        }
        return this._map.containsKey("lastModifiedTime");
    }

    public void removeLastModifiedTime() {
        this._map.remove("lastModifiedTime");
    }

    @Nullable
    public Long getLastModifiedTime(GetMode mode) {
        return this.getLastModifiedTime();
    }

    @Nullable
    public Long getLastModifiedTime() {
        if (this._lastModifiedTimeField != null) {
            return this._lastModifiedTimeField;
        }
        Object __rawValue = this._map.get("lastModifiedTime");
        this._lastModifiedTimeField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._lastModifiedTimeField;
    }

    public PartitionSummary setLastModifiedTime(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModifiedTime(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModifiedTime();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModifiedTime", DataTemplateUtil.coerceLongInput(value));
                this._lastModifiedTimeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModifiedTime", DataTemplateUtil.coerceLongInput(value));
                this._lastModifiedTimeField = value;
            }
        }
        return this;
    }

    public PartitionSummary setLastModifiedTime(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModifiedTime of com.linkedin.dataset.PartitionSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModifiedTime", DataTemplateUtil.coerceLongInput(value));
        this._lastModifiedTimeField = value;
        return this;
    }

    public PartitionSummary setLastModifiedTime(long value) {
        CheckedUtil.putWithoutChecking(this._map, "lastModifiedTime", DataTemplateUtil.coerceLongInput(value));
        this._lastModifiedTimeField = value;
        return this;
    }

    @Override
    public PartitionSummary clone() throws CloneNotSupportedException {
        PartitionSummary __clone = (PartitionSummary)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public PartitionSummary copy() throws CloneNotSupportedException {
        PartitionSummary __copy = (PartitionSummary)super.copy();
        __copy._partitionField = null;
        __copy._lastModifiedTimeField = null;
        __copy._createdTimeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final PartitionSummary __objectRef;

        private ChangeListener(PartitionSummary reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "partition": {
                    this.__objectRef._partitionField = null;
                    break;
                }
                case "lastModifiedTime": {
                    this.__objectRef._lastModifiedTimeField = null;
                    break;
                }
                case "createdTime": {
                    this.__objectRef._createdTimeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec partition() {
            return new PathSpec(this.getPathComponents(), "partition");
        }

        public PathSpec createdTime() {
            return new PathSpec(this.getPathComponents(), "createdTime");
        }

        public PathSpec lastModifiedTime() {
            return new PathSpec(this.getPathComponents(), "lastModifiedTime");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withPartition() {
            this.getDataMap().put("partition", 1);
            return this;
        }

        public ProjectionMask withCreatedTime() {
            this.getDataMap().put("createdTime", 1);
            return this;
        }

        public ProjectionMask withLastModifiedTime() {
            this.getDataMap().put("lastModifiedTime", 1);
            return this;
        }
    }
}

