/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatasetUserUsageCounts
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Records a single user's usage counts for a given resource*/record DatasetUserUsageCounts{/**The unique id of the user.*/user:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Number of times the dataset has been used by the user.*/@TimeseriesField={}count:int/**If user_email is set, we attempt to resolve the user's urn upon ingest*/@TimeseriesField={}userEmail:optional string}", SchemaFormatType.PDL);
    private Urn _userField = null;
    private Integer _countField = null;
    private String _userEmailField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_User = SCHEMA.getField("user");
    private static final RecordDataSchema.Field FIELD_Count = SCHEMA.getField("count");
    private static final RecordDataSchema.Field FIELD_UserEmail = SCHEMA.getField("userEmail");

    public DatasetUserUsageCounts() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DatasetUserUsageCounts(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUser() {
        if (this._userField != null) {
            return true;
        }
        return this._map.containsKey("user");
    }

    public void removeUser() {
        this._map.remove("user");
    }

    @Nullable
    public Urn getUser(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUser();
            }
            case DEFAULT: 
            case NULL: {
                if (this._userField != null) {
                    return this._userField;
                }
                Object __rawValue = this._map.get("user");
                this._userField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._userField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getUser() {
        if (this._userField != null) {
            return this._userField;
        }
        Object __rawValue = this._map.get("user");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("user");
        }
        this._userField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._userField;
    }

    public DatasetUserUsageCounts setUser(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUser(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field user of com.linkedin.dataset.DatasetUserUsageCounts");
                }
                CheckedUtil.putWithoutChecking(this._map, "user", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._userField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUser();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "user", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._userField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "user", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._userField = value;
            }
        }
        return this;
    }

    public DatasetUserUsageCounts setUser(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field user of com.linkedin.dataset.DatasetUserUsageCounts to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "user", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._userField = value;
        return this;
    }

    public boolean hasCount() {
        if (this._countField != null) {
            return true;
        }
        return this._map.containsKey("count");
    }

    public void removeCount() {
        this._map.remove("count");
    }

    @Nullable
    public Integer getCount(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCount();
            }
            case DEFAULT: 
            case NULL: {
                if (this._countField != null) {
                    return this._countField;
                }
                Object __rawValue = this._map.get("count");
                this._countField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._countField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getCount() {
        if (this._countField != null) {
            return this._countField;
        }
        Object __rawValue = this._map.get("count");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("count");
        }
        this._countField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._countField;
    }

    public DatasetUserUsageCounts setCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field count of com.linkedin.dataset.DatasetUserUsageCounts");
                }
                CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
                this._countField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
                this._countField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
                this._countField = value;
            }
        }
        return this;
    }

    public DatasetUserUsageCounts setCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field count of com.linkedin.dataset.DatasetUserUsageCounts to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
        this._countField = value;
        return this;
    }

    public DatasetUserUsageCounts setCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
        this._countField = value;
        return this;
    }

    public boolean hasUserEmail() {
        if (this._userEmailField != null) {
            return true;
        }
        return this._map.containsKey("userEmail");
    }

    public void removeUserEmail() {
        this._map.remove("userEmail");
    }

    @Nullable
    public String getUserEmail(GetMode mode) {
        return this.getUserEmail();
    }

    @Nullable
    public String getUserEmail() {
        if (this._userEmailField != null) {
            return this._userEmailField;
        }
        Object __rawValue = this._map.get("userEmail");
        this._userEmailField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._userEmailField;
    }

    public DatasetUserUsageCounts setUserEmail(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUserEmail(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUserEmail();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "userEmail", value);
                this._userEmailField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "userEmail", value);
                this._userEmailField = value;
            }
        }
        return this;
    }

    public DatasetUserUsageCounts setUserEmail(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field userEmail of com.linkedin.dataset.DatasetUserUsageCounts to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "userEmail", value);
        this._userEmailField = value;
        return this;
    }

    @Override
    public DatasetUserUsageCounts clone() throws CloneNotSupportedException {
        DatasetUserUsageCounts __clone = (DatasetUserUsageCounts)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DatasetUserUsageCounts copy() throws CloneNotSupportedException {
        DatasetUserUsageCounts __copy = (DatasetUserUsageCounts)super.copy();
        __copy._countField = null;
        __copy._userEmailField = null;
        __copy._userField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DatasetUserUsageCounts __objectRef;

        private ChangeListener(DatasetUserUsageCounts reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "count": {
                    this.__objectRef._countField = null;
                    break;
                }
                case "userEmail": {
                    this.__objectRef._userEmailField = null;
                    break;
                }
                case "user": {
                    this.__objectRef._userField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec user() {
            return new PathSpec(this.getPathComponents(), "user");
        }

        public PathSpec count() {
            return new PathSpec(this.getPathComponents(), "count");
        }

        public PathSpec userEmail() {
            return new PathSpec(this.getPathComponents(), "userEmail");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withUser() {
            this.getDataMap().put("user", 1);
            return this;
        }

        public ProjectionMask withCount() {
            this.getDataMap().put("count", 1);
            return this;
        }

        public ProjectionMask withUserEmail() {
            this.getDataMap().put("userEmail", 1);
            return this;
        }
    }
}

