/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.datajob.datahub;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IngestionCheckpointState
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.datajob.datahub/**The checkpoint state object of a datahub ingestion run for a given job.*/record IngestionCheckpointState{/**The version of the state format.*/formatVersion:string/**The serialization/deserialization protocol.*/serde:string/**Opaque blob of the state representation.*/payload:optional bytes}", SchemaFormatType.PDL);
    private String _formatVersionField = null;
    private String _serdeField = null;
    private ByteString _payloadField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_FormatVersion = SCHEMA.getField("formatVersion");
    private static final RecordDataSchema.Field FIELD_Serde = SCHEMA.getField("serde");
    private static final RecordDataSchema.Field FIELD_Payload = SCHEMA.getField("payload");

    public IngestionCheckpointState() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public IngestionCheckpointState(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasFormatVersion() {
        if (this._formatVersionField != null) {
            return true;
        }
        return this._map.containsKey("formatVersion");
    }

    public void removeFormatVersion() {
        this._map.remove("formatVersion");
    }

    @Nullable
    public String getFormatVersion(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFormatVersion();
            }
            case DEFAULT: 
            case NULL: {
                if (this._formatVersionField != null) {
                    return this._formatVersionField;
                }
                Object __rawValue = this._map.get("formatVersion");
                this._formatVersionField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._formatVersionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getFormatVersion() {
        if (this._formatVersionField != null) {
            return this._formatVersionField;
        }
        Object __rawValue = this._map.get("formatVersion");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("formatVersion");
        }
        this._formatVersionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._formatVersionField;
    }

    public IngestionCheckpointState setFormatVersion(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFormatVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field formatVersion of com.linkedin.datajob.datahub.IngestionCheckpointState");
                }
                CheckedUtil.putWithoutChecking(this._map, "formatVersion", value);
                this._formatVersionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFormatVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "formatVersion", value);
                this._formatVersionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "formatVersion", value);
                this._formatVersionField = value;
            }
        }
        return this;
    }

    public IngestionCheckpointState setFormatVersion(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field formatVersion of com.linkedin.datajob.datahub.IngestionCheckpointState to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "formatVersion", value);
        this._formatVersionField = value;
        return this;
    }

    public boolean hasSerde() {
        if (this._serdeField != null) {
            return true;
        }
        return this._map.containsKey("serde");
    }

    public void removeSerde() {
        this._map.remove("serde");
    }

    @Nullable
    public String getSerde(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSerde();
            }
            case DEFAULT: 
            case NULL: {
                if (this._serdeField != null) {
                    return this._serdeField;
                }
                Object __rawValue = this._map.get("serde");
                this._serdeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._serdeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getSerde() {
        if (this._serdeField != null) {
            return this._serdeField;
        }
        Object __rawValue = this._map.get("serde");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("serde");
        }
        this._serdeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._serdeField;
    }

    public IngestionCheckpointState setSerde(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSerde(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field serde of com.linkedin.datajob.datahub.IngestionCheckpointState");
                }
                CheckedUtil.putWithoutChecking(this._map, "serde", value);
                this._serdeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSerde();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "serde", value);
                this._serdeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "serde", value);
                this._serdeField = value;
            }
        }
        return this;
    }

    public IngestionCheckpointState setSerde(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field serde of com.linkedin.datajob.datahub.IngestionCheckpointState to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "serde", value);
        this._serdeField = value;
        return this;
    }

    public boolean hasPayload() {
        if (this._payloadField != null) {
            return true;
        }
        return this._map.containsKey("payload");
    }

    public void removePayload() {
        this._map.remove("payload");
    }

    @Nullable
    public ByteString getPayload(GetMode mode) {
        return this.getPayload();
    }

    @Nullable
    public ByteString getPayload() {
        if (this._payloadField != null) {
            return this._payloadField;
        }
        Object __rawValue = this._map.get("payload");
        this._payloadField = DataTemplateUtil.coerceBytesOutput(__rawValue);
        return this._payloadField;
    }

    public IngestionCheckpointState setPayload(@Nullable ByteString value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPayload(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePayload();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "payload", value);
                this._payloadField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "payload", value);
                this._payloadField = value;
            }
        }
        return this;
    }

    public IngestionCheckpointState setPayload(@Nonnull ByteString value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field payload of com.linkedin.datajob.datahub.IngestionCheckpointState to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "payload", value);
        this._payloadField = value;
        return this;
    }

    @Override
    public IngestionCheckpointState clone() throws CloneNotSupportedException {
        IngestionCheckpointState __clone = (IngestionCheckpointState)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IngestionCheckpointState copy() throws CloneNotSupportedException {
        IngestionCheckpointState __copy = (IngestionCheckpointState)super.copy();
        __copy._serdeField = null;
        __copy._payloadField = null;
        __copy._formatVersionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IngestionCheckpointState __objectRef;

        private ChangeListener(IngestionCheckpointState reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "serde": {
                    this.__objectRef._serdeField = null;
                    break;
                }
                case "payload": {
                    this.__objectRef._payloadField = null;
                    break;
                }
                case "formatVersion": {
                    this.__objectRef._formatVersionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec formatVersion() {
            return new PathSpec(this.getPathComponents(), "formatVersion");
        }

        public PathSpec serde() {
            return new PathSpec(this.getPathComponents(), "serde");
        }

        public PathSpec payload() {
            return new PathSpec(this.getPathComponents(), "payload");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withFormatVersion() {
            this.getDataMap().put("formatVersion", 1);
            return this;
        }

        public ProjectionMask withSerde() {
            this.getDataMap().put("serde", 1);
            return this;
        }

        public ProjectionMask withPayload() {
            this.getDataMap().put("payload", 1);
            return this;
        }
    }
}

