/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataList;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.template.AbstractArrayTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;

public abstract class DirectArrayTemplate<E>
extends AbstractArrayTemplate<E> {
    protected DirectArrayTemplate(DataList list, ArrayDataSchema schema, Class<E> elementClass) {
        this(list, schema, elementClass, elementClass.isEnum() ? String.class : elementClass);
    }

    protected DirectArrayTemplate(DataList list, ArrayDataSchema schema, Class<E> elementClass, Class<?> dataClass) {
        super(list, schema, elementClass, dataClass);
    }

    @Override
    public boolean add(E element) throws ClassCastException {
        return CheckedUtil.addWithoutChecking(this._list, this.safeCoerceInput(element));
    }

    @Override
    public void add(int index, E element) throws ClassCastException {
        CheckedUtil.addWithoutChecking(this._list, index, this.safeCoerceInput(element));
    }

    @Override
    public E get(int index) throws TemplateOutputCastException {
        return this.coerceOutput(this._list.get(index));
    }

    @Override
    public E remove(int index) throws TemplateOutputCastException {
        return this.coerceOutput(this._list.remove(index));
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this._list.removeRange(fromIndex, toIndex);
    }

    @Override
    public E set(int index, E element) throws ClassCastException, TemplateOutputCastException {
        return this.coerceOutput(CheckedUtil.setWithoutChecking(this._list, index, this.safeCoerceInput(element)));
    }

    private Object safeCoerceInput(Object object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        if (object.getClass() != this._elementClass) {
            return DataTemplateUtil.coerceInput(object, this._elementClass, this._dataClass);
        }
        return this.coerceInput(object);
    }

    protected Object coerceInput(E object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        return DataTemplateUtil.coerceInput(object, this._elementClass, this._dataClass);
    }

    protected E coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return (E)DataTemplateUtil.coerceOutput(object, this._elementClass);
    }
}

