/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.grammar;

import com.linkedin.data.grammar.PdlParser;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class PdlParseUtils {
    private static final Pattern ESCAPE_CHAR_PATTERN = Pattern.compile(String.valueOf('`'));

    public static String extractMarkdown(String schemaDoc) {
        String trimmed = schemaDoc.trim();
        String withoutMargin = PdlParseUtils.stripMargin(trimmed.substring(3, trimmed.length() - 2));
        return PdlParseUtils.unescapeDocstring(withoutMargin);
    }

    private static String unescapeDocstring(String escaped) {
        String commentUnescaped = escaped.replace("&#47;&#42;", "/*").replace("&#42;&#47;", "*/");
        return StringEscapeUtils.unescapeHtml4(commentUnescaped);
    }

    public static String extractString(String stringLiteral) {
        return StringEscapeUtils.unescapeJson(stringLiteral.substring(1, stringLiteral.length() - 1));
    }

    public static String stripMargin(String schemadoc) {
        char marginChar = '*';
        StringBuilder buf = new StringBuilder();
        String[] schemadocByLine = schemadoc.split(System.lineSeparator());
        for (int i = 0; i < schemadocByLine.length; ++i) {
            int index;
            String lineWithoutSeparator = schemadocByLine[i];
            if ((i == 0 || i == schemadocByLine.length - 1) && lineWithoutSeparator.trim().isEmpty()) continue;
            String line = lineWithoutSeparator + System.lineSeparator();
            int len = line.length();
            for (index = 0; index < len && line.charAt(index) <= ' '; ++index) {
            }
            if (index < len && line.charAt(index) == marginChar) {
                if (index + 1 < len && line.charAt(index + 1) == ' ') {
                    ++index;
                }
                buf.append(line.substring(index + 1));
                continue;
            }
            buf.append(line);
        }
        String withoutMargin = buf.toString();
        if (withoutMargin.endsWith(System.lineSeparator())) {
            withoutMargin = withoutMargin.substring(0, withoutMargin.lastIndexOf(System.lineSeparator()));
        }
        return withoutMargin;
    }

    public static String unescapeIdentifier(String identifier) {
        return ESCAPE_CHAR_PATTERN.matcher(identifier).replaceAll("");
    }

    public static String validatePegasusId(String identifier) {
        if (identifier.contains("-")) {
            throw new IllegalArgumentException("Illegal '-' in identifier: " + identifier);
        }
        return identifier;
    }

    public static String join(List<PdlParser.IdentifierContext> identifiers) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<PdlParser.IdentifierContext> iter = identifiers.iterator();
        while (iter.hasNext()) {
            stringBuilder.append(iter.next().value);
            if (!iter.hasNext()) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public static Number toNumber(String string) {
        BigDecimal bigDecimal = new BigDecimal(string);
        if (StringUtils.containsAny((CharSequence)string, '.', 'e', 'E')) {
            double d = bigDecimal.doubleValue();
            if (Double.isFinite(d)) {
                return d;
            }
            return bigDecimal;
        }
        long l = bigDecimal.longValueExact();
        int i = (int)l;
        if ((long)i == l) {
            return (int)l;
        }
        return l;
    }
}

