/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.DataSchemaParserFactory;
import com.linkedin.data.schema.SchemaParserFactory;
import com.linkedin.data.schema.grammar.PdlSchemaParserFactory;

public enum SchemaFormatType {
    PDSC(SchemaParserFactory.instance()),
    PDL(PdlSchemaParserFactory.instance());

    private final DataSchemaParserFactory _schemaParserFactory;

    private SchemaFormatType(DataSchemaParserFactory schemaParserFactory) {
        this._schemaParserFactory = schemaParserFactory;
    }

    public DataSchemaParserFactory getSchemaParserFactory() {
        return this._schemaParserFactory;
    }

    public static SchemaFormatType fromFilename(String filename) {
        if (filename == null) {
            return null;
        }
        int startIndex = filename.lastIndexOf(".") + 1;
        if (startIndex == filename.length()) {
            return null;
        }
        return SchemaFormatType.fromFileExtension(filename.substring(startIndex));
    }

    public static SchemaFormatType fromFileExtension(String fileExtension) {
        for (SchemaFormatType fileType : SchemaFormatType.values()) {
            if (!fileType.getSchemaParserFactory().getLanguageExtension().equalsIgnoreCase(fileExtension)) continue;
            return fileType;
        }
        return null;
    }
}

