/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.JsonBuilder;
import com.linkedin.data.schema.SchemaToJsonEncoder;
import java.util.HashMap;
import java.util.Map;

public abstract class DataSchema
implements Cloneable {
    private final Type _type;
    Map<String, Object> _resolvedProperties = new HashMap<String, Object>(0);

    protected DataSchema(Type type) {
        this._type = type;
    }

    public Type getType() {
        return this._type;
    }

    public Type getDereferencedType() {
        return this._type;
    }

    public DataSchema getDereferencedDataSchema() {
        return this;
    }

    public abstract boolean hasError();

    public abstract boolean isPrimitive();

    public boolean isComplex() {
        return !this.isPrimitive();
    }

    public abstract Map<String, Object> getProperties();

    public Map<String, Object> getResolvedProperties() {
        return this._resolvedProperties;
    }

    public void setResolvedProperties(Map<String, Object> resolvedProperties) {
        this._resolvedProperties = new HashMap<String, Object>(resolvedProperties);
    }

    public abstract String getUnionMemberKey();

    public String toString() {
        return SchemaToJsonEncoder.schemaToJson(this, JsonBuilder.Pretty.SPACES);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public DataSchema clone() throws CloneNotSupportedException {
        DataSchema dataSchema = (DataSchema)super.clone();
        dataSchema._resolvedProperties = new HashMap<String, Object>();
        return dataSchema;
    }

    public static enum Type {
        BOOLEAN,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BYTES,
        STRING,
        NULL,
        FIXED,
        ENUM,
        ARRAY,
        RECORD,
        MAP,
        UNION,
        TYPEREF;

    }
}

