/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.AbstractJacksonDataCodec;
import com.linkedin.data.codec.entitystream.JacksonJsonDataEncoder;
import com.linkedin.data.codec.entitystream.JacksonJsonDataListDecoder;
import com.linkedin.data.codec.entitystream.JacksonJsonDataMapDecoder;
import com.linkedin.data.codec.entitystream.StreamDataCodec;
import com.linkedin.entitystream.EntityStream;
import com.linkedin.entitystream.EntityStreams;
import datahub.shaded.jackson.core.JsonFactory;
import java.util.concurrent.CompletionStage;

public class JacksonStreamDataCodec
implements StreamDataCodec {
    protected final int _bufferSize;
    protected final JsonFactory _jsonFactory;

    public JacksonStreamDataCodec(int bufferSize) {
        this(bufferSize, AbstractJacksonDataCodec.JSON_FACTORY);
    }

    public JacksonStreamDataCodec(int bufferSize, JsonFactory jsonFactory) {
        this._bufferSize = bufferSize;
        this._jsonFactory = jsonFactory;
    }

    @Override
    public CompletionStage<DataMap> decodeMap(EntityStream<ByteString> entityStream) {
        JacksonJsonDataMapDecoder decoder = new JacksonJsonDataMapDecoder(this._jsonFactory);
        entityStream.setReader(decoder);
        return decoder.getResult();
    }

    @Override
    public CompletionStage<DataList> decodeList(EntityStream<ByteString> entityStream) {
        JacksonJsonDataListDecoder decoder = new JacksonJsonDataListDecoder(this._jsonFactory);
        entityStream.setReader(decoder);
        return decoder.getResult();
    }

    @Override
    public EntityStream<ByteString> encodeMap(DataMap map) {
        JacksonJsonDataEncoder encoder = new JacksonJsonDataEncoder(this._jsonFactory, map, this._bufferSize);
        return EntityStreams.newEntityStream(encoder);
    }

    @Override
    public EntityStream<ByteString> encodeList(DataList list) {
        JacksonJsonDataEncoder encoder = new JacksonJsonDataEncoder(this._jsonFactory, list, this._bufferSize);
        return EntityStreams.newEntityStream(encoder);
    }
}

