/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec;

import com.linkedin.data.codec.symbol.EmptySymbolTable;
import com.linkedin.data.codec.symbol.SymbolTable;

public class ProtobufCodecOptions {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private final SymbolTable _symbolTable;
    private final boolean _enableASCIIOnlyStrings;
    private final boolean _enableFixedLengthFloatDoubles;
    private final boolean _shouldTolerateInvalidSurrogatePairs;
    private final int _protoWriterBufferSize;

    private ProtobufCodecOptions(SymbolTable symbolTable, boolean enableASCIIOnlyStrings, boolean enableFixedLengthFloatDoubles, boolean tolerateInvalidSurrogatePairs, int protoWriterBufferSize) {
        this._symbolTable = symbolTable == null ? EmptySymbolTable.SHARED : symbolTable;
        this._enableASCIIOnlyStrings = enableASCIIOnlyStrings;
        this._enableFixedLengthFloatDoubles = enableFixedLengthFloatDoubles;
        this._shouldTolerateInvalidSurrogatePairs = tolerateInvalidSurrogatePairs;
        this._protoWriterBufferSize = protoWriterBufferSize;
    }

    public SymbolTable getSymbolTable() {
        return this._symbolTable;
    }

    public boolean shouldEnableASCIIOnlyStrings() {
        return this._enableASCIIOnlyStrings;
    }

    public boolean shouldEnableFixedLengthFloatDoubles() {
        return this._enableFixedLengthFloatDoubles;
    }

    public boolean shouldTolerateInvalidSurrogatePairs() {
        return this._shouldTolerateInvalidSurrogatePairs;
    }

    public int getProtoWriterBufferSize() {
        return this._protoWriterBufferSize;
    }

    public static final class Builder {
        private SymbolTable _symbolTable = null;
        private boolean _enableASCIIOnlyStrings = false;
        private boolean _enableFixedLengthFloatDoubles = false;
        private boolean _shouldTolerateInvalidSurrogatePairs = true;
        private int _protoWriterBufferSize = 4096;

        public Builder setSymbolTable(SymbolTable symbolTable) {
            this._symbolTable = symbolTable;
            return this;
        }

        public Builder setEnableASCIIOnlyStrings(boolean enableASCIIOnlyStrings) {
            this._enableASCIIOnlyStrings = enableASCIIOnlyStrings;
            return this;
        }

        public Builder setEnableFixedLengthFloatDoubles(boolean enableFixedLengthFloatDoubles) {
            this._enableFixedLengthFloatDoubles = enableFixedLengthFloatDoubles;
            return this;
        }

        public Builder setShouldTolerateInvalidSurrogatePairs(boolean tolerateInvalidSurrogatePairs) {
            this._shouldTolerateInvalidSurrogatePairs = tolerateInvalidSurrogatePairs;
            return this;
        }

        public Builder setProtoWriterBufferSize(int protoWriterBufferSize) {
            assert (protoWriterBufferSize > 0);
            this._protoWriterBufferSize = protoWriterBufferSize;
            return this;
        }

        public ProtobufCodecOptions build() {
            return new ProtobufCodecOptions(this._symbolTable, this._enableASCIIOnlyStrings, this._enableFixedLengthFloatDoubles, this._shouldTolerateInvalidSurrogatePairs, this._protoWriterBufferSize);
        }
    }
}

