/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.MetadataAttribution;
import com.linkedin.common.OwnershipSource;
import com.linkedin.common.OwnershipType;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Owner
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Ownership information*/record Owner{/**Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name\n(Caveat: only corpuser is currently supported in the frontend.)*/@Relationship={\"entityTypes\":[\"corpuser\",\"corpGroup\"],\"name\":\"OwnedBy\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"owners\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Owned By\",\"hasValuesFieldName\":\"hasOwners\",\"queryByDefault\":false,\"searchTier\":2}owner:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The type of the ownership*/@deprecated,type:/**Asset owner types*/enum OwnershipType{/**Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no\nenum value for. This is used for backwards compatibility*/CUSTOM/**person or group who is responsible for technical aspects of the asset.*/TECHNICAL_OWNER/**A person or group who is responsible for logical, or business related, aspects of the asset.*/BUSINESS_OWNER/**A steward, expert, or delegate responsible for the asset.*/DATA_STEWARD/**No specific type associated to the owner.*/NONE/**A person or group that is in charge of developing the code\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DEVELOPER/**A person or group that is owning the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DATAOWNER/**A person or a group that overseas the operation, e.g. a DBA or SRE.\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DELEGATE/**A person, group, or service that produces/generates the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,PRODUCER/**A person, group, or service that consumes the data\nDeprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead.*/@deprecated,CONSUMER/**A person or a group that has direct business interest\nDeprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead.*/@deprecated,STAKEHOLDER}/**The type of the ownership\nUrn of type O*/@Relationship={\"entityTypes\":[\"ownershipType\"],\"name\":\"ownershipType\"}typeUrn:optional Urn/**Source information for the ownership*/source:optional/**Source/provider of the ownership information*/record OwnershipSource{/**The type of the source*/type:enum OwnershipSourceType{/**Auditing system or audit logs*/AUDIT/**Database, e.g. GRANTS table*/DATABASE/**File system, e.g. file/directory owner*/FILE_SYSTEM/**Issue tracking system, e.g. Jira*/ISSUE_TRACKING_SYSTEM/**Manually provided by a user*/MANUAL/**Other ownership-like service, e.g. Nuage, ACL service etc*/SERVICE/**SCM system, e.g. GIT, SVN*/SOURCE_CONTROL/**Other sources*/OTHER}/**A reference URL for the source*/url:optional string}/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"ownerAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"ownerAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"ownerAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}", SchemaFormatType.PDL);
    private Urn _ownerField = null;
    private OwnershipType _typeField = null;
    private Urn _typeUrnField = null;
    private OwnershipSource _sourceField = null;
    private MetadataAttribution _attributionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Owner = SCHEMA.getField("owner");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_TypeUrn = SCHEMA.getField("typeUrn");
    private static final RecordDataSchema.Field FIELD_Source = SCHEMA.getField("source");
    private static final RecordDataSchema.Field FIELD_Attribution = SCHEMA.getField("attribution");

    public Owner() {
        super(new DataMap(7, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public Owner(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasOwner() {
        if (this._ownerField != null) {
            return true;
        }
        return this._map.containsKey("owner");
    }

    public void removeOwner() {
        this._map.remove("owner");
    }

    @Nullable
    public Urn getOwner(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOwner();
            }
            case DEFAULT: 
            case NULL: {
                if (this._ownerField != null) {
                    return this._ownerField;
                }
                Object __rawValue = this._map.get("owner");
                this._ownerField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._ownerField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getOwner() {
        if (this._ownerField != null) {
            return this._ownerField;
        }
        Object __rawValue = this._map.get("owner");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("owner");
        }
        this._ownerField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._ownerField;
    }

    public Owner setOwner(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOwner(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field owner of com.linkedin.common.Owner");
                }
                CheckedUtil.putWithoutChecking(this._map, "owner", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._ownerField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOwner();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "owner", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._ownerField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "owner", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._ownerField = value;
            }
        }
        return this;
    }

    public Owner setOwner(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field owner of com.linkedin.common.Owner to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "owner", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._ownerField = value;
        return this;
    }

    @Deprecated
    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    @Deprecated
    public void removeType() {
        this._map.remove("type");
    }

    @Deprecated
    @Nullable
    public OwnershipType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, OwnershipType.class, OwnershipType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public OwnershipType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, OwnershipType.class, OwnershipType.$UNKNOWN);
        return this._typeField;
    }

    @Deprecated
    public Owner setType(@Nullable OwnershipType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.common.Owner");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    @Deprecated
    public Owner setType(@Nonnull OwnershipType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.common.Owner to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasTypeUrn() {
        if (this._typeUrnField != null) {
            return true;
        }
        return this._map.containsKey("typeUrn");
    }

    public void removeTypeUrn() {
        this._map.remove("typeUrn");
    }

    @Nullable
    public Urn getTypeUrn(GetMode mode) {
        return this.getTypeUrn();
    }

    @Nullable
    public Urn getTypeUrn() {
        if (this._typeUrnField != null) {
            return this._typeUrnField;
        }
        Object __rawValue = this._map.get("typeUrn");
        this._typeUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._typeUrnField;
    }

    public Owner setTypeUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTypeUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTypeUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "typeUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._typeUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "typeUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._typeUrnField = value;
            }
        }
        return this;
    }

    public Owner setTypeUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field typeUrn of com.linkedin.common.Owner to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "typeUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._typeUrnField = value;
        return this;
    }

    public boolean hasSource() {
        if (this._sourceField != null) {
            return true;
        }
        return this._map.containsKey("source");
    }

    public void removeSource() {
        this._map.remove("source");
    }

    @Nullable
    public OwnershipSource getSource(GetMode mode) {
        return this.getSource();
    }

    @Nullable
    public OwnershipSource getSource() {
        if (this._sourceField != null) {
            return this._sourceField;
        }
        Object __rawValue = this._map.get("source");
        this._sourceField = __rawValue == null ? null : new OwnershipSource(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._sourceField;
    }

    public Owner setSource(@Nullable OwnershipSource value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSource(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSource();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "source", value.data());
                this._sourceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "source", value.data());
                this._sourceField = value;
            }
        }
        return this;
    }

    public Owner setSource(@Nonnull OwnershipSource value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field source of com.linkedin.common.Owner to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "source", value.data());
        this._sourceField = value;
        return this;
    }

    public boolean hasAttribution() {
        if (this._attributionField != null) {
            return true;
        }
        return this._map.containsKey("attribution");
    }

    public void removeAttribution() {
        this._map.remove("attribution");
    }

    @Nullable
    public MetadataAttribution getAttribution(GetMode mode) {
        return this.getAttribution();
    }

    @Nullable
    public MetadataAttribution getAttribution() {
        if (this._attributionField != null) {
            return this._attributionField;
        }
        Object __rawValue = this._map.get("attribution");
        this._attributionField = __rawValue == null ? null : new MetadataAttribution(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._attributionField;
    }

    public Owner setAttribution(@Nullable MetadataAttribution value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAttribution(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAttribution();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
                this._attributionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
                this._attributionField = value;
            }
        }
        return this;
    }

    public Owner setAttribution(@Nonnull MetadataAttribution value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field attribution of com.linkedin.common.Owner to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
        this._attributionField = value;
        return this;
    }

    @Override
    public Owner clone() throws CloneNotSupportedException {
        Owner __clone = (Owner)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Owner copy() throws CloneNotSupportedException {
        Owner __copy = (Owner)super.copy();
        __copy._ownerField = null;
        __copy._typeUrnField = null;
        __copy._attributionField = null;
        __copy._sourceField = null;
        __copy._typeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Owner __objectRef;

        private ChangeListener(Owner reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "owner": {
                    this.__objectRef._ownerField = null;
                    break;
                }
                case "typeUrn": {
                    this.__objectRef._typeUrnField = null;
                    break;
                }
                case "attribution": {
                    this.__objectRef._attributionField = null;
                    break;
                }
                case "source": {
                    this.__objectRef._sourceField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec owner() {
            return new PathSpec(this.getPathComponents(), "owner");
        }

        @Deprecated
        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec typeUrn() {
            return new PathSpec(this.getPathComponents(), "typeUrn");
        }

        public OwnershipSource.Fields source() {
            return new OwnershipSource.Fields(this.getPathComponents(), "source");
        }

        public MetadataAttribution.Fields attribution() {
            return new MetadataAttribution.Fields(this.getPathComponents(), "attribution");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private OwnershipSource.ProjectionMask _sourceMask;
        private MetadataAttribution.ProjectionMask _attributionMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withOwner() {
            this.getDataMap().put("owner", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withTypeUrn() {
            this.getDataMap().put("typeUrn", 1);
            return this;
        }

        public ProjectionMask withSource(Function<OwnershipSource.ProjectionMask, OwnershipSource.ProjectionMask> nestedMask) {
            this._sourceMask = nestedMask.apply(this._sourceMask == null ? OwnershipSource.createMask() : this._sourceMask);
            this.getDataMap().put("source", this._sourceMask.getDataMap());
            return this;
        }

        public ProjectionMask withSource() {
            this._sourceMask = null;
            this.getDataMap().put("source", 1);
            return this;
        }

        public ProjectionMask withAttribution(Function<MetadataAttribution.ProjectionMask, MetadataAttribution.ProjectionMask> nestedMask) {
            this._attributionMask = nestedMask.apply(this._attributionMask == null ? MetadataAttribution.createMask() : this._attributionMask);
            this.getDataMap().put("attribution", this._attributionMask.getDataMap());
            return this;
        }

        public ProjectionMask withAttribution() {
            this._attributionMask = null;
            this.getDataMap().put("attribution", 1);
            return this;
        }
    }
}

