/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuditLogSpec
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Information about the Audit Log operation to use in evaluating an assertion.\n*/record AuditLogSpec{/**The list of operation types that should be monitored. If not provided, a default set will be used.*/operationTypes:optional array[string]/**Optional: The user name associated with the operation.*/userName:optional string}", SchemaFormatType.PDL);
    private StringArray _operationTypesField = null;
    private String _userNameField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_OperationTypes = SCHEMA.getField("operationTypes");
    private static final RecordDataSchema.Field FIELD_UserName = SCHEMA.getField("userName");

    public AuditLogSpec() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public AuditLogSpec(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasOperationTypes() {
        if (this._operationTypesField != null) {
            return true;
        }
        return this._map.containsKey("operationTypes");
    }

    public void removeOperationTypes() {
        this._map.remove("operationTypes");
    }

    @Nullable
    public StringArray getOperationTypes(GetMode mode) {
        return this.getOperationTypes();
    }

    @Nullable
    public StringArray getOperationTypes() {
        if (this._operationTypesField != null) {
            return this._operationTypesField;
        }
        Object __rawValue = this._map.get("operationTypes");
        this._operationTypesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._operationTypesField;
    }

    public AuditLogSpec setOperationTypes(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOperationTypes(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOperationTypes();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "operationTypes", value.data());
                this._operationTypesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "operationTypes", value.data());
                this._operationTypesField = value;
            }
        }
        return this;
    }

    public AuditLogSpec setOperationTypes(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field operationTypes of com.linkedin.assertion.AuditLogSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "operationTypes", value.data());
        this._operationTypesField = value;
        return this;
    }

    public boolean hasUserName() {
        if (this._userNameField != null) {
            return true;
        }
        return this._map.containsKey("userName");
    }

    public void removeUserName() {
        this._map.remove("userName");
    }

    @Nullable
    public String getUserName(GetMode mode) {
        return this.getUserName();
    }

    @Nullable
    public String getUserName() {
        if (this._userNameField != null) {
            return this._userNameField;
        }
        Object __rawValue = this._map.get("userName");
        this._userNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._userNameField;
    }

    public AuditLogSpec setUserName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUserName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUserName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "userName", value);
                this._userNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "userName", value);
                this._userNameField = value;
            }
        }
        return this;
    }

    public AuditLogSpec setUserName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field userName of com.linkedin.assertion.AuditLogSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "userName", value);
        this._userNameField = value;
        return this;
    }

    @Override
    public AuditLogSpec clone() throws CloneNotSupportedException {
        AuditLogSpec __clone = (AuditLogSpec)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AuditLogSpec copy() throws CloneNotSupportedException {
        AuditLogSpec __copy = (AuditLogSpec)super.copy();
        __copy._userNameField = null;
        __copy._operationTypesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AuditLogSpec __objectRef;

        private ChangeListener(AuditLogSpec reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "userName": {
                    this.__objectRef._userNameField = null;
                    break;
                }
                case "operationTypes": {
                    this.__objectRef._operationTypesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec operationTypes() {
            return new PathSpec(this.getPathComponents(), "operationTypes");
        }

        public PathSpec operationTypes(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "operationTypes");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec userName() {
            return new PathSpec(this.getPathComponents(), "userName");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withOperationTypes() {
            this.getDataMap().put("operationTypes", 1);
            return this;
        }

        public ProjectionMask withOperationTypes(Integer start, Integer count) {
            this.getDataMap().put("operationTypes", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("operationTypes").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("operationTypes").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withUserName() {
            this.getDataMap().put("userName", 1);
            return this;
        }
    }
}

