/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.AssertionResultError;
import com.linkedin.assertion.AssertionResultType;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssertionResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**The result of running an assertion*/record AssertionResult{/** The final result, e.g. either SUCCESS, FAILURE, or ERROR.*/@Searchable={}@TimeseriesField={}type:/** The final result of evaluating an assertion, e.g. SUCCESS, FAILURE, or ERROR.*/enum AssertionResultType{/** The Assertion has not yet been fully evaluated*/INIT/** The Assertion Succeeded*/SUCCESS/** The Assertion Failed*/FAILURE/** The Assertion encountered an Error*/ERROR}/**Number of rows for evaluated batch*/rowCount:optional long/**Number of rows with missing value for evaluated batch*/missingCount:optional long/**Number of rows with unexpected value for evaluated batch*/unexpectedCount:optional long/**Observed aggregate value for evaluated batch*/actualAggValue:optional float/**Other results of evaluation*/nativeResults:optional map[string,string]/**External URL where full results are available. Only present when assertion source is not native.*/externalUrl:optional string/** The error object if AssertionResultType is an Error*/error:optional/** An error encountered when evaluating an AssertionResult*/record AssertionResultError{/** The type of error encountered*/type:enum AssertionResultErrorType{/** Source is unreachable*/SOURCE_CONNECTION_ERROR/** Source query failed to execute*/SOURCE_QUERY_FAILED/** Insufficient data to evaluate the assertion*/INSUFFICIENT_DATA/** Invalid parameters were detected*/INVALID_PARAMETERS/** Event type not supported by the specified source*/INVALID_SOURCE_TYPE/** Unsupported platform*/UNSUPPORTED_PLATFORM/** Error while executing a custom SQL assertion*/CUSTOM_SQL_ERROR/** Error while executing a field assertion*/FIELD_ASSERTION_ERROR/** Unknown error*/UNKNOWN_ERROR}/** Additional metadata depending on the type of error*/properties:optional map[string,string]}}", SchemaFormatType.PDL);
    private AssertionResultType _typeField = null;
    private Long _rowCountField = null;
    private Long _missingCountField = null;
    private Long _unexpectedCountField = null;
    private Float _actualAggValueField = null;
    private StringMap _nativeResultsField = null;
    private String _externalUrlField = null;
    private AssertionResultError _errorField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_RowCount = SCHEMA.getField("rowCount");
    private static final RecordDataSchema.Field FIELD_MissingCount = SCHEMA.getField("missingCount");
    private static final RecordDataSchema.Field FIELD_UnexpectedCount = SCHEMA.getField("unexpectedCount");
    private static final RecordDataSchema.Field FIELD_ActualAggValue = SCHEMA.getField("actualAggValue");
    private static final RecordDataSchema.Field FIELD_NativeResults = SCHEMA.getField("nativeResults");
    private static final RecordDataSchema.Field FIELD_ExternalUrl = SCHEMA.getField("externalUrl");
    private static final RecordDataSchema.Field FIELD_Error = SCHEMA.getField("error");

    public AssertionResult() {
        super(new DataMap(11, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public AssertionResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public AssertionResultType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionResultType.class, AssertionResultType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AssertionResultType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionResultType.class, AssertionResultType.$UNKNOWN);
        return this._typeField;
    }

    public AssertionResult setType(@Nullable AssertionResultType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.assertion.AssertionResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public AssertionResult setType(@Nonnull AssertionResultType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.assertion.AssertionResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasRowCount() {
        if (this._rowCountField != null) {
            return true;
        }
        return this._map.containsKey("rowCount");
    }

    public void removeRowCount() {
        this._map.remove("rowCount");
    }

    @Nullable
    public Long getRowCount(GetMode mode) {
        return this.getRowCount();
    }

    @Nullable
    public Long getRowCount() {
        if (this._rowCountField != null) {
            return this._rowCountField;
        }
        Object __rawValue = this._map.get("rowCount");
        this._rowCountField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._rowCountField;
    }

    public AssertionResult setRowCount(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRowCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRowCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "rowCount", DataTemplateUtil.coerceLongInput(value));
                this._rowCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "rowCount", DataTemplateUtil.coerceLongInput(value));
                this._rowCountField = value;
            }
        }
        return this;
    }

    public AssertionResult setRowCount(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field rowCount of com.linkedin.assertion.AssertionResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "rowCount", DataTemplateUtil.coerceLongInput(value));
        this._rowCountField = value;
        return this;
    }

    public AssertionResult setRowCount(long value) {
        CheckedUtil.putWithoutChecking(this._map, "rowCount", DataTemplateUtil.coerceLongInput(value));
        this._rowCountField = value;
        return this;
    }

    public boolean hasMissingCount() {
        if (this._missingCountField != null) {
            return true;
        }
        return this._map.containsKey("missingCount");
    }

    public void removeMissingCount() {
        this._map.remove("missingCount");
    }

    @Nullable
    public Long getMissingCount(GetMode mode) {
        return this.getMissingCount();
    }

    @Nullable
    public Long getMissingCount() {
        if (this._missingCountField != null) {
            return this._missingCountField;
        }
        Object __rawValue = this._map.get("missingCount");
        this._missingCountField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._missingCountField;
    }

    public AssertionResult setMissingCount(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMissingCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMissingCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "missingCount", DataTemplateUtil.coerceLongInput(value));
                this._missingCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "missingCount", DataTemplateUtil.coerceLongInput(value));
                this._missingCountField = value;
            }
        }
        return this;
    }

    public AssertionResult setMissingCount(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field missingCount of com.linkedin.assertion.AssertionResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "missingCount", DataTemplateUtil.coerceLongInput(value));
        this._missingCountField = value;
        return this;
    }

    public AssertionResult setMissingCount(long value) {
        CheckedUtil.putWithoutChecking(this._map, "missingCount", DataTemplateUtil.coerceLongInput(value));
        this._missingCountField = value;
        return this;
    }

    public boolean hasUnexpectedCount() {
        if (this._unexpectedCountField != null) {
            return true;
        }
        return this._map.containsKey("unexpectedCount");
    }

    public void removeUnexpectedCount() {
        this._map.remove("unexpectedCount");
    }

    @Nullable
    public Long getUnexpectedCount(GetMode mode) {
        return this.getUnexpectedCount();
    }

    @Nullable
    public Long getUnexpectedCount() {
        if (this._unexpectedCountField != null) {
            return this._unexpectedCountField;
        }
        Object __rawValue = this._map.get("unexpectedCount");
        this._unexpectedCountField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._unexpectedCountField;
    }

    public AssertionResult setUnexpectedCount(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUnexpectedCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUnexpectedCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "unexpectedCount", DataTemplateUtil.coerceLongInput(value));
                this._unexpectedCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "unexpectedCount", DataTemplateUtil.coerceLongInput(value));
                this._unexpectedCountField = value;
            }
        }
        return this;
    }

    public AssertionResult setUnexpectedCount(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field unexpectedCount of com.linkedin.assertion.AssertionResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "unexpectedCount", DataTemplateUtil.coerceLongInput(value));
        this._unexpectedCountField = value;
        return this;
    }

    public AssertionResult setUnexpectedCount(long value) {
        CheckedUtil.putWithoutChecking(this._map, "unexpectedCount", DataTemplateUtil.coerceLongInput(value));
        this._unexpectedCountField = value;
        return this;
    }

    public boolean hasActualAggValue() {
        if (this._actualAggValueField != null) {
            return true;
        }
        return this._map.containsKey("actualAggValue");
    }

    public void removeActualAggValue() {
        this._map.remove("actualAggValue");
    }

    @Nullable
    public Float getActualAggValue(GetMode mode) {
        return this.getActualAggValue();
    }

    @Nullable
    public Float getActualAggValue() {
        if (this._actualAggValueField != null) {
            return this._actualAggValueField;
        }
        Object __rawValue = this._map.get("actualAggValue");
        this._actualAggValueField = DataTemplateUtil.coerceFloatOutput(__rawValue);
        return this._actualAggValueField;
    }

    public AssertionResult setActualAggValue(@Nullable Float value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActualAggValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActualAggValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "actualAggValue", DataTemplateUtil.coerceFloatInput(value));
                this._actualAggValueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "actualAggValue", DataTemplateUtil.coerceFloatInput(value));
                this._actualAggValueField = value;
            }
        }
        return this;
    }

    public AssertionResult setActualAggValue(@Nonnull Float value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field actualAggValue of com.linkedin.assertion.AssertionResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "actualAggValue", DataTemplateUtil.coerceFloatInput(value));
        this._actualAggValueField = value;
        return this;
    }

    public AssertionResult setActualAggValue(float value) {
        CheckedUtil.putWithoutChecking(this._map, "actualAggValue", DataTemplateUtil.coerceFloatInput(Float.valueOf(value)));
        this._actualAggValueField = Float.valueOf(value);
        return this;
    }

    public boolean hasNativeResults() {
        if (this._nativeResultsField != null) {
            return true;
        }
        return this._map.containsKey("nativeResults");
    }

    public void removeNativeResults() {
        this._map.remove("nativeResults");
    }

    @Nullable
    public StringMap getNativeResults(GetMode mode) {
        return this.getNativeResults();
    }

    @Nullable
    public StringMap getNativeResults() {
        if (this._nativeResultsField != null) {
            return this._nativeResultsField;
        }
        Object __rawValue = this._map.get("nativeResults");
        this._nativeResultsField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._nativeResultsField;
    }

    public AssertionResult setNativeResults(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNativeResults(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNativeResults();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "nativeResults", value.data());
                this._nativeResultsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "nativeResults", value.data());
                this._nativeResultsField = value;
            }
        }
        return this;
    }

    public AssertionResult setNativeResults(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field nativeResults of com.linkedin.assertion.AssertionResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "nativeResults", value.data());
        this._nativeResultsField = value;
        return this;
    }

    public boolean hasExternalUrl() {
        if (this._externalUrlField != null) {
            return true;
        }
        return this._map.containsKey("externalUrl");
    }

    public void removeExternalUrl() {
        this._map.remove("externalUrl");
    }

    @Nullable
    public String getExternalUrl(GetMode mode) {
        return this.getExternalUrl();
    }

    @Nullable
    public String getExternalUrl() {
        if (this._externalUrlField != null) {
            return this._externalUrlField;
        }
        Object __rawValue = this._map.get("externalUrl");
        this._externalUrlField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._externalUrlField;
    }

    public AssertionResult setExternalUrl(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", value);
                this._externalUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", value);
                this._externalUrlField = value;
            }
        }
        return this;
    }

    public AssertionResult setExternalUrl(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalUrl of com.linkedin.assertion.AssertionResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalUrl", value);
        this._externalUrlField = value;
        return this;
    }

    public boolean hasError() {
        if (this._errorField != null) {
            return true;
        }
        return this._map.containsKey("error");
    }

    public void removeError() {
        this._map.remove("error");
    }

    @Nullable
    public AssertionResultError getError(GetMode mode) {
        return this.getError();
    }

    @Nullable
    public AssertionResultError getError() {
        if (this._errorField != null) {
            return this._errorField;
        }
        Object __rawValue = this._map.get("error");
        this._errorField = __rawValue == null ? null : new AssertionResultError(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._errorField;
    }

    public AssertionResult setError(@Nullable AssertionResultError value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setError(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeError();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "error", value.data());
                this._errorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "error", value.data());
                this._errorField = value;
            }
        }
        return this;
    }

    public AssertionResult setError(@Nonnull AssertionResultError value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field error of com.linkedin.assertion.AssertionResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "error", value.data());
        this._errorField = value;
        return this;
    }

    @Override
    public AssertionResult clone() throws CloneNotSupportedException {
        AssertionResult __clone = (AssertionResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AssertionResult copy() throws CloneNotSupportedException {
        AssertionResult __copy = (AssertionResult)super.copy();
        __copy._externalUrlField = null;
        __copy._missingCountField = null;
        __copy._actualAggValueField = null;
        __copy._rowCountField = null;
        __copy._typeField = null;
        __copy._errorField = null;
        __copy._nativeResultsField = null;
        __copy._unexpectedCountField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AssertionResult __objectRef;

        private ChangeListener(AssertionResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "externalUrl": {
                    this.__objectRef._externalUrlField = null;
                    break;
                }
                case "missingCount": {
                    this.__objectRef._missingCountField = null;
                    break;
                }
                case "actualAggValue": {
                    this.__objectRef._actualAggValueField = null;
                    break;
                }
                case "rowCount": {
                    this.__objectRef._rowCountField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "error": {
                    this.__objectRef._errorField = null;
                    break;
                }
                case "nativeResults": {
                    this.__objectRef._nativeResultsField = null;
                    break;
                }
                case "unexpectedCount": {
                    this.__objectRef._unexpectedCountField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec rowCount() {
            return new PathSpec(this.getPathComponents(), "rowCount");
        }

        public PathSpec missingCount() {
            return new PathSpec(this.getPathComponents(), "missingCount");
        }

        public PathSpec unexpectedCount() {
            return new PathSpec(this.getPathComponents(), "unexpectedCount");
        }

        public PathSpec actualAggValue() {
            return new PathSpec(this.getPathComponents(), "actualAggValue");
        }

        public PathSpec nativeResults() {
            return new PathSpec(this.getPathComponents(), "nativeResults");
        }

        public PathSpec externalUrl() {
            return new PathSpec(this.getPathComponents(), "externalUrl");
        }

        public AssertionResultError.Fields error() {
            return new AssertionResultError.Fields(this.getPathComponents(), "error");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AssertionResultError.ProjectionMask _errorMask;

        ProjectionMask() {
            super(11);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withRowCount() {
            this.getDataMap().put("rowCount", 1);
            return this;
        }

        public ProjectionMask withMissingCount() {
            this.getDataMap().put("missingCount", 1);
            return this;
        }

        public ProjectionMask withUnexpectedCount() {
            this.getDataMap().put("unexpectedCount", 1);
            return this;
        }

        public ProjectionMask withActualAggValue() {
            this.getDataMap().put("actualAggValue", 1);
            return this;
        }

        public ProjectionMask withNativeResults() {
            this.getDataMap().put("nativeResults", 1);
            return this;
        }

        public ProjectionMask withExternalUrl() {
            this.getDataMap().put("externalUrl", 1);
            return this;
        }

        public ProjectionMask withError(Function<AssertionResultError.ProjectionMask, AssertionResultError.ProjectionMask> nestedMask) {
            this._errorMask = nestedMask.apply(this._errorMask == null ? AssertionResultError.createMask() : this._errorMask);
            this.getDataMap().put("error", this._errorMask.getDataMap());
            return this;
        }

        public ProjectionMask withError() {
            this._errorMask = null;
            this.getDataMap().put("error", 1);
            return this;
        }
    }
}

