/*
 * Decompiled with CFR 0.152.
 */
package datahub.shaded.jackson.databind.ext;

import datahub.shaded.jackson.core.JsonGenerator;
import datahub.shaded.jackson.core.JsonToken;
import datahub.shaded.jackson.core.type.WritableTypeId;
import datahub.shaded.jackson.databind.SerializerProvider;
import datahub.shaded.jackson.databind.jsontype.TypeSerializer;
import datahub.shaded.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.nio.file.Path;

public class NioPathSerializer
extends StdScalarSerializer<Path> {
    private static final long serialVersionUID = 1L;

    public NioPathSerializer() {
        super(Path.class);
    }

    @Override
    public void serialize(Path value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeString(value.toUri().toString());
    }

    @Override
    public void serializeWithType(Path value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId((Object)value, Path.class, JsonToken.VALUE_STRING));
        this.serialize(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }
}

