/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util;

import com.linkedin.data.schema.DataSchema;
import java.util.Map;

public class CustomTypeUtil {
    public static final String JAVA_PROPERTY = "java";
    public static final String CLASS_PROPERTY = "class";
    public static final String COERCER_CLASS_PROPERTY = "coercerClass";

    public static String getJavaCustomTypeClassNameFromSchema(DataSchema schema) {
        Object o = schema.getProperties().get(JAVA_PROPERTY);
        if (o == null || !(o instanceof Map)) {
            return null;
        }
        Map map = (Map)o;
        Object o2 = map.get(CLASS_PROPERTY);
        if (o2 == null || !(o2 instanceof String)) {
            return null;
        }
        return (String)o2;
    }

    public static Class<?> getJavaCustomTypeClassFromSchema(DataSchema schema) {
        String javaCoercerClassName = CustomTypeUtil.getJavaCustomTypeClassNameFromSchema(schema);
        if (javaCoercerClassName != null) {
            try {
                return Class.forName(javaCoercerClassName, false, CustomTypeUtil.class.getClassLoader());
            }
            catch (ClassNotFoundException | SecurityException e) {
                return CustomTypeUtil.getBindingClass(javaCoercerClassName, Thread.currentThread().getContextClassLoader(), schema);
            }
        }
        Class<?> bindingClass = null;
        return bindingClass;
    }

    public static String getJavaCoercerClassFromSchema(DataSchema schema) {
        Object o = schema.getProperties().get(JAVA_PROPERTY);
        if (o == null || !(o instanceof Map)) {
            return null;
        }
        Map map = (Map)o;
        Object o2 = map.get(COERCER_CLASS_PROPERTY);
        if (o2 == null || !(o2 instanceof String)) {
            return null;
        }
        return (String)o2;
    }

    private static Class<?> getBindingClass(String javaCoercerClassName, ClassLoader classLoader, DataSchema schema) {
        try {
            return Class.forName(javaCoercerClassName, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to find java coercer class of " + javaCoercerClassName + " for schema " + schema.getUnionMemberKey());
        }
    }
}

