/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.operations;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.operations.OperationsAggregationArray;
import com.linkedin.operations.OperationsAggregationsResult;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OperationsQueryResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.operations/**Results of a query for operations data.*/record OperationsQueryResult{/** Raw buckets */buckets:optional array[/**Operations data for a given resource, rolled up into a bucket.*/record OperationsAggregation{/** Bucket start time in milliseconds */bucket:long/** Bucket duration */duration:{namespace com.linkedin.common/**Enum to define the length of a bucket when doing aggregations*/enum WindowDuration{YEAR,MONTH,WEEK,DAY,HOUR}}/** Resource associated with these usage stats */resource:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/** Aggregations associated with this bucket */aggregations:/**Aggregation results for operations query*/record OperationsAggregationsResult{/** Total number of operations in the bucket */totalOperations:optional int/** Total number of inserts in the bucket */totalInserts:optional int/** Total number of updates in the bucket */totalUpdates:optional int/** Total number of deletes in the bucket */totalDeletes:optional int/** Total number of creates in the bucket */totalCreates:optional int/** Total number of alters in the bucket */totalAlters:optional int/** Total number of drops in the bucket */totalDrops:optional int/** Total number of custom types in the bucket */totalCustoms:optional int/** A map from each custom operation type to the total count for that type*/customOperationsMap:optional map[string,int]}}]/**Aggregated metrics. All fields are optional here, since they will be populated\nonly if the underlying buckets contain the data required to generate that aggregation.*/aggregations:OperationsAggregationsResult}", SchemaFormatType.PDL);
    private OperationsAggregationArray _bucketsField = null;
    private OperationsAggregationsResult _aggregationsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Buckets = SCHEMA.getField("buckets");
    private static final RecordDataSchema.Field FIELD_Aggregations = SCHEMA.getField("aggregations");

    public OperationsQueryResult() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public OperationsQueryResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasBuckets() {
        if (this._bucketsField != null) {
            return true;
        }
        return this._map.containsKey("buckets");
    }

    public void removeBuckets() {
        this._map.remove("buckets");
    }

    @Nullable
    public OperationsAggregationArray getBuckets(GetMode mode) {
        return this.getBuckets();
    }

    @Nullable
    public OperationsAggregationArray getBuckets() {
        if (this._bucketsField != null) {
            return this._bucketsField;
        }
        Object __rawValue = this._map.get("buckets");
        this._bucketsField = __rawValue == null ? null : new OperationsAggregationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._bucketsField;
    }

    public OperationsQueryResult setBuckets(@Nullable OperationsAggregationArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setBuckets(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeBuckets();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "buckets", value.data());
                this._bucketsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "buckets", value.data());
                this._bucketsField = value;
            }
        }
        return this;
    }

    public OperationsQueryResult setBuckets(@Nonnull OperationsAggregationArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field buckets of com.linkedin.operations.OperationsQueryResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "buckets", value.data());
        this._bucketsField = value;
        return this;
    }

    public boolean hasAggregations() {
        if (this._aggregationsField != null) {
            return true;
        }
        return this._map.containsKey("aggregations");
    }

    public void removeAggregations() {
        this._map.remove("aggregations");
    }

    @Nullable
    public OperationsAggregationsResult getAggregations(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAggregations();
            }
            case DEFAULT: 
            case NULL: {
                if (this._aggregationsField != null) {
                    return this._aggregationsField;
                }
                Object __rawValue = this._map.get("aggregations");
                this._aggregationsField = __rawValue == null ? null : new OperationsAggregationsResult(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._aggregationsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public OperationsAggregationsResult getAggregations() {
        if (this._aggregationsField != null) {
            return this._aggregationsField;
        }
        Object __rawValue = this._map.get("aggregations");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("aggregations");
        }
        this._aggregationsField = __rawValue == null ? null : new OperationsAggregationsResult(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._aggregationsField;
    }

    public OperationsQueryResult setAggregations(@Nullable OperationsAggregationsResult value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAggregations(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aggregations of com.linkedin.operations.OperationsQueryResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAggregations();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
            }
        }
        return this;
    }

    public OperationsQueryResult setAggregations(@Nonnull OperationsAggregationsResult value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aggregations of com.linkedin.operations.OperationsQueryResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
        this._aggregationsField = value;
        return this;
    }

    @Override
    public OperationsQueryResult clone() throws CloneNotSupportedException {
        OperationsQueryResult __clone = (OperationsQueryResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public OperationsQueryResult copy() throws CloneNotSupportedException {
        OperationsQueryResult __copy = (OperationsQueryResult)super.copy();
        __copy._bucketsField = null;
        __copy._aggregationsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final OperationsQueryResult __objectRef;

        private ChangeListener(OperationsQueryResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "buckets": {
                    this.__objectRef._bucketsField = null;
                    break;
                }
                case "aggregations": {
                    this.__objectRef._aggregationsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public OperationsAggregationArray.Fields buckets() {
            return new OperationsAggregationArray.Fields(this.getPathComponents(), "buckets");
        }

        public PathSpec buckets(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "buckets");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public OperationsAggregationsResult.Fields aggregations() {
            return new OperationsAggregationsResult.Fields(this.getPathComponents(), "aggregations");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private OperationsAggregationArray.ProjectionMask _bucketsMask;
        private OperationsAggregationsResult.ProjectionMask _aggregationsMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withBuckets(Function<OperationsAggregationArray.ProjectionMask, OperationsAggregationArray.ProjectionMask> nestedMask) {
            this._bucketsMask = nestedMask.apply(this._bucketsMask == null ? OperationsAggregationArray.createMask() : this._bucketsMask);
            this.getDataMap().put("buckets", this._bucketsMask.getDataMap());
            return this;
        }

        public ProjectionMask withBuckets() {
            this._bucketsMask = null;
            this.getDataMap().put("buckets", 1);
            return this;
        }

        public ProjectionMask withBuckets(Function<OperationsAggregationArray.ProjectionMask, OperationsAggregationArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._bucketsMask = nestedMask.apply(this._bucketsMask == null ? OperationsAggregationArray.createMask() : this._bucketsMask);
            this.getDataMap().put("buckets", this._bucketsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("buckets").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("buckets").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withBuckets(Integer start, Integer count) {
            this._bucketsMask = null;
            this.getDataMap().put("buckets", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("buckets").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("buckets").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAggregations(Function<OperationsAggregationsResult.ProjectionMask, OperationsAggregationsResult.ProjectionMask> nestedMask) {
            this._aggregationsMask = nestedMask.apply(this._aggregationsMask == null ? OperationsAggregationsResult.createMask() : this._aggregationsMask);
            this.getDataMap().put("aggregations", this._aggregationsMask.getDataMap());
            return this;
        }

        public ProjectionMask withAggregations() {
            this._aggregationsMask = null;
            this.getDataMap().put("aggregations", 1);
            return this;
        }
    }
}

