/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.module;

import com.linkedin.common.AuditStamp;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.module.DataHubPageModuleParams;
import com.linkedin.module.DataHubPageModuleType;
import com.linkedin.module.DataHubPageModuleVisibility;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubPageModuleProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.module/**The main properties of a DataHub page module*/@Aspect.name=\"dataHubPageModuleProperties\"record DataHubPageModuleProperties{/**The display name of this module*/name:string/**The type of this module - the purpose it serves*/@Searchable.fieldType=\"KEYWORD\"type:/**Enum containing the types of page modules that there are*/enum DataHubPageModuleType{/**Link type module*/LINK/**Module containing rich text to be rendered*/RICH_TEXT/**A module with a collection of assets*/ASSET_COLLECTION/**A module displaying a hierarchy to navigate*/HIERARCHY/**Module displaying assets owned by a user*/OWNED_ASSETS/**Module displaying the top domains*/DOMAINS/**Module displaying the assets of parent entity*/ASSETS/**Module displaying the hierarchy of the children of a given entity. Glossary or Domains.*/CHILD_HIERARCHY/**Module displaying child data products of a given domain*/DATA_PRODUCTS/**Module displaying the related terms of a given glossary term*/RELATED_TERMS/**Module displaying the platforms in an instance*/PLATFORMS}/**Info about the visibility of this module*/visibility:/**Info about the visibility of this module*/record DataHubPageModuleVisibility{/**Audit stamp for when and by whom this module was created*/@Searchable.fieldType=\"KEYWORD\"scope:enum PageModuleScope{/**This module is used for individual use only*/PERSONAL/**This module is discoverable and can be used by any user on the platform*/GLOBAL}}/**The specific parameters stored for this module*/params:/**The specific parameters stored for a module*/record DataHubPageModuleParams{/**The params required if the module is type LINK*/linkParams:optional record LinkModuleParams{linkUrl:string,imageUrl:optional string,description:optional string}/**The params required if the module is type RICH_TEXT*/richTextParams:optional record RichTextModuleParams{content:string}/**The params required if the module is type ASSET_COLLECTION*/assetCollectionParams:optional/**The params required if the module is type ASSET_COLLECTION*/record AssetCollectionModuleParams{assetUrns:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**Optional dynamic filters\n\nThe stringified json representing the logical predicate built in the UI to select assets.\nThis predicate is turned into orFilters to send through graphql since graphql doesn't support\narbitrary nesting. This string is used to restore the UI for this logical predicate.*/dynamicFilterJson:optional string}/**The params required if the module is type HIERARCHY_VIEW*/hierarchyViewParams:optional/**The params required if the module is type HIERARCHY_VIEW*/record HierarchyModuleParams{assetUrns:optional array[com.linkedin.common.Urn]showRelatedEntities:boolean/**Optional filters to filter relatedEntities (assetUrns) out\n\nThe stringified json representing the logical predicate built in the UI to select assets.\nThis predicate is turned into orFilters to send through graphql since graphql doesn't support\narbitrary nesting. This string is used to restore the UI for this logical predicate.*/relatedEntitiesFilterJson:optional string}}/**Audit stamp for when and by whom this template was created*/@Searchable={\"/actor\":{\"fieldName\":\"createdBy\",\"fieldType\":\"URN\"},\"/time\":{\"fieldName\":\"createdAt\",\"fieldType\":\"DATETIME\"}}created:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**Audit stamp for when and by whom this template was last updated*/@Searchable.`/time`={\"fieldName\":\"lastModifiedAt\",\"fieldType\":\"DATETIME\"}lastModified:com.linkedin.common.AuditStamp}", SchemaFormatType.PDL);
    private String _nameField = null;
    private DataHubPageModuleType _typeField = null;
    private DataHubPageModuleVisibility _visibilityField = null;
    private DataHubPageModuleParams _paramsField = null;
    private AuditStamp _createdField = null;
    private AuditStamp _lastModifiedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Visibility = SCHEMA.getField("visibility");
    private static final RecordDataSchema.Field FIELD_Params = SCHEMA.getField("params");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final RecordDataSchema.Field FIELD_LastModified = SCHEMA.getField("lastModified");

    public DataHubPageModuleProperties() {
        super(new DataMap(8, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubPageModuleProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public DataHubPageModuleProperties setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.module.DataHubPageModuleProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public DataHubPageModuleProperties setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.module.DataHubPageModuleProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public DataHubPageModuleType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, DataHubPageModuleType.class, DataHubPageModuleType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataHubPageModuleType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, DataHubPageModuleType.class, DataHubPageModuleType.$UNKNOWN);
        return this._typeField;
    }

    public DataHubPageModuleProperties setType(@Nullable DataHubPageModuleType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.module.DataHubPageModuleProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public DataHubPageModuleProperties setType(@Nonnull DataHubPageModuleType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.module.DataHubPageModuleProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasVisibility() {
        if (this._visibilityField != null) {
            return true;
        }
        return this._map.containsKey("visibility");
    }

    public void removeVisibility() {
        this._map.remove("visibility");
    }

    @Nullable
    public DataHubPageModuleVisibility getVisibility(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getVisibility();
            }
            case DEFAULT: 
            case NULL: {
                if (this._visibilityField != null) {
                    return this._visibilityField;
                }
                Object __rawValue = this._map.get("visibility");
                this._visibilityField = __rawValue == null ? null : new DataHubPageModuleVisibility(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._visibilityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataHubPageModuleVisibility getVisibility() {
        if (this._visibilityField != null) {
            return this._visibilityField;
        }
        Object __rawValue = this._map.get("visibility");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("visibility");
        }
        this._visibilityField = __rawValue == null ? null : new DataHubPageModuleVisibility(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._visibilityField;
    }

    public DataHubPageModuleProperties setVisibility(@Nullable DataHubPageModuleVisibility value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVisibility(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field visibility of com.linkedin.module.DataHubPageModuleProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "visibility", value.data());
                this._visibilityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVisibility();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "visibility", value.data());
                this._visibilityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "visibility", value.data());
                this._visibilityField = value;
            }
        }
        return this;
    }

    public DataHubPageModuleProperties setVisibility(@Nonnull DataHubPageModuleVisibility value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field visibility of com.linkedin.module.DataHubPageModuleProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "visibility", value.data());
        this._visibilityField = value;
        return this;
    }

    public boolean hasParams() {
        if (this._paramsField != null) {
            return true;
        }
        return this._map.containsKey("params");
    }

    public void removeParams() {
        this._map.remove("params");
    }

    @Nullable
    public DataHubPageModuleParams getParams(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getParams();
            }
            case DEFAULT: 
            case NULL: {
                if (this._paramsField != null) {
                    return this._paramsField;
                }
                Object __rawValue = this._map.get("params");
                this._paramsField = __rawValue == null ? null : new DataHubPageModuleParams(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._paramsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataHubPageModuleParams getParams() {
        if (this._paramsField != null) {
            return this._paramsField;
        }
        Object __rawValue = this._map.get("params");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("params");
        }
        this._paramsField = __rawValue == null ? null : new DataHubPageModuleParams(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._paramsField;
    }

    public DataHubPageModuleProperties setParams(@Nullable DataHubPageModuleParams value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParams(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field params of com.linkedin.module.DataHubPageModuleProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "params", value.data());
                this._paramsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParams();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "params", value.data());
                this._paramsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "params", value.data());
                this._paramsField = value;
            }
        }
        return this;
    }

    public DataHubPageModuleProperties setParams(@Nonnull DataHubPageModuleParams value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field params of com.linkedin.module.DataHubPageModuleProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "params", value.data());
        this._paramsField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreated();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("created");
        }
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public DataHubPageModuleProperties setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.module.DataHubPageModuleProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public DataHubPageModuleProperties setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.module.DataHubPageModuleProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getLastModified();
            }
            case DEFAULT: 
            case NULL: {
                if (this._lastModifiedField != null) {
                    return this._lastModifiedField;
                }
                Object __rawValue = this._map.get("lastModified");
                this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._lastModifiedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("lastModified");
        }
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public DataHubPageModuleProperties setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field lastModified of com.linkedin.module.DataHubPageModuleProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public DataHubPageModuleProperties setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.module.DataHubPageModuleProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    @Override
    public DataHubPageModuleProperties clone() throws CloneNotSupportedException {
        DataHubPageModuleProperties __clone = (DataHubPageModuleProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubPageModuleProperties copy() throws CloneNotSupportedException {
        DataHubPageModuleProperties __copy = (DataHubPageModuleProperties)super.copy();
        __copy._visibilityField = null;
        __copy._createdField = null;
        __copy._nameField = null;
        __copy._lastModifiedField = null;
        __copy._typeField = null;
        __copy._paramsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubPageModuleProperties __objectRef;

        private ChangeListener(DataHubPageModuleProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "visibility": {
                    this.__objectRef._visibilityField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "params": {
                    this.__objectRef._paramsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public DataHubPageModuleVisibility.Fields visibility() {
            return new DataHubPageModuleVisibility.Fields(this.getPathComponents(), "visibility");
        }

        public DataHubPageModuleParams.Fields params() {
            return new DataHubPageModuleParams.Fields(this.getPathComponents(), "params");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DataHubPageModuleVisibility.ProjectionMask _visibilityMask;
        private DataHubPageModuleParams.ProjectionMask _paramsMask;
        private AuditStamp.ProjectionMask _createdMask;
        private AuditStamp.ProjectionMask _lastModifiedMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withVisibility(Function<DataHubPageModuleVisibility.ProjectionMask, DataHubPageModuleVisibility.ProjectionMask> nestedMask) {
            this._visibilityMask = nestedMask.apply(this._visibilityMask == null ? DataHubPageModuleVisibility.createMask() : this._visibilityMask);
            this.getDataMap().put("visibility", this._visibilityMask.getDataMap());
            return this;
        }

        public ProjectionMask withVisibility() {
            this._visibilityMask = null;
            this.getDataMap().put("visibility", 1);
            return this;
        }

        public ProjectionMask withParams(Function<DataHubPageModuleParams.ProjectionMask, DataHubPageModuleParams.ProjectionMask> nestedMask) {
            this._paramsMask = nestedMask.apply(this._paramsMask == null ? DataHubPageModuleParams.createMask() : this._paramsMask);
            this.getDataMap().put("params", this._paramsMask.getDataMap());
            return this;
        }

        public ProjectionMask withParams() {
            this._paramsMask = null;
            this.getDataMap().put("params", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }
    }
}

