/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import com.linkedin.common.urn.Urn;
import com.linkedin.form.FormActorAssignment;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class FormUtils {
    private FormUtils() {
    }

    public static boolean isFormAssignedToUser(@Nonnull FormActorAssignment parent, @Nonnull Urn userUrn, @Nonnull List<Urn> groupUrns) {
        boolean isUserGroupAssigned;
        boolean isUserAssigned;
        Set assignedGroupUrns;
        Set assignedUserUrns = parent.getUsers() != null ? parent.getUsers().stream().map(Urn::toString).collect(Collectors.toSet()) : Collections.emptySet();
        Set set = assignedGroupUrns = parent.getGroups() != null ? parent.getGroups().stream().map(Urn::toString).collect(Collectors.toSet()) : Collections.emptySet();
        if (assignedUserUrns.size() > 0 && (isUserAssigned = assignedUserUrns.contains(userUrn.toString()))) {
            return true;
        }
        return assignedGroupUrns.size() > 0 && (isUserGroupAssigned = groupUrns.stream().anyMatch(groupUrn -> assignedGroupUrns.contains(groupUrn.toString())));
    }
}

