/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query.filter;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.query.filter.CriterionArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConjunctiveCriterion
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.query.filter/**A list of criterion and'd together.*/record ConjunctiveCriterion{/**A list of and criteria the filter applies to the query*/and:array[/**A criterion for matching a field with given value*/record Criterion{/**The name of the field that the criterion refers to*/field:string/**The value of the intended field*/value:string/**Values. one of which the intended field should match\nNote, if values is set, the above \"value\" field will be ignored*/values:array[string]=[]/**The condition for the criterion, e.g. EQUAL, START_WITH*/condition:/**The matching condition in a filter criterion*/enum Condition{/**Represent the relation: String field contains value, e.g. name contains Profile*/CONTAIN/**Represent the relation: String field ends with value, e.g. name ends with Event*/END_WITH/**Represent the relation: field = value, e.g. platform = hdfs*/EQUAL/**Represent the relation: field = value and support case insensitive values, e.g. platform = hdfs*/IEQUAL/**Represent the relation: field is null, e.g. platform is null*/IS_NULL/**Represents the relation: field exists and is non-empty, e.g. owners is not null and != [] (empty)*/EXISTS/**Represent the relation greater than, e.g. ownerCount > 5*/GREATER_THAN/**Represent the relation greater than or equal to, e.g. ownerCount >= 5*/GREATER_THAN_OR_EQUAL_TO/**Represent the relation: String field is one of the array values to, e.g. name in [\"Profile\", \"Event\"]*/IN/**Represent the relation less than, e.g. ownerCount < 3*/LESS_THAN/**Represent the relation less than or equal to, e.g. ownerCount <= 3*/LESS_THAN_OR_EQUAL_TO/**Represent the relation: String field starts with value, e.g. name starts with PageView*/START_WITH/**Represent the relation: URN field any nested children in addition to the given URN*/DESCENDANTS_INCL/**Represent the relation: URN field matches any nested parent in addition to the given URN*/ANCESTORS_INCL/**Represent the relation: URN field matches any nested child or parent in addition to the given URN*/RELATED_INCL}=\"EQUAL\"/**Whether the condition should be negated*/negated:boolean=false}]}", SchemaFormatType.PDL);
    private CriterionArray _andField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_And = SCHEMA.getField("and");

    public ConjunctiveCriterion() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public ConjunctiveCriterion(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasAnd() {
        if (this._andField != null) {
            return true;
        }
        return this._map.containsKey("and");
    }

    public void removeAnd() {
        this._map.remove("and");
    }

    @Nullable
    public CriterionArray getAnd(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAnd();
            }
            case DEFAULT: 
            case NULL: {
                if (this._andField != null) {
                    return this._andField;
                }
                Object __rawValue = this._map.get("and");
                this._andField = __rawValue == null ? null : new CriterionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._andField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public CriterionArray getAnd() {
        if (this._andField != null) {
            return this._andField;
        }
        Object __rawValue = this._map.get("and");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("and");
        }
        this._andField = __rawValue == null ? null : new CriterionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._andField;
    }

    public ConjunctiveCriterion setAnd(@Nullable CriterionArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAnd(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field and of com.linkedin.metadata.query.filter.ConjunctiveCriterion");
                }
                CheckedUtil.putWithoutChecking(this._map, "and", value.data());
                this._andField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAnd();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "and", value.data());
                this._andField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "and", value.data());
                this._andField = value;
            }
        }
        return this;
    }

    public ConjunctiveCriterion setAnd(@Nonnull CriterionArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field and of com.linkedin.metadata.query.filter.ConjunctiveCriterion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "and", value.data());
        this._andField = value;
        return this;
    }

    @Override
    public ConjunctiveCriterion clone() throws CloneNotSupportedException {
        ConjunctiveCriterion __clone = (ConjunctiveCriterion)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ConjunctiveCriterion copy() throws CloneNotSupportedException {
        ConjunctiveCriterion __copy = (ConjunctiveCriterion)super.copy();
        __copy._andField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ConjunctiveCriterion __objectRef;

        private ChangeListener(ConjunctiveCriterion reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "and": {
                    this.__objectRef._andField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public CriterionArray.Fields and() {
            return new CriterionArray.Fields(this.getPathComponents(), "and");
        }

        public PathSpec and(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "and");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private CriterionArray.ProjectionMask _andMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withAnd(Function<CriterionArray.ProjectionMask, CriterionArray.ProjectionMask> nestedMask) {
            this._andMask = nestedMask.apply(this._andMask == null ? CriterionArray.createMask() : this._andMask);
            this.getDataMap().put("and", this._andMask.getDataMap());
            return this;
        }

        public ProjectionMask withAnd() {
            this._andMask = null;
            this.getDataMap().put("and", 1);
            return this;
        }

        public ProjectionMask withAnd(Function<CriterionArray.ProjectionMask, CriterionArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._andMask = nestedMask.apply(this._andMask == null ? CriterionArray.createMask() : this._andMask);
            this.getDataMap().put("and", this._andMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("and").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("and").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAnd(Integer start, Integer count) {
            this._andMask = null;
            this.getDataMap().put("and", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("and").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("and").put("$count", count);
            }
            return this;
        }
    }
}

