/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.query.ExtraInfoArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ListResultMetadata
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.query/**The additional metadata for a list result*/record ListResultMetadata{/**A list of extra information that positionally corresponds to the aspects returned from the list query*/extraInfos:array[/**Extra information associated to a metadata aspect.*/record ExtraInfo{/**The urn for the entity that owns the metadata aspect*/urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The version number of the metadata aspect.*/version:long/**The audit trail associated with the version*/audit:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}]}", SchemaFormatType.PDL);
    private ExtraInfoArray _extraInfosField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_ExtraInfos = SCHEMA.getField("extraInfos");

    public ListResultMetadata() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public ListResultMetadata(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasExtraInfos() {
        if (this._extraInfosField != null) {
            return true;
        }
        return this._map.containsKey("extraInfos");
    }

    public void removeExtraInfos() {
        this._map.remove("extraInfos");
    }

    @Nullable
    public ExtraInfoArray getExtraInfos(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getExtraInfos();
            }
            case DEFAULT: 
            case NULL: {
                if (this._extraInfosField != null) {
                    return this._extraInfosField;
                }
                Object __rawValue = this._map.get("extraInfos");
                this._extraInfosField = __rawValue == null ? null : new ExtraInfoArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._extraInfosField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public ExtraInfoArray getExtraInfos() {
        if (this._extraInfosField != null) {
            return this._extraInfosField;
        }
        Object __rawValue = this._map.get("extraInfos");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("extraInfos");
        }
        this._extraInfosField = __rawValue == null ? null : new ExtraInfoArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._extraInfosField;
    }

    public ListResultMetadata setExtraInfos(@Nullable ExtraInfoArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExtraInfos(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field extraInfos of com.linkedin.metadata.query.ListResultMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "extraInfos", value.data());
                this._extraInfosField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExtraInfos();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "extraInfos", value.data());
                this._extraInfosField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "extraInfos", value.data());
                this._extraInfosField = value;
            }
        }
        return this;
    }

    public ListResultMetadata setExtraInfos(@Nonnull ExtraInfoArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field extraInfos of com.linkedin.metadata.query.ListResultMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "extraInfos", value.data());
        this._extraInfosField = value;
        return this;
    }

    @Override
    public ListResultMetadata clone() throws CloneNotSupportedException {
        ListResultMetadata __clone = (ListResultMetadata)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ListResultMetadata copy() throws CloneNotSupportedException {
        ListResultMetadata __copy = (ListResultMetadata)super.copy();
        __copy._extraInfosField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ListResultMetadata __objectRef;

        private ChangeListener(ListResultMetadata reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "extraInfos": {
                    this.__objectRef._extraInfosField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public ExtraInfoArray.Fields extraInfos() {
            return new ExtraInfoArray.Fields(this.getPathComponents(), "extraInfos");
        }

        public PathSpec extraInfos(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "extraInfos");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private ExtraInfoArray.ProjectionMask _extraInfosMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withExtraInfos(Function<ExtraInfoArray.ProjectionMask, ExtraInfoArray.ProjectionMask> nestedMask) {
            this._extraInfosMask = nestedMask.apply(this._extraInfosMask == null ? ExtraInfoArray.createMask() : this._extraInfosMask);
            this.getDataMap().put("extraInfos", this._extraInfosMask.getDataMap());
            return this;
        }

        public ProjectionMask withExtraInfos() {
            this._extraInfosMask = null;
            this.getDataMap().put("extraInfos", 1);
            return this;
        }

        public ProjectionMask withExtraInfos(Function<ExtraInfoArray.ProjectionMask, ExtraInfoArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._extraInfosMask = nestedMask.apply(this._extraInfosMask == null ? ExtraInfoArray.createMask() : this._extraInfosMask);
            this.getDataMap().put("extraInfos", this._extraInfosMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("extraInfos").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("extraInfos").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withExtraInfos(Integer start, Integer count) {
            this._extraInfosMask = null;
            this.getDataMap().put("extraInfos", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("extraInfos").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("extraInfos").put("$count", count);
            }
            return this;
        }
    }
}

