/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.registry;

import com.linkedin.data.schema.compatibility.CompatibilityChecker;
import com.linkedin.data.schema.compatibility.CompatibilityOptions;
import com.linkedin.data.schema.compatibility.CompatibilityResult;
import com.linkedin.metadata.aspect.patch.template.AspectTemplateEngine;
import com.linkedin.metadata.aspect.plugins.PluginFactory;
import com.linkedin.metadata.aspect.plugins.config.PluginConfiguration;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.ConfigEntitySpec;
import com.linkedin.metadata.models.DefaultEntitySpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.EventSpec;
import com.linkedin.metadata.models.registry.ConfigEntityRegistry;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.models.registry.EntityRegistryException;
import com.linkedin.metadata.models.registry.PatchEntityRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedEntityRegistry
implements EntityRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MergedEntityRegistry.class);
    private final Map<String, EntitySpec> entityNameToSpec;
    private final Map<String, EventSpec> eventNameToSpec;
    private final AspectTemplateEngine _aspectTemplateEngine;
    private final Map<String, AspectSpec> _aspectNameToSpec;
    @Nonnull
    private PluginFactory pluginFactory;
    @Nullable
    private BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider;

    public MergedEntityRegistry(EntityRegistry baseEntityRegistry) {
        this.entityNameToSpec = baseEntityRegistry.getEntitySpecs() != null ? new HashMap<String, EntitySpec>(baseEntityRegistry.getEntitySpecs()) : new HashMap();
        this.eventNameToSpec = baseEntityRegistry.getEventSpecs() != null ? new HashMap<String, EventSpec>(baseEntityRegistry.getEventSpecs()) : new HashMap();
        baseEntityRegistry.getAspectTemplateEngine();
        this._aspectTemplateEngine = baseEntityRegistry.getAspectTemplateEngine();
        this._aspectNameToSpec = baseEntityRegistry.getAspectSpecs();
        this.pluginFactory = baseEntityRegistry instanceof ConfigEntityRegistry ? ((ConfigEntityRegistry)baseEntityRegistry).getPluginFactory() : (baseEntityRegistry instanceof PatchEntityRegistry ? ((PatchEntityRegistry)baseEntityRegistry).getPluginFactory() : PluginFactory.empty());
        this.pluginFactoryProvider = baseEntityRegistry.getPluginFactoryProvider();
    }

    private void validateEntitySpec(EntitySpec entitySpec, ValidationResult validationResult) {
        if (entitySpec.getKeyAspectSpec() == null) {
            validationResult.setValid(false);
            validationResult.getValidationFailures().add(String.format("Key aspect is missing in entity %s", entitySpec.getName()));
        }
    }

    public MergedEntityRegistry apply(EntityRegistry patchEntityRegistry) throws EntityRegistryException {
        ValidationResult validationResult = this.validatePatch(patchEntityRegistry);
        if (!validationResult.isValid()) {
            throw new EntityRegistryException(String.format("Failed to validate new registry with %s", validationResult.validationFailures.stream().collect(Collectors.joining("\n"))));
        }
        if (!patchEntityRegistry.getAspectSpecs().isEmpty()) {
            this._aspectNameToSpec.putAll(patchEntityRegistry.getAspectSpecs());
        }
        for (Map.Entry<String, EntitySpec> e2Entry : patchEntityRegistry.getEntitySpecs().entrySet()) {
            if (this.entityNameToSpec.containsKey(e2Entry.getKey())) {
                EntitySpec mergeEntitySpec = this.mergeEntitySpecs(this.entityNameToSpec.get(e2Entry.getKey()), e2Entry.getValue());
                this.entityNameToSpec.put(e2Entry.getKey(), mergeEntitySpec);
                continue;
            }
            this.entityNameToSpec.put(e2Entry.getKey(), e2Entry.getValue());
        }
        if (!patchEntityRegistry.getEventSpecs().isEmpty()) {
            this.eventNameToSpec.putAll(patchEntityRegistry.getEventSpecs());
        }
        this.pluginFactory = PluginFactory.merge(this.pluginFactory, patchEntityRegistry.getPluginFactory(), this.pluginFactoryProvider);
        return this;
    }

    private ValidationResult validatePatch(EntityRegistry patchEntityRegistry) {
        ValidationResult validationResult = new ValidationResult();
        for (Map.Entry<String, EntitySpec> e2Entry : patchEntityRegistry.getEntitySpecs().entrySet()) {
            this.checkMergeable(this.entityNameToSpec.getOrDefault(e2Entry.getKey(), null), e2Entry.getValue(), validationResult);
        }
        return validationResult;
    }

    private void checkMergeable(EntitySpec existingEntitySpec, EntitySpec newEntitySpec, ValidationResult validationResult) {
        if (existingEntitySpec != null) {
            existingEntitySpec.getAspectSpecMap().forEach((key, value) -> {
                if (newEntitySpec.hasAspect((String)key).booleanValue()) {
                    CompatibilityResult result = CompatibilityChecker.checkCompatibility(value.getPegasusSchema(), newEntitySpec.getAspectSpec((String)key).getPegasusSchema(), new CompatibilityOptions());
                    if (result.isError()) {
                        log.error("{} schema is not compatible with previous schema due to {}", key, (Object)result.getMessages());
                        validationResult.setValid(false);
                        validationResult.getValidationFailures().add(String.format("%s schema is not compatible with previous schema due to %s", key, result.getMessages()));
                    } else {
                        log.info("{} schema is compatible with previous schema due to {}", key, (Object)result.getMessages());
                    }
                }
            });
        } else {
            this.validateEntitySpec(newEntitySpec, validationResult);
        }
    }

    private EntitySpec mergeEntitySpecs(EntitySpec existingEntitySpec, EntitySpec newEntitySpec) {
        HashMap<String, AspectSpec> aspectSpecMap = new HashMap<String, AspectSpec>(existingEntitySpec.getAspectSpecMap());
        aspectSpecMap.putAll(newEntitySpec.getAspectSpecMap());
        if (existingEntitySpec instanceof ConfigEntitySpec) {
            return new ConfigEntitySpec(existingEntitySpec.getEntityAnnotation().getName(), existingEntitySpec.getEntityAnnotation().getKeyAspect(), aspectSpecMap.values());
        }
        return new DefaultEntitySpec(aspectSpecMap.values(), existingEntitySpec.getEntityAnnotation(), existingEntitySpec.getSnapshotSchema(), existingEntitySpec.getAspectTyperefSchema());
    }

    @Override
    @Nonnull
    public EntitySpec getEntitySpec(@Nonnull String entityName) {
        String lowercaseEntityName = entityName.toLowerCase();
        if (!this.entityNameToSpec.containsKey(lowercaseEntityName)) {
            throw new IllegalArgumentException(String.format("Failed to find entity with name %s in EntityRegistry", entityName));
        }
        return this.entityNameToSpec.get(lowercaseEntityName);
    }

    @Override
    @Nonnull
    public EventSpec getEventSpec(@Nonnull String eventName) {
        String lowercaseEventSpec = eventName.toLowerCase();
        if (!this.eventNameToSpec.containsKey(lowercaseEventSpec)) {
            throw new IllegalArgumentException(String.format("Failed to find event with name %s in EntityRegistry", eventName));
        }
        return this.eventNameToSpec.get(lowercaseEventSpec);
    }

    @Override
    @Nonnull
    public Map<String, EntitySpec> getEntitySpecs() {
        return this.entityNameToSpec;
    }

    @Override
    @Nonnull
    public Map<String, AspectSpec> getAspectSpecs() {
        return this._aspectNameToSpec;
    }

    @Override
    @Nonnull
    public Map<String, EventSpec> getEventSpecs() {
        return this.eventNameToSpec;
    }

    @Override
    @Nonnull
    public AspectTemplateEngine getAspectTemplateEngine() {
        return this._aspectTemplateEngine;
    }

    @Override
    @Nonnull
    @Generated
    public PluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    @Override
    @Nullable
    @Generated
    public BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> getPluginFactoryProvider() {
        return this.pluginFactoryProvider;
    }

    private static class ValidationResult {
        boolean valid = true;
        List<String> validationFailures = new ArrayList<String>();

        private ValidationResult() {
        }

        @Generated
        public void setValid(boolean valid) {
            this.valid = valid;
        }

        @Generated
        public void setValidationFailures(List<String> validationFailures) {
            this.validationFailures = validationFailures;
        }

        @Generated
        public boolean isValid() {
            return this.valid;
        }

        @Generated
        public List<String> getValidationFailures() {
            return this.validationFailures;
        }
    }
}

