/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.AnnotationUtils;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class EntityAnnotation {
    public static final String ANNOTATION_NAME = "Entity";
    private static final String NAME_FIELD = "name";
    private static final String KEY_ASPECT_FIELD = "keyAspect";
    private final String name;
    private final String keyAspect;

    @Nonnull
    public static EntityAnnotation fromSchemaProperty(@Nonnull Object annotationObj, @Nonnull String context) {
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid value type provided (Expected Map)", ANNOTATION_NAME, context));
        }
        Map map = (Map)annotationObj;
        Optional<String> name = AnnotationUtils.getField(map, NAME_FIELD, String.class);
        Optional<String> keyAspect = AnnotationUtils.getField(map, KEY_ASPECT_FIELD, String.class);
        if (!name.isPresent()) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid field '%s'. Expected type String", ANNOTATION_NAME, context, NAME_FIELD));
        }
        if (!keyAspect.isPresent()) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid field '%s'. Expected type String", ANNOTATION_NAME, context, KEY_ASPECT_FIELD));
        }
        return new EntityAnnotation(name.get(), keyAspect.get());
    }

    @Generated
    public EntityAnnotation(String name, String keyAspect) {
        this.name = name;
        this.keyAspect = keyAspect;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getKeyAspect() {
        return this.keyAspect;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityAnnotation)) {
            return false;
        }
        EntityAnnotation other = (EntityAnnotation)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$keyAspect = this.getKeyAspect();
        String other$keyAspect = other.getKeyAspect();
        return !(this$keyAspect == null ? other$keyAspect != null : !this$keyAspect.equals(other$keyAspect));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $keyAspect = this.getKeyAspect();
        result = result * 59 + ($keyAspect == null ? 43 : $keyAspect.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntityAnnotation(name=" + this.getName() + ", keyAspect=" + this.getKeyAspect() + ")";
    }
}

