/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.annotation.EntityAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;

public class PartialEntitySpec
implements EntitySpec {
    private final EntityAnnotation _entityAnnotation;
    private final Map<String, AspectSpec> _aspectSpecs;

    public PartialEntitySpec(@Nonnull Collection<AspectSpec> aspectSpecs, EntityAnnotation entityAnnotation) {
        this._aspectSpecs = aspectSpecs.stream().collect(Collectors.toMap(AspectSpec::getName, Function.identity()));
        this._entityAnnotation = entityAnnotation;
    }

    @Override
    public String getName() {
        return this._entityAnnotation.getName();
    }

    @Override
    public EntityAnnotation getEntityAnnotation() {
        return this._entityAnnotation;
    }

    @Override
    public String getKeyAspectName() {
        return this._entityAnnotation.getKeyAspect();
    }

    @Override
    public AspectSpec getKeyAspectSpec() {
        if (this._entityAnnotation.getKeyAspect() != null) {
            return this._aspectSpecs.get(this._entityAnnotation.getKeyAspect());
        }
        return null;
    }

    @Override
    public List<AspectSpec> getAspectSpecs() {
        return new ArrayList<AspectSpec>(this._aspectSpecs.values());
    }

    @Override
    public Map<String, AspectSpec> getAspectSpecMap() {
        return this._aspectSpecs;
    }

    @Override
    public Boolean hasAspect(String name) {
        return this._aspectSpecs.containsKey(name);
    }

    @Override
    public AspectSpec getAspectSpec(String name) {
        return this._aspectSpecs.get(name);
    }

    @Override
    public RecordDataSchema getSnapshotSchema() {
        throw new UnsupportedOperationException("Partial entity specs do not contain snapshot schemas");
    }

    @Override
    public TyperefDataSchema getAspectTyperefSchema() {
        throw new UnsupportedOperationException("Partial entity specs do not contain aspect typeref schemas");
    }

    @Generated
    public String toString() {
        return "PartialEntitySpec(_entityAnnotation=" + String.valueOf(this._entityAnnotation) + ", _aspectSpecs=" + String.valueOf(this._aspectSpecs) + ")";
    }
}

