/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.models.RelationshipFieldSpec;
import com.linkedin.metadata.models.SearchScoreFieldSpec;
import com.linkedin.metadata.models.SearchableFieldSpec;
import com.linkedin.metadata.models.SearchableRefFieldSpec;
import com.linkedin.metadata.models.TimeseriesFieldCollectionSpec;
import com.linkedin.metadata.models.TimeseriesFieldSpec;
import com.linkedin.metadata.models.UrnValidationFieldSpec;
import com.linkedin.metadata.models.annotation.AspectAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class AspectSpec {
    private final AspectAnnotation _aspectAnnotation;
    private final Map<String, SearchableFieldSpec> _searchableFieldSpecs;
    private final Map<String, SearchScoreFieldSpec> _searchScoreFieldSpecs;
    private final Map<String, RelationshipFieldSpec> _relationshipFieldSpecs;
    private final Map<String, TimeseriesFieldSpec> _timeseriesFieldSpecs;
    private final Map<String, TimeseriesFieldCollectionSpec> _timeseriesFieldCollectionSpecs;
    private final Map<String, SearchableRefFieldSpec> _searchableRefFieldSpecs;
    private final Map<String, UrnValidationFieldSpec> _urnValidationFieldSpecs;
    private final RecordDataSchema _schema;
    private final Class<RecordTemplate> _aspectClass;
    private String registryName = "unknownRegistry";
    private ComparableVersion registryVersion = new ComparableVersion("0.0.0.0-dev");

    public AspectSpec(@Nonnull AspectAnnotation aspectAnnotation, @Nonnull List<SearchableFieldSpec> searchableFieldSpecs, @Nonnull List<SearchScoreFieldSpec> searchScoreFieldSpecs, @Nonnull List<RelationshipFieldSpec> relationshipFieldSpecs, @Nonnull List<TimeseriesFieldSpec> timeseriesFieldSpecs, @Nonnull List<TimeseriesFieldCollectionSpec> timeseriesFieldCollectionSpecs, @Nonnull List<SearchableRefFieldSpec> searchableRefFieldSpecs, @Nonnull List<UrnValidationFieldSpec> urnValidationFieldSpecs, RecordDataSchema schema, Class<RecordTemplate> aspectClass) {
        this._aspectAnnotation = aspectAnnotation;
        this._searchableFieldSpecs = searchableFieldSpecs.stream().collect(Collectors.toMap(spec -> spec.getPath().toString(), spec -> spec, (val1, val2) -> val1));
        this._searchableRefFieldSpecs = searchableRefFieldSpecs.stream().collect(Collectors.toMap(spec -> spec.getPath().toString(), spec -> spec, (val1, val2) -> val1));
        this._searchScoreFieldSpecs = searchScoreFieldSpecs.stream().collect(Collectors.toMap(spec -> spec.getPath().toString(), spec -> spec, (val1, val2) -> val1));
        this._relationshipFieldSpecs = relationshipFieldSpecs.stream().collect(Collectors.toMap(spec -> spec.getPath().toString(), spec -> spec, (val1, val2) -> val1));
        this._timeseriesFieldSpecs = timeseriesFieldSpecs.stream().collect(Collectors.toMap(spec -> spec.getTimeseriesFieldAnnotation().getStatName(), spec -> spec, (val1, val2) -> val1));
        this._timeseriesFieldCollectionSpecs = timeseriesFieldCollectionSpecs.stream().collect(Collectors.toMap(spec -> spec.getTimeseriesFieldCollectionAnnotation().getCollectionName(), spec -> spec, (val1, val2) -> val1));
        this._urnValidationFieldSpecs = urnValidationFieldSpecs.stream().collect(Collectors.toMap(spec -> spec.getPath().toString(), spec -> spec, (val1, val2) -> val1));
        this._schema = schema;
        this._aspectClass = aspectClass;
    }

    public String getName() {
        return this._aspectAnnotation.getName();
    }

    public boolean isTimeseries() {
        return this._aspectAnnotation.isTimeseries();
    }

    public Boolean isAutoRender() {
        return this._aspectAnnotation.isAutoRender();
    }

    public DataMap getRenderSpec() {
        return this._aspectAnnotation.getRenderSpec();
    }

    public Map<String, SearchableFieldSpec> getSearchableFieldSpecMap() {
        return this._searchableFieldSpecs;
    }

    public Map<String, SearchScoreFieldSpec> getSearchScoreFieldSpecMap() {
        return this._searchScoreFieldSpecs;
    }

    public Map<String, RelationshipFieldSpec> getRelationshipFieldSpecMap() {
        return this._relationshipFieldSpecs;
    }

    public Map<String, TimeseriesFieldSpec> getTimeseriesFieldSpecMap() {
        return this._timeseriesFieldSpecs;
    }

    public Map<String, UrnValidationFieldSpec> getUrnValidationFieldSpecMap() {
        return this._urnValidationFieldSpecs;
    }

    public Map<String, TimeseriesFieldCollectionSpec> getTimeseriesFieldCollectionSpecMap() {
        return this._timeseriesFieldCollectionSpecs;
    }

    public List<SearchableFieldSpec> getSearchableFieldSpecs() {
        return new ArrayList<SearchableFieldSpec>(this._searchableFieldSpecs.values());
    }

    public List<SearchableRefFieldSpec> getSearchableRefFieldSpecs() {
        return new ArrayList<SearchableRefFieldSpec>(this._searchableRefFieldSpecs.values());
    }

    public List<SearchScoreFieldSpec> getSearchScoreFieldSpecs() {
        return new ArrayList<SearchScoreFieldSpec>(this._searchScoreFieldSpecs.values());
    }

    public List<RelationshipFieldSpec> getRelationshipFieldSpecs() {
        return new ArrayList<RelationshipFieldSpec>(this._relationshipFieldSpecs.values());
    }

    public List<TimeseriesFieldSpec> getTimeseriesFieldSpecs() {
        return new ArrayList<TimeseriesFieldSpec>(this._timeseriesFieldSpecs.values());
    }

    public List<TimeseriesFieldCollectionSpec> getTimeseriesFieldCollectionSpecs() {
        return new ArrayList<TimeseriesFieldCollectionSpec>(this._timeseriesFieldCollectionSpecs.values());
    }

    public RecordDataSchema getPegasusSchema() {
        return this._schema;
    }

    public Class<RecordTemplate> getDataTemplateClass() {
        return this._aspectClass;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspectSpec)) {
            return false;
        }
        AspectSpec other = (AspectSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AspectAnnotation this$_aspectAnnotation = this._aspectAnnotation;
        AspectAnnotation other$_aspectAnnotation = other._aspectAnnotation;
        if (this$_aspectAnnotation == null ? other$_aspectAnnotation != null : !((Object)this$_aspectAnnotation).equals(other$_aspectAnnotation)) {
            return false;
        }
        Map<String, SearchableFieldSpec> this$_searchableFieldSpecs = this._searchableFieldSpecs;
        Map<String, SearchableFieldSpec> other$_searchableFieldSpecs = other._searchableFieldSpecs;
        if (this$_searchableFieldSpecs == null ? other$_searchableFieldSpecs != null : !((Object)this$_searchableFieldSpecs).equals(other$_searchableFieldSpecs)) {
            return false;
        }
        Map<String, SearchScoreFieldSpec> this$_searchScoreFieldSpecs = this._searchScoreFieldSpecs;
        Map<String, SearchScoreFieldSpec> other$_searchScoreFieldSpecs = other._searchScoreFieldSpecs;
        if (this$_searchScoreFieldSpecs == null ? other$_searchScoreFieldSpecs != null : !((Object)this$_searchScoreFieldSpecs).equals(other$_searchScoreFieldSpecs)) {
            return false;
        }
        Map<String, RelationshipFieldSpec> this$_relationshipFieldSpecs = this._relationshipFieldSpecs;
        Map<String, RelationshipFieldSpec> other$_relationshipFieldSpecs = other._relationshipFieldSpecs;
        if (this$_relationshipFieldSpecs == null ? other$_relationshipFieldSpecs != null : !((Object)this$_relationshipFieldSpecs).equals(other$_relationshipFieldSpecs)) {
            return false;
        }
        Map<String, TimeseriesFieldSpec> this$_timeseriesFieldSpecs = this._timeseriesFieldSpecs;
        Map<String, TimeseriesFieldSpec> other$_timeseriesFieldSpecs = other._timeseriesFieldSpecs;
        if (this$_timeseriesFieldSpecs == null ? other$_timeseriesFieldSpecs != null : !((Object)this$_timeseriesFieldSpecs).equals(other$_timeseriesFieldSpecs)) {
            return false;
        }
        Map<String, TimeseriesFieldCollectionSpec> this$_timeseriesFieldCollectionSpecs = this._timeseriesFieldCollectionSpecs;
        Map<String, TimeseriesFieldCollectionSpec> other$_timeseriesFieldCollectionSpecs = other._timeseriesFieldCollectionSpecs;
        if (this$_timeseriesFieldCollectionSpecs == null ? other$_timeseriesFieldCollectionSpecs != null : !((Object)this$_timeseriesFieldCollectionSpecs).equals(other$_timeseriesFieldCollectionSpecs)) {
            return false;
        }
        Map<String, SearchableRefFieldSpec> this$_searchableRefFieldSpecs = this._searchableRefFieldSpecs;
        Map<String, SearchableRefFieldSpec> other$_searchableRefFieldSpecs = other._searchableRefFieldSpecs;
        if (this$_searchableRefFieldSpecs == null ? other$_searchableRefFieldSpecs != null : !((Object)this$_searchableRefFieldSpecs).equals(other$_searchableRefFieldSpecs)) {
            return false;
        }
        Map<String, UrnValidationFieldSpec> this$_urnValidationFieldSpecs = this._urnValidationFieldSpecs;
        Map<String, UrnValidationFieldSpec> other$_urnValidationFieldSpecs = other._urnValidationFieldSpecs;
        if (this$_urnValidationFieldSpecs == null ? other$_urnValidationFieldSpecs != null : !((Object)this$_urnValidationFieldSpecs).equals(other$_urnValidationFieldSpecs)) {
            return false;
        }
        RecordDataSchema this$_schema = this._schema;
        RecordDataSchema other$_schema = other._schema;
        if (this$_schema == null ? other$_schema != null : !((Object)this$_schema).equals(other$_schema)) {
            return false;
        }
        Class<RecordTemplate> this$_aspectClass = this._aspectClass;
        Class<RecordTemplate> other$_aspectClass = other._aspectClass;
        if (this$_aspectClass == null ? other$_aspectClass != null : !this$_aspectClass.equals(other$_aspectClass)) {
            return false;
        }
        String this$registryName = this.getRegistryName();
        String other$registryName = other.getRegistryName();
        if (this$registryName == null ? other$registryName != null : !this$registryName.equals(other$registryName)) {
            return false;
        }
        ComparableVersion this$registryVersion = this.getRegistryVersion();
        ComparableVersion other$registryVersion = other.getRegistryVersion();
        return !(this$registryVersion == null ? other$registryVersion != null : !((Object)this$registryVersion).equals(other$registryVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AspectSpec;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AspectAnnotation $_aspectAnnotation = this._aspectAnnotation;
        result = result * 59 + ($_aspectAnnotation == null ? 43 : ((Object)$_aspectAnnotation).hashCode());
        Map<String, SearchableFieldSpec> $_searchableFieldSpecs = this._searchableFieldSpecs;
        result = result * 59 + ($_searchableFieldSpecs == null ? 43 : ((Object)$_searchableFieldSpecs).hashCode());
        Map<String, SearchScoreFieldSpec> $_searchScoreFieldSpecs = this._searchScoreFieldSpecs;
        result = result * 59 + ($_searchScoreFieldSpecs == null ? 43 : ((Object)$_searchScoreFieldSpecs).hashCode());
        Map<String, RelationshipFieldSpec> $_relationshipFieldSpecs = this._relationshipFieldSpecs;
        result = result * 59 + ($_relationshipFieldSpecs == null ? 43 : ((Object)$_relationshipFieldSpecs).hashCode());
        Map<String, TimeseriesFieldSpec> $_timeseriesFieldSpecs = this._timeseriesFieldSpecs;
        result = result * 59 + ($_timeseriesFieldSpecs == null ? 43 : ((Object)$_timeseriesFieldSpecs).hashCode());
        Map<String, TimeseriesFieldCollectionSpec> $_timeseriesFieldCollectionSpecs = this._timeseriesFieldCollectionSpecs;
        result = result * 59 + ($_timeseriesFieldCollectionSpecs == null ? 43 : ((Object)$_timeseriesFieldCollectionSpecs).hashCode());
        Map<String, SearchableRefFieldSpec> $_searchableRefFieldSpecs = this._searchableRefFieldSpecs;
        result = result * 59 + ($_searchableRefFieldSpecs == null ? 43 : ((Object)$_searchableRefFieldSpecs).hashCode());
        Map<String, UrnValidationFieldSpec> $_urnValidationFieldSpecs = this._urnValidationFieldSpecs;
        result = result * 59 + ($_urnValidationFieldSpecs == null ? 43 : ((Object)$_urnValidationFieldSpecs).hashCode());
        RecordDataSchema $_schema = this._schema;
        result = result * 59 + ($_schema == null ? 43 : ((Object)$_schema).hashCode());
        Class<RecordTemplate> $_aspectClass = this._aspectClass;
        result = result * 59 + ($_aspectClass == null ? 43 : $_aspectClass.hashCode());
        String $registryName = this.getRegistryName();
        result = result * 59 + ($registryName == null ? 43 : $registryName.hashCode());
        ComparableVersion $registryVersion = this.getRegistryVersion();
        result = result * 59 + ($registryVersion == null ? 43 : ((Object)$registryVersion).hashCode());
        return result;
    }

    @Generated
    public void setRegistryName(String registryName) {
        this.registryName = registryName;
    }

    @Generated
    public String getRegistryName() {
        return this.registryName;
    }

    @Generated
    public void setRegistryVersion(ComparableVersion registryVersion) {
        this.registryVersion = registryVersion;
    }

    @Generated
    public ComparableVersion getRegistryVersion() {
        return this.registryVersion;
    }
}

