/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.common.urn.Urn;
import com.linkedin.dataset.DatasetLineageType;
import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class UpstreamLineagePatchBuilder
extends AbstractMultiFieldPatchBuilder<UpstreamLineagePatchBuilder> {
    private static final String UPSTREAMS_PATH_START = "/upstreams/";
    private static final String FINE_GRAINED_PATH_START = "/fineGrainedLineages/";
    private static final String DATASET_KEY = "dataset";
    private static final String AUDIT_STAMP_KEY = "auditStamp";
    private static final String TIME_KEY = "time";
    private static final String ACTOR_KEY = "actor";
    private static final String TYPE_KEY = "type";

    public UpstreamLineagePatchBuilder addUpstream(@Nonnull DatasetUrn datasetUrn, @Nonnull DatasetLineageType lineageType) {
        ObjectNode value = JsonNodeFactory.instance.objectNode();
        ObjectNode auditStamp = JsonNodeFactory.instance.objectNode();
        auditStamp.put(TIME_KEY, System.currentTimeMillis()).put(ACTOR_KEY, "urn:li:corpuser:UNKNOWN");
        value.put(DATASET_KEY, datasetUrn.toString()).put(TYPE_KEY, lineageType.toString()).set(AUDIT_STAMP_KEY, auditStamp);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), UPSTREAMS_PATH_START + UpstreamLineagePatchBuilder.encodeValueUrn(datasetUrn), value));
        return this;
    }

    public UpstreamLineagePatchBuilder removeUpstream(@Nonnull DatasetUrn datasetUrn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), UPSTREAMS_PATH_START + UpstreamLineagePatchBuilder.encodeValueUrn(datasetUrn), null));
        return this;
    }

    public UpstreamLineagePatchBuilder addFineGrainedUpstreamField(@Nonnull Urn upstreamSchemaField, @Nullable Float confidenceScore, @Nonnull String transformationOperation, @Nonnull Urn downstreamSchemaField, @Nullable Urn queryUrn) {
        Float finalConfidenceScore = this.getConfidenceScoreOrDefault(confidenceScore);
        String finalQueryUrn = queryUrn == null || StringUtils.isBlank(queryUrn.toString()) ? "NONE" : queryUrn.toString();
        ObjectNode fineGrainedLineageNode = JsonNodeFactory.instance.objectNode();
        fineGrainedLineageNode.put("confidenceScore", JsonNodeFactory.instance.numberNode(finalConfidenceScore));
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), FINE_GRAINED_PATH_START + transformationOperation + "/" + UpstreamLineagePatchBuilder.encodeValueUrn(downstreamSchemaField) + "/" + finalQueryUrn + "/" + UpstreamLineagePatchBuilder.encodeValueUrn(upstreamSchemaField), fineGrainedLineageNode));
        return this;
    }

    private Float getConfidenceScoreOrDefault(@Nullable Float confidenceScore) {
        float finalConfidenceScore = confidenceScore != null && confidenceScore.floatValue() > 0.0f && confidenceScore.floatValue() <= 1.0f ? confidenceScore.floatValue() : 1.0f;
        return Float.valueOf(finalConfidenceScore);
    }

    public UpstreamLineagePatchBuilder removeFineGrainedUpstreamField(@Nonnull Urn upstreamSchemaFieldUrn, @Nonnull String transformationOperation, @Nonnull Urn downstreamSchemaField, @Nullable Urn queryUrn) {
        String finalQueryUrn = queryUrn == null || StringUtils.isBlank(queryUrn.toString()) ? "NONE" : queryUrn.toString();
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), FINE_GRAINED_PATH_START + transformationOperation + "/" + UpstreamLineagePatchBuilder.encodeValueUrn(downstreamSchemaField) + "/" + finalQueryUrn + "/" + UpstreamLineagePatchBuilder.encodeValueUrn(upstreamSchemaFieldUrn), null));
        return this;
    }

    @Override
    protected String getAspectName() {
        return "upstreamLineage";
    }

    @Override
    protected String getEntityType() {
        return DATASET_KEY;
    }

    @Generated
    public String toString() {
        return "UpstreamLineagePatchBuilder()";
    }
}

