/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.common.urn.Urn;
import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import datahub.shaded.jackson.databind.node.ArrayNode;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class StructuredPropertiesPatchBuilder
extends AbstractMultiFieldPatchBuilder<StructuredPropertiesPatchBuilder> {
    private static final String BASE_PATH = "/properties";
    private static final String URN_KEY = "propertyUrn";
    private static final String VALUES_KEY = "values";

    public StructuredPropertiesPatchBuilder removeProperty(Urn propertyUrn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), "/properties/" + String.valueOf(propertyUrn), null));
        return this;
    }

    public StructuredPropertiesPatchBuilder setNumberProperty(@Nonnull Urn propertyUrn, @Nullable Integer propertyValue) {
        ObjectNode newProperty = JsonNodeFactory.instance.objectNode();
        newProperty.put(URN_KEY, propertyUrn.toString());
        ArrayNode valuesNode = JsonNodeFactory.instance.arrayNode();
        ObjectNode propertyValueNode = JsonNodeFactory.instance.objectNode();
        propertyValueNode.set("double", JsonNodeFactory.instance.numberNode(propertyValue));
        valuesNode.add(propertyValueNode);
        newProperty.set(VALUES_KEY, valuesNode);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/properties/" + StructuredPropertiesPatchBuilder.encodeValueUrn(propertyUrn), newProperty));
        return this;
    }

    public StructuredPropertiesPatchBuilder setNumberProperty(@Nonnull Urn propertyUrn, @Nonnull List<Integer> propertyValues) {
        ObjectNode newProperty = JsonNodeFactory.instance.objectNode();
        newProperty.put(URN_KEY, propertyUrn.toString());
        ArrayNode valuesNode = JsonNodeFactory.instance.arrayNode();
        propertyValues.forEach(propertyValue -> {
            ObjectNode propertyValueNode = JsonNodeFactory.instance.objectNode();
            propertyValueNode.set("double", JsonNodeFactory.instance.numberNode((Integer)propertyValue));
            valuesNode.add(propertyValueNode);
        });
        newProperty.set(VALUES_KEY, valuesNode);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/properties/" + StructuredPropertiesPatchBuilder.encodeValueUrn(propertyUrn), newProperty));
        return this;
    }

    public StructuredPropertiesPatchBuilder setStringProperty(@Nonnull Urn propertyUrn, @Nullable String propertyValue) {
        ObjectNode newProperty = JsonNodeFactory.instance.objectNode();
        newProperty.put(URN_KEY, propertyUrn.toString());
        ArrayNode valuesNode = JsonNodeFactory.instance.arrayNode();
        ObjectNode propertyValueNode = JsonNodeFactory.instance.objectNode();
        propertyValueNode.set("string", JsonNodeFactory.instance.textNode(propertyValue));
        valuesNode.add(propertyValueNode);
        newProperty.set(VALUES_KEY, valuesNode);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/properties/" + StructuredPropertiesPatchBuilder.encodeValueUrn(propertyUrn), newProperty));
        return this;
    }

    public StructuredPropertiesPatchBuilder setStringProperty(@Nonnull Urn propertyUrn, @Nonnull List<String> propertyValues) {
        ObjectNode newProperty = JsonNodeFactory.instance.objectNode();
        newProperty.put(URN_KEY, propertyUrn.toString());
        ArrayNode valuesNode = JsonNodeFactory.instance.arrayNode();
        propertyValues.forEach(propertyValue -> {
            ObjectNode propertyValueNode = JsonNodeFactory.instance.objectNode();
            propertyValueNode.set("string", JsonNodeFactory.instance.textNode((String)propertyValue));
            valuesNode.add(propertyValueNode);
        });
        newProperty.set(VALUES_KEY, valuesNode);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), "/properties/" + StructuredPropertiesPatchBuilder.encodeValueUrn(propertyUrn), newProperty));
        return this;
    }

    @Override
    protected String getAspectName() {
        return "structuredProperties";
    }

    @Override
    protected String getEntityType() {
        if (this.targetEntityUrn == null) {
            throw new IllegalStateException("Target Entity Urn must be set to determine entity type before building Patch.");
        }
        return this.targetEntityUrn.getEntityType();
    }
}

