/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.batch;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.mxe.MetadataChangeLog;
import com.linkedin.mxe.SystemMetadata;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface MCLItem
extends BatchItem {
    @Nonnull
    public MetadataChangeLog getMetadataChangeLog();

    @Override
    default public Urn getUrn() {
        return this.getMetadataChangeLog().getEntityUrn();
    }

    @Override
    @Nonnull
    default public String getAspectName() {
        if (this.getMetadataChangeLog().getAspectName() != null) {
            return this.getMetadataChangeLog().getAspectName();
        }
        return this.getRecordTemplate().schema().getName();
    }

    @Override
    default public SystemMetadata getSystemMetadata() {
        return this.getMetadataChangeLog().getSystemMetadata();
    }

    default public SystemMetadata getPreviousSystemMetadata() {
        return this.getMetadataChangeLog().getPreviousSystemMetadata();
    }

    @Nullable
    public RecordTemplate getPreviousRecordTemplate();

    default public <T> T getPreviousAspect(Class<T> clazz) {
        if (this.getPreviousRecordTemplate() != null) {
            try {
                return clazz.getConstructor(DataMap.class).newInstance(this.getPreviousRecordTemplate().data());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    @Nonnull
    default public ChangeType getChangeType() {
        return this.getMetadataChangeLog().getChangeType();
    }

    @Override
    default public AuditStamp getAuditStamp() {
        return this.getMetadataChangeLog().getCreated();
    }

    default public boolean isNoOp() {
        return this.getPreviousRecordTemplate() == this.getRecordTemplate();
    }
}

