/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.identity;

import com.linkedin.common.UrnArray;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CorpUserHomePageSettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.identity/**Settings related to the home page for a user*/record CorpUserHomePageSettings{/**The page template that will be rendered in the UI by default for this user*/@Relationship={\"entityTypes\":[\"dataHubPageTemplate\"],\"name\":\"HasPersonalPageTemplate\"}pageTemplate:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The list of announcement urns that have been dismissed by the user*/dismissedAnnouncements:optional array[com.linkedin.common.Urn]}", SchemaFormatType.PDL);
    private Urn _pageTemplateField = null;
    private UrnArray _dismissedAnnouncementsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_PageTemplate = SCHEMA.getField("pageTemplate");
    private static final RecordDataSchema.Field FIELD_DismissedAnnouncements = SCHEMA.getField("dismissedAnnouncements");

    public CorpUserHomePageSettings() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public CorpUserHomePageSettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasPageTemplate() {
        if (this._pageTemplateField != null) {
            return true;
        }
        return this._map.containsKey("pageTemplate");
    }

    public void removePageTemplate() {
        this._map.remove("pageTemplate");
    }

    @Nullable
    public Urn getPageTemplate(GetMode mode) {
        return this.getPageTemplate();
    }

    @Nullable
    public Urn getPageTemplate() {
        if (this._pageTemplateField != null) {
            return this._pageTemplateField;
        }
        Object __rawValue = this._map.get("pageTemplate");
        this._pageTemplateField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._pageTemplateField;
    }

    public CorpUserHomePageSettings setPageTemplate(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPageTemplate(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePageTemplate();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "pageTemplate", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._pageTemplateField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "pageTemplate", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._pageTemplateField = value;
            }
        }
        return this;
    }

    public CorpUserHomePageSettings setPageTemplate(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field pageTemplate of com.linkedin.identity.CorpUserHomePageSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "pageTemplate", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._pageTemplateField = value;
        return this;
    }

    public boolean hasDismissedAnnouncements() {
        if (this._dismissedAnnouncementsField != null) {
            return true;
        }
        return this._map.containsKey("dismissedAnnouncements");
    }

    public void removeDismissedAnnouncements() {
        this._map.remove("dismissedAnnouncements");
    }

    @Nullable
    public UrnArray getDismissedAnnouncements(GetMode mode) {
        return this.getDismissedAnnouncements();
    }

    @Nullable
    public UrnArray getDismissedAnnouncements() {
        if (this._dismissedAnnouncementsField != null) {
            return this._dismissedAnnouncementsField;
        }
        Object __rawValue = this._map.get("dismissedAnnouncements");
        this._dismissedAnnouncementsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._dismissedAnnouncementsField;
    }

    public CorpUserHomePageSettings setDismissedAnnouncements(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDismissedAnnouncements(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDismissedAnnouncements();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dismissedAnnouncements", value.data());
                this._dismissedAnnouncementsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dismissedAnnouncements", value.data());
                this._dismissedAnnouncementsField = value;
            }
        }
        return this;
    }

    public CorpUserHomePageSettings setDismissedAnnouncements(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dismissedAnnouncements of com.linkedin.identity.CorpUserHomePageSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dismissedAnnouncements", value.data());
        this._dismissedAnnouncementsField = value;
        return this;
    }

    @Override
    public CorpUserHomePageSettings clone() throws CloneNotSupportedException {
        CorpUserHomePageSettings __clone = (CorpUserHomePageSettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CorpUserHomePageSettings copy() throws CloneNotSupportedException {
        CorpUserHomePageSettings __copy = (CorpUserHomePageSettings)super.copy();
        __copy._dismissedAnnouncementsField = null;
        __copy._pageTemplateField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CorpUserHomePageSettings __objectRef;

        private ChangeListener(CorpUserHomePageSettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "dismissedAnnouncements": {
                    this.__objectRef._dismissedAnnouncementsField = null;
                    break;
                }
                case "pageTemplate": {
                    this.__objectRef._pageTemplateField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec pageTemplate() {
            return new PathSpec(this.getPathComponents(), "pageTemplate");
        }

        public PathSpec dismissedAnnouncements() {
            return new PathSpec(this.getPathComponents(), "dismissedAnnouncements");
        }

        public PathSpec dismissedAnnouncements(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "dismissedAnnouncements");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withPageTemplate() {
            this.getDataMap().put("pageTemplate", 1);
            return this;
        }

        public ProjectionMask withDismissedAnnouncements() {
            this.getDataMap().put("dismissedAnnouncements", 1);
            return this;
        }

        public ProjectionMask withDismissedAnnouncements(Integer start, Integer count) {
            this.getDataMap().put("dismissedAnnouncements", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("dismissedAnnouncements").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("dismissedAnnouncements").put("$count", count);
            }
            return this;
        }
    }
}

