/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.identity;

import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CorpGroupEditableInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.identity/**Group information that can be edited from UI*/@Aspect.name=\"corpGroupEditableInfo\"record CorpGroupEditableInfo{/**A description of the group*/@Searchable={\"fieldName\":\"editedDescription\",\"fieldType\":\"TEXT\"}description:optional string/**A URL which points to a picture which user wants to set as the photo for the group*/pictureLink:{namespace com.linkedin.common@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}=\"https://raw.githubusercontent.com/datahub-project/datahub/master/datahub-web-react/src/images/default_avatar.png\"/**Slack channel for the group*/slack:optional string/**Email address to contact the group*/email:optional string}", SchemaFormatType.PDL);
    private String _descriptionField = null;
    private Url _pictureLinkField = null;
    private String _slackField = null;
    private String _emailField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");
    private static final RecordDataSchema.Field FIELD_PictureLink = SCHEMA.getField("pictureLink");
    private static final Url DEFAULT_PictureLink;
    private static final RecordDataSchema.Field FIELD_Slack;
    private static final RecordDataSchema.Field FIELD_Email;

    public CorpGroupEditableInfo() {
        super(new DataMap(6, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public CorpGroupEditableInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public CorpGroupEditableInfo setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public CorpGroupEditableInfo setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.identity.CorpGroupEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasPictureLink() {
        if (this._pictureLinkField != null) {
            return true;
        }
        return this._map.containsKey("pictureLink");
    }

    public void removePictureLink() {
        this._map.remove("pictureLink");
    }

    @Nullable
    public Url getPictureLink(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPictureLink();
            }
            case NULL: {
                if (this._pictureLinkField != null) {
                    return this._pictureLinkField;
                }
                Object __rawValue = this._map.get("pictureLink");
                this._pictureLinkField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
                return this._pictureLinkField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Url getPictureLink() {
        if (this._pictureLinkField != null) {
            return this._pictureLinkField;
        }
        Object __rawValue = this._map.get("pictureLink");
        if (__rawValue == null) {
            return DEFAULT_PictureLink;
        }
        this._pictureLinkField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._pictureLinkField;
    }

    public CorpGroupEditableInfo setPictureLink(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPictureLink(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field pictureLink of com.linkedin.identity.CorpGroupEditableInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "pictureLink", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._pictureLinkField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePictureLink();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "pictureLink", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._pictureLinkField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "pictureLink", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._pictureLinkField = value;
            }
        }
        return this;
    }

    public CorpGroupEditableInfo setPictureLink(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field pictureLink of com.linkedin.identity.CorpGroupEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "pictureLink", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._pictureLinkField = value;
        return this;
    }

    public boolean hasSlack() {
        if (this._slackField != null) {
            return true;
        }
        return this._map.containsKey("slack");
    }

    public void removeSlack() {
        this._map.remove("slack");
    }

    @Nullable
    public String getSlack(GetMode mode) {
        return this.getSlack();
    }

    @Nullable
    public String getSlack() {
        if (this._slackField != null) {
            return this._slackField;
        }
        Object __rawValue = this._map.get("slack");
        this._slackField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._slackField;
    }

    public CorpGroupEditableInfo setSlack(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSlack(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSlack();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "slack", value);
                this._slackField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "slack", value);
                this._slackField = value;
            }
        }
        return this;
    }

    public CorpGroupEditableInfo setSlack(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field slack of com.linkedin.identity.CorpGroupEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "slack", value);
        this._slackField = value;
        return this;
    }

    public boolean hasEmail() {
        if (this._emailField != null) {
            return true;
        }
        return this._map.containsKey("email");
    }

    public void removeEmail() {
        this._map.remove("email");
    }

    @Nullable
    public String getEmail(GetMode mode) {
        return this.getEmail();
    }

    @Nullable
    public String getEmail() {
        if (this._emailField != null) {
            return this._emailField;
        }
        Object __rawValue = this._map.get("email");
        this._emailField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._emailField;
    }

    public CorpGroupEditableInfo setEmail(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEmail(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEmail();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "email", value);
                this._emailField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "email", value);
                this._emailField = value;
            }
        }
        return this;
    }

    public CorpGroupEditableInfo setEmail(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field email of com.linkedin.identity.CorpGroupEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "email", value);
        this._emailField = value;
        return this;
    }

    @Override
    public CorpGroupEditableInfo clone() throws CloneNotSupportedException {
        CorpGroupEditableInfo __clone = (CorpGroupEditableInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CorpGroupEditableInfo copy() throws CloneNotSupportedException {
        CorpGroupEditableInfo __copy = (CorpGroupEditableInfo)super.copy();
        __copy._slackField = null;
        __copy._descriptionField = null;
        __copy._pictureLinkField = null;
        __copy._emailField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Slack = SCHEMA.getField("slack");
        FIELD_Email = SCHEMA.getField("email");
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        DEFAULT_PictureLink = DataTemplateUtil.coerceCustomOutput(FIELD_PictureLink.getDefault(), Url.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CorpGroupEditableInfo __objectRef;

        private ChangeListener(CorpGroupEditableInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "slack": {
                    this.__objectRef._slackField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "pictureLink": {
                    this.__objectRef._pictureLinkField = null;
                    break;
                }
                case "email": {
                    this.__objectRef._emailField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public PathSpec pictureLink() {
            return new PathSpec(this.getPathComponents(), "pictureLink");
        }

        public PathSpec slack() {
            return new PathSpec(this.getPathComponents(), "slack");
        }

        public PathSpec email() {
            return new PathSpec(this.getPathComponents(), "email");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withPictureLink() {
            this.getDataMap().put("pictureLink", 1);
            return this;
        }

        public ProjectionMask withSlack() {
            this.getDataMap().put("slack", 1);
            return this;
        }

        public ProjectionMask withEmail() {
            this.getDataMap().put("email", 1);
            return this;
        }
    }
}

