/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.glossary;

import com.linkedin.common.urn.GlossaryNodeUrn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GlossaryNodeInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.glossary/**Properties associated with a GlossaryNode*/@Aspect.name=\"glossaryNodeInfo\"record GlossaryNodeInfo includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{/**Definition of business node*/@Searchable={}definition:string/**Parent node of the glossary term*/@Relationship={\"entityTypes\":[\"glossaryNode\"],\"name\":\"IsPartOf\"}@Searchable={\"fieldName\":\"parentNode\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasParentNode\"}parentNode:optional{namespace com.linkedin.common/**Business Node*/@java.class=\"com.linkedin.common.urn.GlossaryNodeUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized business node identifier\",\"entityType\":\"glossaryNode\",\"fields\":[{\"doc\":\"The name of business node with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryNode\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryNodeUrn=string}/**Display name of the node*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldName\":\"displayName\",\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}name:optional string/**Optional id for the GlossaryNode*/@Searchable.fieldType=\"TEXT_PARTIAL\"id:optional string}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private String _definitionField = null;
    private GlossaryNodeUrn _parentNodeField = null;
    private String _nameField = null;
    private String _idField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_Definition;
    private static final RecordDataSchema.Field FIELD_ParentNode;
    private static final RecordDataSchema.Field FIELD_Name;
    private static final RecordDataSchema.Field FIELD_Id;

    public GlossaryNodeInfo() {
        super(new DataMap(7, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public GlossaryNodeInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public GlossaryNodeInfo setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.glossary.GlossaryNodeInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public GlossaryNodeInfo setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.glossary.GlossaryNodeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasDefinition() {
        if (this._definitionField != null) {
            return true;
        }
        return this._map.containsKey("definition");
    }

    public void removeDefinition() {
        this._map.remove("definition");
    }

    @Nullable
    public String getDefinition(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDefinition();
            }
            case DEFAULT: 
            case NULL: {
                if (this._definitionField != null) {
                    return this._definitionField;
                }
                Object __rawValue = this._map.get("definition");
                this._definitionField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._definitionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDefinition() {
        if (this._definitionField != null) {
            return this._definitionField;
        }
        Object __rawValue = this._map.get("definition");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("definition");
        }
        this._definitionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._definitionField;
    }

    public GlossaryNodeInfo setDefinition(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDefinition(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field definition of com.linkedin.glossary.GlossaryNodeInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "definition", value);
                this._definitionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDefinition();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "definition", value);
                this._definitionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "definition", value);
                this._definitionField = value;
            }
        }
        return this;
    }

    public GlossaryNodeInfo setDefinition(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field definition of com.linkedin.glossary.GlossaryNodeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "definition", value);
        this._definitionField = value;
        return this;
    }

    public boolean hasParentNode() {
        if (this._parentNodeField != null) {
            return true;
        }
        return this._map.containsKey("parentNode");
    }

    public void removeParentNode() {
        this._map.remove("parentNode");
    }

    @Nullable
    public GlossaryNodeUrn getParentNode(GetMode mode) {
        return this.getParentNode();
    }

    @Nullable
    public GlossaryNodeUrn getParentNode() {
        if (this._parentNodeField != null) {
            return this._parentNodeField;
        }
        Object __rawValue = this._map.get("parentNode");
        this._parentNodeField = DataTemplateUtil.coerceCustomOutput(__rawValue, GlossaryNodeUrn.class);
        return this._parentNodeField;
    }

    public GlossaryNodeInfo setParentNode(@Nullable GlossaryNodeUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParentNode(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParentNode();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parentNode", DataTemplateUtil.coerceCustomInput(value, GlossaryNodeUrn.class));
                this._parentNodeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parentNode", DataTemplateUtil.coerceCustomInput(value, GlossaryNodeUrn.class));
                this._parentNodeField = value;
            }
        }
        return this;
    }

    public GlossaryNodeInfo setParentNode(@Nonnull GlossaryNodeUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parentNode of com.linkedin.glossary.GlossaryNodeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parentNode", DataTemplateUtil.coerceCustomInput(value, GlossaryNodeUrn.class));
        this._parentNodeField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        return this.getName();
    }

    @Nullable
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public GlossaryNodeInfo setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public GlossaryNodeInfo setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.glossary.GlossaryNodeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasId() {
        if (this._idField != null) {
            return true;
        }
        return this._map.containsKey("id");
    }

    public void removeId() {
        this._map.remove("id");
    }

    @Nullable
    public String getId(GetMode mode) {
        return this.getId();
    }

    @Nullable
    public String getId() {
        if (this._idField != null) {
            return this._idField;
        }
        Object __rawValue = this._map.get("id");
        this._idField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._idField;
    }

    public GlossaryNodeInfo setId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
            }
        }
        return this;
    }

    public GlossaryNodeInfo setId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field id of com.linkedin.glossary.GlossaryNodeInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "id", value);
        this._idField = value;
        return this;
    }

    @Override
    public GlossaryNodeInfo clone() throws CloneNotSupportedException {
        GlossaryNodeInfo __clone = (GlossaryNodeInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public GlossaryNodeInfo copy() throws CloneNotSupportedException {
        GlossaryNodeInfo __copy = (GlossaryNodeInfo)super.copy();
        __copy._customPropertiesField = null;
        __copy._nameField = null;
        __copy._definitionField = null;
        __copy._parentNodeField = null;
        __copy._idField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Definition = SCHEMA.getField("definition");
        FIELD_ParentNode = SCHEMA.getField("parentNode");
        FIELD_Name = SCHEMA.getField("name");
        FIELD_Id = SCHEMA.getField("id");
        Custom.initializeCustomClass(GlossaryNodeUrn.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final GlossaryNodeInfo __objectRef;

        private ChangeListener(GlossaryNodeInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "definition": {
                    this.__objectRef._definitionField = null;
                    break;
                }
                case "parentNode": {
                    this.__objectRef._parentNodeField = null;
                    break;
                }
                case "id": {
                    this.__objectRef._idField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec definition() {
            return new PathSpec(this.getPathComponents(), "definition");
        }

        public PathSpec parentNode() {
            return new PathSpec(this.getPathComponents(), "parentNode");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec id() {
            return new PathSpec(this.getPathComponents(), "id");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withDefinition() {
            this.getDataMap().put("definition", 1);
            return this;
        }

        public ProjectionMask withParentNode() {
            this.getDataMap().put("parentNode", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withId() {
            this.getDataMap().put("id", 1);
            return this;
        }
    }
}

